/*
Rollback AHOBPR 3.0.19
*/
GO
SET ANSI_NULLS, ANSI_PADDING, ANSI_WARNINGS, ARITHABORT, CONCAT_NULL_YIELDS_NULL, QUOTED_IDENTIFIER ON;

SET NUMERIC_ROUNDABORT OFF;


GO
:setvar DatabaseName "Registry"
GO
:on error exit
GO
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following:
SET NOEXEC OFF; 
*/
:setvar __IsSqlCmdEnabled "True"
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOEXEC ON;
    END


GO
USE [$(DatabaseName)];


GO
-------------------------------------------------------------------------------------
-- Remove all programmable objects (including views)
-- so that they can be re-created later in the script
-------------------------------------------------------------------------------------

begin transaction 

declare @ObjectName varchar(100), @statement nvarchar(4000),@direction varchar(4) = 'ASC';
--
-- Drop all ahobpr procedures... they will be added back fresh
--
with ahobprSch as (select * from sys.schemas where name = 'AHOBPR')
      ,sproc as (select * from sys.procedures where schema_id = (select schema_id from ahobprSch))
  select top 1 @ObjectName = name from sproc;

--print @ObjectName;
set @statement = 'drop procedure ahobpr.' + @ObjectName

while @statement is not null
begin
  begin try
    if @direction = 'ASC'
    begin
      with ahobprSch as (select * from sys.schemas where name = 'AHOBPR')
          ,sproc as (select * from sys.procedures where schema_id = (select schema_id from ahobprSch))
      select top 1 @ObjectName = name from sproc order by name;
    end
    else 
      with ahobprSch as (select * from sys.schemas where name = 'AHOBPR')
          ,sproc as (select * from sys.procedures where schema_id = (select schema_id from ahobprSch))
      select top 1 @ObjectName = name from sproc order by name desc;

    set @statement = 'drop procedure ahobpr.' + @ObjectName
    print  @statement
    exec sp_executesql @statement;

    set @ObjectName = null;
  end try
  begin catch
    print '*** toggling the delete direction ***';
    if @direction = 'ASC'
      set @direction = 'DESC'
    else
      set @direction = 'ASC'
  end catch;
end;

--
-- drop all ahobpr views... they will be added back fresh
--
if exists (select * from sys.views where name = 'VIEW_LOOKUP' 
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR'))
  drop view ahobpr.[VIEW_LOOKUP];
  
with ahobprSch as (select * from sys.schemas where name = 'AHOBPR')
    ,v as (select * from sys.views where schema_id = (select schema_id from ahobprSch))
select top 1 @ObjectName = name from v;

--print @ObjectName;
set @statement = 'drop view ahobpr.[' + @ObjectName + ']';

while @statement is not null
begin
  begin try
    if @direction = 'ASC'
    begin
      with ahobprSch as (select * from sys.schemas where name = 'AHOBPR')
          ,v as (select * from sys.views where schema_id = (select schema_id from ahobprSch))
      select top 1 @ObjectName = name from v order by name;
    end
    else
      with ahobprSch as (select * from sys.schemas where name = 'AHOBPR')
          ,v as (select * from sys.views where schema_id = (select schema_id from ahobprSch))
      select top 1 @ObjectName = name from v order by name desc
      ;
    set @statement = 'drop view ahobpr.[' + @ObjectName + ']';
    print  @statement
    exec sp_executesql @statement;
    set @ObjectName = null;
  end try
  begin catch
    print '*** toggling the delete direction ***';
    if @direction = 'ASC'
      set @direction = 'DESC'
    else
      set @direction = 'ASC'
  end catch;
end;


--declare @ObjectName varchar(64),@statement varchar(4000);
with ahobprSch as (select * from sys.schemas where name = 'AHOBPR')
    ,v as (select * from sys.objects where type_desc like '%function%' and schema_id = (select schema_id from ahobprSch))
  select top 1 @ObjectName = name from v order by name;

set @statement = 'drop function ahobpr.' + @ObjectName
print  @statement
exec sp_executesql @statement;

while @statement is not null
begin
  begin try
    set @ObjectName = null;
    if @direction = 'ASC'
    begin
      with ahobprSch as (select * from sys.schemas where name = 'AHOBPR')
          ,v as (select * from sys.objects where type_desc like '%function%' and schema_id = (select schema_id from ahobprSch))
        select top 1 @ObjectName = name from v order by name;
    end
    else 
      with ahobprSch as (select * from sys.schemas where name = 'AHOBPR')
          ,v as (select * from sys.objects where type_desc like '%function%' and schema_id = (select schema_id from ahobprSch))
        select top 1 @ObjectName = name from v order by name desc;

    set @statement = 'drop function ahobpr.' + @ObjectName
    print  @statement

    exec sp_executesql @statement;
  end try
  begin catch
    print '*** toggling the delete direction ***';
    if @direction = 'ASC'
      set @direction = 'DESC'
    else
      set @direction = 'ASC'
  end catch;
end;


commit;

-----------------------------------------------------------------------------
-- Undo changes to tables
-----------------------------------------------------------------------------
PRINT N'Dropping [AHOBPR].[DF_REGISTRANT_JSON_FOLLOWUP_SYSTEM_WIDE_FLAG]...';


GO
if exists (select * from sys.default_constraints 
            where name = 'DF_REGISTRANT_JSON_FOLLOWUP_SYSTEM_WIDE_FLAG'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'REGISTRANT_JSON_FOLLOWUP'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[REGISTRANT_JSON_FOLLOWUP] DROP CONSTRAINT [DF_REGISTRANT_JSON_FOLLOWUP_SYSTEM_WIDE_FLAG];


GO
PRINT N'Dropping [AHOBPR].[DF_CPRS_LOG_UPDATED]...';


GO
if exists (select * from sys.default_constraints 
            where name = 'DF_CPRS_LOG_UPDATED'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'CPRS_LOG'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[CPRS_LOG] DROP CONSTRAINT [DF_CPRS_LOG_UPDATED];


GO
PRINT N'Dropping [AHOBPR].[DF_CPRS_LOG_CREATED]...';


GO
if exists (select * from sys.default_constraints 
            where name = 'DF_CPRS_LOG_CREATED'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'CPRS_LOG'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[CPRS_LOG] DROP CONSTRAINT [DF_CPRS_LOG_CREATED];


GO
PRINT N'Dropping [AHOBPR].[DF_RegistrantFacility_Updated]...';


GO
if exists (select * from sys.default_constraints 
            where name = 'DF_RegistrantFacility_Updated'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'REGISTRANT_FACILITY'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[REGISTRANT_FACILITY] DROP CONSTRAINT [DF_RegistrantFacility_Updated];


GO
PRINT N'Dropping [AHOBPR].[DF_RegistrantFacility_Created]...';


GO
if exists (select * from sys.default_constraints 
            where name = 'DF_RegistrantFacility_Created'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'REGISTRANT_FACILITY'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[REGISTRANT_FACILITY] DROP CONSTRAINT [DF_RegistrantFacility_Created];


GO
PRINT N'Dropping [AHOBPR].[DF_RegistrantFacility_ClosestFacilityReportFlag]...';


GO
if exists (select * from sys.default_constraints 
            where name = 'DF_RegistrantFacility_ClosestFacilityReportFlag'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'REGISTRANT_FACILITY'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[REGISTRANT_FACILITY] DROP CONSTRAINT [DF_RegistrantFacility_ClosestFacilityReportFlag];


GO
PRINT N'Dropping [AHOBPR].[DF_EMAIL_TEMPLATES_USER_FLAG]...';


GO
if exists (select * from sys.default_constraints 
            where name = 'DF_EMAIL_TEMPLATES_USER_FLAG'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'EMAIL_TEMPLATES'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[EMAIL_TEMPLATES] DROP CONSTRAINT [DF_EMAIL_TEMPLATES_USER_FLAG];


GO
PRINT N'Dropping [AHOBPR].[df_email_templates_h_user_flag]...';


GO
if exists (select * from sys.default_constraints 
            where name = 'df_email_templates_h_user_flag'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'EMAIL_TEMPLATES_H'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[EMAIL_TEMPLATES_H] DROP CONSTRAINT [df_email_templates_h_user_flag];


GO
PRINT N'Dropping [AHOBPR].[DF_RegJsonRecCreated]...';


GO
if exists (select * from sys.default_constraints 
            where name = 'DF_RegJsonRecCreated'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'REGISTRANT_JSON_H'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[REGISTRANT_JSON_H] DROP CONSTRAINT [DF_RegJsonRecCreated];


GO
PRINT N'Dropping [AHOBPR].[DF_TOOL_FORM_SYSTEM_WIDE_FLAG]...';


GO
if exists (select * from sys.default_constraints 
            where name = 'DF_TOOL_FORM_SYSTEM_WIDE_FLAG'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'TOOL_FORM'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[TOOL_FORM] DROP CONSTRAINT [DF_TOOL_FORM_SYSTEM_WIDE_FLAG];


GO
PRINT N'Dropping [AHOBPR].[FK_AUDIT_LOG_AUDIT_LOG_TYPE]...';


GO
if exists (select * from sys.foreign_keys 
            where name = 'FK_AUDIT_LOG_AUDIT_LOG_TYPE'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'AUDIT_LOG'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[AUDIT_LOG] DROP CONSTRAINT [FK_AUDIT_LOG_AUDIT_LOG_TYPE];


GO
PRINT N'Dropping [AHOBPR].[FK_EMAIL_LOG_REGISTRANT]...';


GO
if exists (select * from sys.foreign_keys 
            where name = 'FK_EMAIL_LOG_REGISTRANT'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'EMAIL_LOG'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[EMAIL_LOG] DROP CONSTRAINT [FK_EMAIL_LOG_REGISTRANT];


GO
PRINT N'Dropping [AHOBPR].[FK_QUEUE_STATUS_QUEUE]...';


GO
if exists (select * from sys.foreign_keys 
            where name = 'FK_QUEUE_STATUS_QUEUE'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'QUEUE_STATUS'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[QUEUE_STATUS] DROP CONSTRAINT [FK_QUEUE_STATUS_QUEUE];


GO
PRINT N'Dropping [AHOBPR].[FK_QUEUE_QUEUE_BATCH]...';


GO
if exists (select * from sys.foreign_keys 
            where name = 'FK_QUEUE_QUEUE_BATCH'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'QUEUE'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[QUEUE] DROP CONSTRAINT [FK_QUEUE_QUEUE_BATCH];


GO
PRINT N'Dropping [AHOBPR].[FK_QUEUE_STD_QUEUE_TYPE]...';


GO
if exists (select * from sys.foreign_keys 
            where name = 'FK_QUEUE_STD_QUEUE_TYPE'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'QUEUE'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[QUEUE] DROP CONSTRAINT [FK_QUEUE_STD_QUEUE_TYPE];


GO
PRINT N'Dropping [AHOBPR].[FK_QUEUE_BATCH_STD_QUEUE_TYPE]...';


GO
if exists ( select * from sys.foreign_keys 
            where name = 'FK_QUEUE_BATCH_STD_QUEUE_TYPE'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'QUEUE_BATCH'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[QUEUE_BATCH] DROP CONSTRAINT [FK_QUEUE_BATCH_STD_QUEUE_TYPE];


GO
PRINT N'Dropping [AHOBPR].[FK_CPRS_LOG_REGISTRANT]...';


GO
if exists ( select * from sys.foreign_keys 
            where name = 'FK_CPRS_LOG_REGISTRANT'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'CPRS_LOG'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[CPRS_LOG] DROP CONSTRAINT [FK_CPRS_LOG_REGISTRANT];


GO
PRINT N'Dropping [AHOBPR].[FK_QUEUE_REGISTRANT]...';


GO
if exists ( select * from sys.foreign_keys 
            where name = 'FK_QUEUE_REGISTRANT'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'QUEUE'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[QUEUE] DROP CONSTRAINT [FK_QUEUE_REGISTRANT];


GO
PRINT N'Dropping [AHOBPR].[FK_QUEUE_USER]...';


GO
if exists ( select * from sys.foreign_keys 
            where name = 'FK_QUEUE_USER'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'QUEUE'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[QUEUE] DROP CONSTRAINT [FK_QUEUE_USER];


GO
PRINT N'Dropping [AHOBPR].[FK_QUEUE_STATUS_REGISTRANT]...';


GO
if exists ( select * from sys.foreign_keys 
            where name = 'FK_QUEUE_STATUS_REGISTRANT'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'QUEUE_STATUS'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[QUEUE_STATUS] DROP CONSTRAINT [FK_QUEUE_STATUS_REGISTRANT];


GO
PRINT N'Dropping [AHOBPR].[FK_QUEUE_STATUS_USER]...';


GO
if exists ( select * from sys.foreign_keys 
            where name = 'FK_QUEUE_STATUS_USER'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'QUEUE_STATUS'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[QUEUE_STATUS] DROP CONSTRAINT [FK_QUEUE_STATUS_USER];


GO
PRINT N'Dropping [AHOBPR].[FK_REGISTRANT_FACILITY_REGISTRANT]...';


GO
if exists ( select * from sys.foreign_keys 
            where name = 'FK_REGISTRANT_FACILITY_REGISTRANT'
            and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
            and parent_object_id = (select object_id from sys.tables where name = 'REGISTRANT_FACILITY'
                                    and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                   )
           )
ALTER TABLE [AHOBPR].[REGISTRANT_FACILITY] DROP CONSTRAINT [FK_REGISTRANT_FACILITY_REGISTRANT];


GO
PRINT N'Dropping [AHOBPR].[CPRS_LOG]...';


GO
if exists ( select object_id from sys.tables where name = 'CPRS_LOG'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
DROP TABLE [AHOBPR].[CPRS_LOG];


GO
PRINT N'Dropping [AHOBPR].[QUEUE]...';


GO
if exists ( select object_id from sys.tables where name = 'QUEUE'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
DROP TABLE [AHOBPR].[QUEUE];


GO
PRINT N'Dropping [AHOBPR].[QUEUE_BATCH]...';


GO
if exists ( select object_id from sys.tables where name = 'QUEUE_BATCH'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
DROP TABLE [AHOBPR].[QUEUE_BATCH];


GO
PRINT N'Dropping [AHOBPR].[QUEUE_STATUS]...';


GO
if exists ( select object_id from sys.tables where name = 'QUEUE_STATUS'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
DROP TABLE [AHOBPR].[QUEUE_STATUS];


GO
PRINT N'Dropping [AHOBPR].[REGISTRANT_FACILITY]...';


GO
if exists ( select object_id from sys.tables where name = 'REGISTRANT_FACILITY'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
DROP TABLE [AHOBPR].[REGISTRANT_FACILITY];


GO
PRINT N'Dropping [AHOBPR].[SCRIPTS_BATCH]...';


GO
if exists ( select object_id from sys.tables where name = 'SCRIPTS_BATCH'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
DROP TABLE [AHOBPR].[SCRIPTS_BATCH];


GO
PRINT N'Dropping [AHOBPR].[STAGE_FORM_RESPONSE_ANSWER_ETL]...';


GO
if exists ( select object_id from sys.tables where name = 'STAGE_FORM_RESPONSE_ANSWER_ETL'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
DROP TABLE [AHOBPR].[STAGE_FORM_RESPONSE_ANSWER_ETL];


GO
PRINT N'Dropping [AHOBPR].[STAGE_FORM_RESPONSE_QUESTION_ETL]...';


GO
if exists ( select object_id from sys.tables where name = 'STAGE_FORM_RESPONSE_QUESTION_ETL'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
DROP TABLE [AHOBPR].[STAGE_FORM_RESPONSE_QUESTION_ETL];


GO
PRINT N'Dropping [AHOBPR].[STAGE_INTERFACE_CALL_LOG]...';


GO
if exists ( select object_id from sys.tables where name = 'STAGE_INTERFACE_CALL_LOG'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
DROP TABLE [AHOBPR].[STAGE_INTERFACE_CALL_LOG];


GO
PRINT N'Dropping [AHOBPR].[STAGE_LOG_DATAFIX]...';


GO
if exists ( select object_id from sys.tables where name = 'STAGE_LOG_DATAFIX'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
DROP TABLE [AHOBPR].[STAGE_LOG_DATAFIX];


GO
PRINT N'Dropping [AHOBPR].[STAGE_QARMAT_ALI]...';


GO
if exists ( select object_id from sys.tables where name = 'STAGE_QARMAT_ALI'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
DROP TABLE [AHOBPR].[STAGE_QARMAT_ALI];


GO
PRINT N'Dropping [AHOBPR].[STAGE_REGISTRANT_JSON_FOLLOWUP]...';


GO
if exists ( select object_id from sys.tables where name = 'STAGE_REGISTRANT_JSON_FOLLOWUP'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
DROP TABLE [AHOBPR].[STAGE_REGISTRANT_JSON_FOLLOWUP];


GO
PRINT N'Dropping [AHOBPR].[stage_USER_LOGIN_DETAIL]...';


GO
if exists ( select object_id from sys.tables where name = 'stage_USER_LOGIN_DETAIL'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
DROP TABLE [AHOBPR].[stage_USER_LOGIN_DETAIL];


GO
PRINT N'Dropping [AHOBPR].[STD_QUEUE_TYPE]...';
GO
if exists ( select object_id from sys.tables where name = 'STD_QUEUE_TYPE'
             and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
           )
DROP TABLE [AHOBPR].[STD_QUEUE_TYPE];


GO
/*
The column [AHOBPR].[AUDIT_LOG].[NUMBER_OF_REGISTRANTS] is being dropped, data loss could occur.
*/
GO
PRINT N'Starting rebuilding table [AHOBPR].[AUDIT_LOG]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
if exists (select object_id from sys.tables where name = 'AUDIT_LOG' 
           and schema_id = (select schema_id from sys.schemas where name ='AHOBPR')
            )
begin	
	BEGIN TRANSACTION;

	SET TRANSACTION ISOLATION LEVEL SERIALIZABLE;

	SET XACT_ABORT ON;

	CREATE TABLE [AHOBPR].[tmp_ms_xx_AUDIT_LOG] (
		[TYPE_ID]       TINYINT        NOT NULL,
		[USER_ID]       INT            NULL,
		[REGISTRANT_ID] INT            NULL,
		[MESSAGE]       VARCHAR (1000) NULL,
		[CREATED]       DATETIME       NOT NULL,
		[CREATEDBY]     VARCHAR (30)   NOT NULL,
		[UPDATED]       DATETIME       NOT NULL,
		[UPDATEDBY]     VARCHAR (30)   NOT NULL,
		[ROW_VERSION]   ROWVERSION     NOT NULL,
		[LOG_ID]        INT            IDENTITY (1, 1) NOT NULL,
		CONSTRAINT [tmp_ms_xx_constraint_PK_AUDIT_LOG] PRIMARY KEY CLUSTERED ([LOG_ID] ASC) ON [AHOBPR]
	);

	IF EXISTS (SELECT TOP 1 1 
			   FROM   [AHOBPR].[AUDIT_LOG])
		BEGIN
			SET IDENTITY_INSERT [AHOBPR].[tmp_ms_xx_AUDIT_LOG] ON;
			INSERT INTO [AHOBPR].[tmp_ms_xx_AUDIT_LOG] ([LOG_ID], [TYPE_ID], [USER_ID], [REGISTRANT_ID], [MESSAGE], [CREATED], [CREATEDBY], [UPDATED], [UPDATEDBY])
			SELECT   [LOG_ID],
					 [TYPE_ID],
					 [USER_ID],
					 [REGISTRANT_ID],
					 [MESSAGE],
					 [CREATED],
					 [CREATEDBY],
					 [UPDATED],
					 [UPDATEDBY]
			FROM     [AHOBPR].[AUDIT_LOG]
			ORDER BY [LOG_ID] ASC;
			SET IDENTITY_INSERT [AHOBPR].[tmp_ms_xx_AUDIT_LOG] OFF;
		END

	DROP TABLE [AHOBPR].[AUDIT_LOG];

	EXECUTE sp_rename N'[AHOBPR].[tmp_ms_xx_AUDIT_LOG]', N'AUDIT_LOG';

	EXECUTE sp_rename N'[AHOBPR].[tmp_ms_xx_constraint_PK_AUDIT_LOG]', N'PK_AUDIT_LOG', N'OBJECT';

	COMMIT TRANSACTION;
END;

SET TRANSACTION ISOLATION LEVEL READ COMMITTED;


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Altering [AHOBPR].[EMAIL_LOG]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
if exists (select object_id from sys.tables where name = 'EMAIL_LOG' 
                              and schema_id = (select schema_id from sys.schemas where name ='AHOBPR'))
begin                             
  if exists ( select column_id from sys.columns where name = 'REGISTRANT_ID'
              and object_id = (select object_id from sys.tables where name = 'EMAIL_LOG' 
                                and schema_id = (select schema_id from sys.schemas where name ='AHOBPR')
                              )
            )
    ALTER TABLE [AHOBPR].[EMAIL_LOG] ALTER COLUMN [REGISTRANT_ID] INT NOT NULL
  else 
    ALTER TABLE [AHOBPR].[EMAIL_LOG] ADD [REGISTRANT_ID] INT NOT NULL;
end;


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Altering [AHOBPR].[EMAIL_TEMPLATES]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO 
if exists ( select column_id from sys.columns where name = 'USER_FLAG'
              and object_id = (select object_id from sys.tables where name = 'EMAIL_TEMPLATES' 
                                and schema_id = (select schema_id from sys.schemas where name ='AHOBPR')
                              )
            )
ALTER TABLE [AHOBPR].[EMAIL_TEMPLATES] DROP COLUMN [USER_FLAG];


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
PRINT N'Altering [AHOBPR].[EMAIL_TEMPLATES_H]...';


GO
if exists ( select column_id from sys.columns where name = 'USER_FLAG'
              and object_id = (select object_id from sys.tables where name = 'EMAIL_TEMPLATES_H' 
                                and schema_id = (select schema_id from sys.schemas where name ='AHOBPR')
                              )
            )
ALTER TABLE [AHOBPR].[EMAIL_TEMPLATES_H] DROP COLUMN [USER_FLAG];


GO
/*
The column [AHOBPR].[REGISTRANT_JSON_FOLLOWUP].[SYSTEM_WIDE_FLAG] is being dropped, data loss could occur.
*/
GO
PRINT N'Starting rebuilding table [AHOBPR].[REGISTRANT_JSON_FOLLOWUP]...';


GO
if exists (select object_id from sys.tables where name = 'REGISTRANT_JSON_FOLLOWUP' 
           and schema_id = (select schema_id from sys.schemas where name ='AHOBPR')
            )
begin
	BEGIN TRANSACTION;

	SET TRANSACTION ISOLATION LEVEL SERIALIZABLE;

	SET XACT_ABORT ON;

	CREATE TABLE [AHOBPR].[tmp_ms_xx_REGISTRANT_JSON_FOLLOWUP] (
		[REGISTRANT_JSON_FOLLOWUP_ID] INT           IDENTITY (1, 1) NOT NULL,
		[OBJECT_ID]                   VARCHAR (256) NOT NULL,
		[OBJECT_TYPE]                 VARCHAR (100) NOT NULL,
		[INSTANCE_ID]                 VARCHAR (100) NOT NULL,
		[JSON_DATA]                   VARCHAR (MAX) NOT NULL,
		[STATUS]                      VARCHAR (100) NOT NULL,
		[CREATEDBY]                   VARCHAR (30)  NOT NULL,
		[UPDATEDBY]                   VARCHAR (30)  NOT NULL,
		[CREATED]                     DATETIME2 (0) NOT NULL,
		[UPDATED]                     DATETIME2 (0) NOT NULL,
		[ROW_VERSION]                 ROWVERSION    NOT NULL,
		CONSTRAINT [tmp_ms_xx_constraint_PK_REGISTRANT_JSON_FOLLOWUP_ID] PRIMARY KEY CLUSTERED ([REGISTRANT_JSON_FOLLOWUP_ID] ASC) ON [AHOBPR]
	) TEXTIMAGE_ON [AHOBPR];

	IF EXISTS (SELECT TOP 1 1 
			   FROM   [AHOBPR].[REGISTRANT_JSON_FOLLOWUP])
		BEGIN
			SET IDENTITY_INSERT [AHOBPR].[tmp_ms_xx_REGISTRANT_JSON_FOLLOWUP] ON;
			INSERT INTO [AHOBPR].[tmp_ms_xx_REGISTRANT_JSON_FOLLOWUP] ([REGISTRANT_JSON_FOLLOWUP_ID], [OBJECT_ID], [OBJECT_TYPE], [INSTANCE_ID], [JSON_DATA], [STATUS], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED])
			SELECT   [REGISTRANT_JSON_FOLLOWUP_ID],
					 [OBJECT_ID],
					 [OBJECT_TYPE],
					 [INSTANCE_ID],
					 [JSON_DATA],
					 [STATUS],
					 [CREATEDBY],
					 [UPDATEDBY],
					 [CREATED],
					 [UPDATED]
			FROM     [AHOBPR].[REGISTRANT_JSON_FOLLOWUP]
			ORDER BY [REGISTRANT_JSON_FOLLOWUP_ID] ASC;
			SET IDENTITY_INSERT [AHOBPR].[tmp_ms_xx_REGISTRANT_JSON_FOLLOWUP] OFF;
		END

	DROP TABLE [AHOBPR].[REGISTRANT_JSON_FOLLOWUP];

	EXECUTE sp_rename N'[AHOBPR].[tmp_ms_xx_REGISTRANT_JSON_FOLLOWUP]', N'REGISTRANT_JSON_FOLLOWUP';

	EXECUTE sp_rename N'[AHOBPR].[tmp_ms_xx_constraint_PK_REGISTRANT_JSON_FOLLOWUP_ID]', N'PK_REGISTRANT_JSON_FOLLOWUP_ID', N'OBJECT';

	COMMIT TRANSACTION;
END;
SET TRANSACTION ISOLATION LEVEL READ COMMITTED;


GO
PRINT N'Altering [AHOBPR].[STAGE_JSON_QUEUE_FOLLOWUP]...';


GO
if exists ( select column_id from sys.columns where name = 'audit_date'
              and object_id = (select object_id from sys.tables where name = 'STAGE_JSON_QUEUE_FOLLOWUP' 
                                and schema_id = (select schema_id from sys.schemas where name ='AHOBPR')
                              )
            )
ALTER TABLE [AHOBPR].[STAGE_JSON_QUEUE_FOLLOWUP] DROP COLUMN [audit_date];
GO

if exists ( select column_id from sys.columns where name = 'rowRank'
              and object_id = (select object_id from sys.tables where name = 'STAGE_JSON_QUEUE_FOLLOWUP' 
                                and schema_id = (select schema_id from sys.schemas where name ='AHOBPR')
                              )
            )
ALTER TABLE [AHOBPR].[STAGE_JSON_QUEUE_FOLLOWUP] DROP COLUMN [rowRank];


GO
PRINT N'Altering [AHOBPR].[TOOL_FORM]...';


GO

if exists ( select column_id from sys.columns where name = 'SYSTEM_WIDE_FLAG'
              and object_id = (select object_id from sys.tables where name = 'TOOL_FORM' 
                                and schema_id = (select schema_id from sys.schemas where name ='AHOBPR')
                              )
            )
ALTER TABLE [AHOBPR].[TOOL_FORM] DROP COLUMN [SYSTEM_WIDE_FLAG];


GO
PRINT N'Starting rebuilding table [AHOBPR].[STAGE_REGISTRANT_FILE]...';


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
SET QUOTED_IDENTIFIER ON;

SET ANSI_NULLS OFF;


GO
if exists (select object_id from sys.tables where name = 'STAGE_REGISTRANT_FILE' 
           and schema_id = (select schema_id from sys.schemas where name ='AHOBPR')
            )
begin			
	BEGIN TRANSACTION;

	SET TRANSACTION ISOLATION LEVEL SERIALIZABLE;

	SET XACT_ABORT ON;

	CREATE TABLE [AHOBPR].[tmp_ms_xx_STAGE_REGISTRANT_FILE] (
		[REGISTRANT_FILE_ID] UNIQUEIDENTIFIER           ROWGUIDCOL NOT NULL,
		[FILE_ID]            VARCHAR (256)              NOT NULL,
		[FILE_TYPE]          VARCHAR (256)              NOT NULL,
		[FILE_CONTENT]       VARBINARY (MAX) FILESTREAM NULL,
		[CREATEDBY]          VARCHAR (30)               NOT NULL,
		[UPDATEDBY]          VARCHAR (30)               NOT NULL,
		[CREATED]            DATETIME2 (0)              NOT NULL,
		[UPDATED]            DATETIME2 (0)              NOT NULL,
		CONSTRAINT [tmp_ms_xx_constraint_pk_STAGE_REGISTRANT_FILE] PRIMARY KEY CLUSTERED ([REGISTRANT_FILE_ID] ASC) ON [AHOBPR] FILESTREAM_ON [FILESTREAMGroup]
	);


	IF EXISTS (SELECT TOP 1 1 
			   FROM   [AHOBPR].[STAGE_REGISTRANT_FILE])
		BEGIN
			INSERT INTO [AHOBPR].[tmp_ms_xx_STAGE_REGISTRANT_FILE] ([REGISTRANT_FILE_ID], [FILE_ID], [FILE_TYPE], [FILE_CONTENT], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED])
			SELECT   [REGISTRANT_FILE_ID],
					 [FILE_ID],
					 [FILE_TYPE],
					 [FILE_CONTENT],
					 [CREATEDBY],
					 [UPDATEDBY],
					 [CREATED],
					 [UPDATED]
			FROM     [AHOBPR].[STAGE_REGISTRANT_FILE]
			ORDER BY [REGISTRANT_FILE_ID] ASC;
		END

	DROP TABLE [AHOBPR].[STAGE_REGISTRANT_FILE];

	EXECUTE sp_rename N'[AHOBPR].[tmp_ms_xx_STAGE_REGISTRANT_FILE]', N'STAGE_REGISTRANT_FILE';

	EXECUTE sp_rename N'[AHOBPR].[tmp_ms_xx_constraint_pk_STAGE_REGISTRANT_FILE]', N'pk_STAGE_REGISTRANT_FILE', N'OBJECT';

	COMMIT TRANSACTION;
end
else
begin

CREATE TABLE [AHOBPR].[STAGE_REGISTRANT_FILE](
	[REGISTRANT_FILE_ID] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FILE_ID] [varchar](256) NOT NULL,
	[FILE_TYPE] [varchar](256) NOT NULL,
	[FILE_CONTENT] [varbinary](max) FILESTREAM  NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime2](0) NOT NULL,
	[UPDATED] [datetime2](0) NOT NULL,
 CONSTRAINT [pk_STAGE_REGISTRANT_FILE] PRIMARY KEY CLUSTERED 
(
	[REGISTRANT_FILE_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR] FILESTREAM_ON [FILESTREAMGroup]
) ON [AHOBPR] FILESTREAM_ON [FILESTREAMGroup]


end;

SET TRANSACTION ISOLATION LEVEL READ COMMITTED;


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;


GO
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;
	
PRINT N'Starting rebuilding table [AHOBPR].[STAGE_REGISTRANT_FILE_DELETED]...';


GO
if exists (select object_id from sys.tables where name = 'STAGE_REGISTRANT_FILE_DELETED' 
           and schema_id = (select schema_id from sys.schemas where name ='AHOBPR')
            )
begin			
	BEGIN TRANSACTION;

	SET TRANSACTION ISOLATION LEVEL SERIALIZABLE;

	SET XACT_ABORT ON;

	CREATE TABLE [AHOBPR].[tmp_ms_xx_STAGE_REGISTRANT_FILE_DELETED] (
		[REGISTRANT_FILE_ID] UNIQUEIDENTIFIER           ROWGUIDCOL NOT NULL,
		[FILE_ID]            VARCHAR (256)              NOT NULL,
		[FILE_TYPE]          VARCHAR (256)              NOT NULL,
		[FILE_CONTENT]       VARBINARY (MAX) FILESTREAM NULL,
		[CREATEDBY]          VARCHAR (30)               NOT NULL,
		[UPDATEDBY]          VARCHAR (30)               NOT NULL,
		[CREATED]            DATETIME2 (0)              NOT NULL,
		[UPDATED]            DATETIME2 (0)              NOT NULL,
		CONSTRAINT [tmp_ms_xx_constraint_pk_STAGE_REGISTRANT_FILE_deleted] PRIMARY KEY CLUSTERED ([REGISTRANT_FILE_ID] ASC) ON [AHOBPR] FILESTREAM_ON [FILESTREAMGroup]
	);

	IF EXISTS (SELECT TOP 1 1 
			   FROM   [AHOBPR].[STAGE_REGISTRANT_FILE_DELETED])
		BEGIN
			INSERT INTO [AHOBPR].[tmp_ms_xx_STAGE_REGISTRANT_FILE_DELETED] ([REGISTRANT_FILE_ID], [FILE_ID], [FILE_TYPE], [FILE_CONTENT], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED])
			SELECT   [REGISTRANT_FILE_ID],
					 [FILE_ID],
					 [FILE_TYPE],
					 [FILE_CONTENT],
					 [CREATEDBY],
					 [UPDATEDBY],
					 [CREATED],
					 [UPDATED]
			FROM     [AHOBPR].[STAGE_REGISTRANT_FILE_DELETED]
			ORDER BY [REGISTRANT_FILE_ID] ASC;
		END

	DROP TABLE [AHOBPR].[STAGE_REGISTRANT_FILE_DELETED];

	EXECUTE sp_rename N'[AHOBPR].[tmp_ms_xx_STAGE_REGISTRANT_FILE_DELETED]', N'STAGE_REGISTRANT_FILE_DELETED';

	EXECUTE sp_rename N'[AHOBPR].[tmp_ms_xx_constraint_pk_STAGE_REGISTRANT_FILE_deleted]', N'pk_STAGE_REGISTRANT_FILE_deleted', N'OBJECT';

	COMMIT TRANSACTION;
end;

SET TRANSACTION ISOLATION LEVEL READ COMMITTED;


GO
PRINT N'Starting rebuilding table [AHOBPR].[JSON_QUEUE_FOLLOWUP]...';


GO
if exists (select object_id from sys.tables where name = 'JSON_QUEUE_FOLLOWUP' 
           and schema_id = (select schema_id from sys.schemas where name ='AHOBPR')
            )
BEGIN
	BEGIN TRANSACTION;

	SET TRANSACTION ISOLATION LEVEL SERIALIZABLE;

	SET XACT_ABORT ON;

	CREATE TABLE [AHOBPR].[tmp_ms_xx_JSON_QUEUE_FOLLOWUP] (
		[JSON_QUEUE_FOLLOWUP_ID]      INT           IDENTITY (1, 1) NOT NULL,
		[REGISTRANT_JSON_FOLLOWUP_ID] INT           NOT NULL,
		[ROW_VERSION]                 ROWVERSION    NOT NULL,
		[CREATEDBY]                   VARCHAR (30)  NOT NULL,
		[UPDATEDBY]                   VARCHAR (30)  NOT NULL,
		[CREATED]                     DATETIME2 (0) NOT NULL,
		[UPDATED]                     DATETIME2 (0) NOT NULL,
		CONSTRAINT [tmp_ms_xx_constraint_PK_JSON_QUEUE_FOLLOWUP] PRIMARY KEY CLUSTERED ([JSON_QUEUE_FOLLOWUP_ID] ASC) ON [AHOBPR]
	);

	IF EXISTS (SELECT TOP 1 1 
			   FROM   [AHOBPR].[JSON_QUEUE_FOLLOWUP])
		BEGIN
			SET IDENTITY_INSERT [AHOBPR].[tmp_ms_xx_JSON_QUEUE_FOLLOWUP] ON;
			INSERT INTO [AHOBPR].[tmp_ms_xx_JSON_QUEUE_FOLLOWUP] ([JSON_QUEUE_FOLLOWUP_ID], [REGISTRANT_JSON_FOLLOWUP_ID], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED])
			SELECT   [JSON_QUEUE_FOLLOWUP_ID],
					 [REGISTRANT_JSON_FOLLOWUP_ID],
					 [CREATEDBY],
					 [UPDATEDBY],
					 [CREATED],
					 [UPDATED]
			FROM     [AHOBPR].[JSON_QUEUE_FOLLOWUP]
			ORDER BY [JSON_QUEUE_FOLLOWUP_ID] ASC;
			SET IDENTITY_INSERT [AHOBPR].[tmp_ms_xx_JSON_QUEUE_FOLLOWUP] OFF;
		END

	DROP TABLE [AHOBPR].[JSON_QUEUE_FOLLOWUP];

	EXECUTE sp_rename N'[AHOBPR].[tmp_ms_xx_JSON_QUEUE_FOLLOWUP]', N'JSON_QUEUE_FOLLOWUP';

	EXECUTE sp_rename N'[AHOBPR].[tmp_ms_xx_constraint_PK_JSON_QUEUE_FOLLOWUP]', N'PK_JSON_QUEUE_FOLLOWUP', N'OBJECT';

	COMMIT TRANSACTION;
END;
SET TRANSACTION ISOLATION LEVEL READ COMMITTED;


GO
PRINT N'Starting rebuilding table [AHOBPR].[JSON_QUEUE_FOLLOWUP_STATUS]...';


GO
if exists (select object_id from sys.tables where name = 'JSON_QUEUE_FOLLOWUP_STATUS' 
           and schema_id = (select schema_id from sys.schemas where name ='AHOBPR')
            )
BEGIN
	BEGIN TRANSACTION;

	SET TRANSACTION ISOLATION LEVEL SERIALIZABLE;

	SET XACT_ABORT ON;

	CREATE TABLE [AHOBPR].[tmp_ms_xx_JSON_QUEUE_FOLLOWUP_STATUS] (
		[JSON_QUEUE_FOLLOWUP_STATUS_ID] INT            IDENTITY (1, 1) NOT NULL,
		[JSON_QUEUE_FOLLOWUP_ID]        INT            NOT NULL,
		[REGISTRANT_JSON_FOLLOWUP_ID]   INT            NOT NULL,
		[PROCESS_START_DATE]            DATETIME2 (0)  NULL,
		[PROCESS_COMPLETE_DATE]         DATETIME2 (0)  NULL,
		[PROCESS_STATUS]                VARCHAR (100)  NULL,
		[PROCESS_ERROR]                 VARCHAR (4000) NULL,
		[CREATEDBY]                     VARCHAR (30)   NOT NULL,
		[UPDATEDBY]                     VARCHAR (30)   NOT NULL,
		[CREATED]                       DATETIME2 (0)  NOT NULL,
		[UPDATED]                       DATETIME2 (0)  NOT NULL,
		CONSTRAINT [tmp_ms_xx_constraint_PK_JSON_QUEUE_FOLLOWUP_STATUS] PRIMARY KEY CLUSTERED ([JSON_QUEUE_FOLLOWUP_STATUS_ID] ASC) ON [AHOBPR]
	);

	IF EXISTS (SELECT TOP 1 1 
			   FROM   [AHOBPR].[JSON_QUEUE_FOLLOWUP_STATUS])
		BEGIN
			SET IDENTITY_INSERT [AHOBPR].[tmp_ms_xx_JSON_QUEUE_FOLLOWUP_STATUS] ON;
			INSERT INTO [AHOBPR].[tmp_ms_xx_JSON_QUEUE_FOLLOWUP_STATUS] ([JSON_QUEUE_FOLLOWUP_STATUS_ID], [JSON_QUEUE_FOLLOWUP_ID], [REGISTRANT_JSON_FOLLOWUP_ID], [PROCESS_START_DATE], [PROCESS_COMPLETE_DATE], [PROCESS_STATUS], [PROCESS_ERROR], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED])
			SELECT   [JSON_QUEUE_FOLLOWUP_STATUS_ID],
					 [JSON_QUEUE_FOLLOWUP_ID],
					 [REGISTRANT_JSON_FOLLOWUP_ID],
					 [PROCESS_START_DATE],
					 [PROCESS_COMPLETE_DATE],
					 [PROCESS_STATUS],
					 [PROCESS_ERROR],
					 [CREATEDBY],
					 [UPDATEDBY],
					 [CREATED],
					 [UPDATED]
			FROM     [AHOBPR].[JSON_QUEUE_FOLLOWUP_STATUS]
			ORDER BY [JSON_QUEUE_FOLLOWUP_STATUS_ID] ASC;
			SET IDENTITY_INSERT [AHOBPR].[tmp_ms_xx_JSON_QUEUE_FOLLOWUP_STATUS] OFF;
		END

	DROP TABLE [AHOBPR].[JSON_QUEUE_FOLLOWUP_STATUS];

	EXECUTE sp_rename N'[AHOBPR].[tmp_ms_xx_JSON_QUEUE_FOLLOWUP_STATUS]', N'JSON_QUEUE_FOLLOWUP_STATUS';

	EXECUTE sp_rename N'[AHOBPR].[tmp_ms_xx_constraint_PK_JSON_QUEUE_FOLLOWUP_STATUS]', N'PK_JSON_QUEUE_FOLLOWUP_STATUS', N'OBJECT';

	COMMIT TRANSACTION;
END;
SET TRANSACTION ISOLATION LEVEL READ COMMITTED;


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_ANSWER].[IX_Temp2]...';


GO

if not exists ( select * from sys.indexes where name = 'IX_Temp2'
              and object_id = (select object_id from sys.tables where name = 'FORM_RESPONSE_ANSWER' 
                                and schema_id = (select schema_id from sys.schemas where name ='AHOBPR')
                              )
            )
CREATE NONCLUSTERED INDEX [IX_Temp2]
    ON [AHOBPR].[FORM_RESPONSE_ANSWER]([UPDATEDBY] ASC)
    ON [AHOBPR];


GO
PRINT N'Creating [AHOBPR].[FORM_RESPONSE_QUESTION].[IX_Temp]...';


GO
if not exists ( select * from sys.indexes where name = 'IX_Temp'
              and object_id = (select object_id from sys.tables where name = 'FORM_RESPONSE_QUESTION' 
                                and schema_id = (select schema_id from sys.schemas where name ='AHOBPR')
                              )
            )
CREATE NONCLUSTERED INDEX [IX_Temp]
    ON [AHOBPR].[FORM_RESPONSE_QUESTION]([UPDATEDBY] ASC)
    ON [AHOBPR];


GO
PRINT N'Creating on [AHOBPR].[REGISTRANT_JSON_H].[RECORD_CREATED]...';


GO
if not exists (select * from sys.default_constraints 
                where parent_column_id = (select column_id from sys.columns where name = 'RECORD_CREATED'
                                          and object_id = (select object_id from sys.tables where name = 'REGISTRANT_JSON_H'
                                                                  and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                                                  )
                                          )
                and parent_object_id  = (select object_id from sys.tables where name = 'REGISTRANT_JSON_H'
                                        and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
                                        ) 
              )
ALTER TABLE [AHOBPR].[REGISTRANT_JSON_H]
    ADD DEFAULT (getdate()) FOR [RECORD_CREATED];


GO
PRINT N'Creating [AHOBPR].[df_question_deleted]...';


GO
IF exists (select object_id from sys.tables where name = 'STAGE_FORM_RESPONSE_QUESTION'
			and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
			) 
	if not exists (select * from sys.default_constraints 
					where name = 'df_question_deleted'
					and parent_column_id = (select column_id from sys.columns where name = 'deleted_flag'
											  and object_id = (select object_id from sys.tables where name = 'STAGE_FORM_RESPONSE_QUESTION'
																	  and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
																	  )
											  )
					and parent_object_id  = (select object_id from sys.tables where name = 'STAGE_FORM_RESPONSE_QUESTION'
											and schema_id = (select schema_id from sys.schemas where name = 'AHOBPR')
											) 
				  )
		ALTER TABLE [AHOBPR].[STAGE_FORM_RESPONSE_QUESTION]
			ADD CONSTRAINT [df_question_deleted] DEFAULT ((0)) FOR [deleted_flag];

GO
PRINT N'Creating [AHOBPR].[FK_EMAIL_LOG_REGISTRANT]...';


GO
if not exists (select * from sys.foreign_keys where name='FK_EMAIL_LOG_REGISTRANT' 
              and parent_object_id = (select object_id from sys.tables where name = 'EMAIL_LOG' 
                                and schema_id = (select schema_id from sys.schemas where name ='AHOBPR')
                              )
              )
ALTER TABLE [AHOBPR].[EMAIL_LOG] WITH NOCHECK
    ADD CONSTRAINT [FK_EMAIL_LOG_REGISTRANT] FOREIGN KEY ([REGISTRANT_ID]) REFERENCES [AHOBPR].[REGISTRANT] ([REGISTRANT_ID]);


GO
PRINT N'Altering [AHOBPR].[TRG_REGISTRANT_Ins_Upd]...';


GO
if exists (select * from sys.triggers where name = 'TRG_REGISTRANT_Ins_Upd')
  DROP TRIGGER [AHOBPR].[TRG_REGISTRANT_Ins_Upd];
GO
CREATE TRIGGER [AHOBPR].[TRG_REGISTRANT_Ins_Upd]
    ON [AHOBPR].[REGISTRANT]
    FOR INSERT, UPDATE
    AS
    BEGIN
        SET NoCount ON
        DECLARE @MetricsTypeId int = (SELECT STD_PROCESS_METRICS_TYPE_ID FROM STD_PROCESS_METRICS_TYPE WHERE PROCESS_METRICS  = 'Registrant Status Change');

        --set the [REGISTRANT_STATUS_LAST_UPDATED_DATE] field if a status change is detected
        UPDATE  [AHOBPR].[REGISTRANT]
          SET   [REGISTRANT_STATUS_LAST_UPDATED_DATE] = UPDATED
          WHERE EXISTS (
                          SELECT  *
                          FROM    deleted
                          INNER
                          JOIN    inserted
                            ON    inserted.REGISTRANT_ID = deleted.REGISTRANT_ID
                          WHERE   
                                  --inserted.REGISTRANT_ID            = deleted.REGISTRANT_ID AND--redundant
                                  ISNULL(inserted.STD_REGISTRANT_STATUS_ID,0) != ISNULL(deleted.STD_REGISTRANT_STATUS_ID,0)
                              AND [REGISTRANT].REGISTRANT_ID = inserted.REGISTRANT_ID
                        )
                AND ISNULL([REGISTRANT_STATUS_LAST_UPDATED_DATE],'2015-08-30') != UPDATED;

        --Insert a 'Registrant Status Change' events into AHOBPR.PROCESS_METRICS if changes are detected
        INSERT   
          INTO    AHOBPR.PROCESS_METRICS 
                  (
                    [REGISTRANT_ID],
                    [STD_PROCESS_METRICS_TYPE_ID],
                    [PROCESS_METRICS_VALUE],
                    [CREATEDBY],
                    [UPDATEDBY],
                    [CREATED],
                    [UPDATED]
                  )
          SELECT  [REGISTRANT_ID],
                  @MetricsTypeId,
                  s.REGISTRANT_STATUS,
                  inserted.[UPDATEDBY],
                  inserted.[UPDATEDBY],
                  inserted.[UPDATED],
                  inserted.[UPDATED]
          FROM
                  inserted
          JOIN    AHOBPR.STD_REGISTRANT_STATUS AS s
            ON    s.STD_REGISTRANT_STATUS_ID = inserted.STD_REGISTRANT_STATUS_ID
          WHERE   NOT EXISTS (
                              SELECT  *
                              FROM    deleted
                              WHERE   inserted.REGISTRANT_ID            = deleted.REGISTRANT_ID
                                  AND inserted.STD_REGISTRANT_STATUS_ID = deleted.STD_REGISTRANT_STATUS_ID
                            );
        --Temp workaround to a coding bug where create date is updated instead of updated
        --and to set update if not done programitically
	      WITH
	        Change AS
	        (
		        SELECT	A.CREATED AS NewCreated, A.UPDATED AS NewUpdated
                  , B.CREATED AS OldCreated, B.UPDATED AS OldUpdated
                  , A.REGISTRANT_ID
		        FROM	inserted AS A
		        INNER
		        JOIN	deleted AS B
		          ON	B.REGISTRANT_ID = A.REGISTRANT_ID
          )
        , Src AS
          ( SELECT *
            FROM Change
            WHERE NewCreated != CASE  WHEN NewCreated > NewUpdated 
                                          THEN CASE WHEN NewUpdated > OldUpdated
                                                    THEN CASE WHEN OldUpdated > OldCreated
                                                              THEN OldCreated 
                                                              ELSE OldUpdated  END
                                                    ELSE CASE WHEN NewUpdated > OldCreated
                                                              THEN OldCreated
                                                              ELSE NewUpdated END
                                                    END
                                          WHEN NewCreated > OldUpdated
                                          THEN CASE WHEN OldUpdated > OldCreated
                                                    THEN OldCreated 
                                                    ELSE OldUpdated  END
                                          ELSE CASE WHEN NewCreated > OldCreated
                                                    THEN OldCreated
                                                    ELSE NewCreated END
                                          END
                   OR NewUpdated != CASE  WHEN NewCreated < NewUpdated 
                                          THEN CASE WHEN NewUpdated < OldUpdated
                                                    THEN CASE WHEN OldUpdated < OldCreated
                                                              THEN OldCreated 
                                                              ELSE OldUpdated  END
                                                    ELSE CASE WHEN NewUpdated < OldCreated
                                                              THEN OldCreated
                                                              ELSE CASE WHEN NewUpdated = OldUpdated AND NewUpdated < DATEADD(SECOND,-1, GETDATE())
                                                                        THEN GETDATE() --make sure that updated field is actually updated
                                                                        ELSE NewUpdated END
                                                              END
                                                    END
                                          WHEN NewCreated < OldUpdated
                                          THEN CASE WHEN OldUpdated < OldCreated
                                                    THEN OldCreated 
                                                    ELSE OldUpdated  END
                                          ELSE CASE WHEN NewCreated < OldCreated
                                                    THEN OldCreated
                                                    ELSE NewCreated END
                                          END
	        )
	          MERGE
	            INTO	  AHOBPR.REGISTRANT AS Tgt
	            USING	  Src
	              ON	  Src.REGISTRANT_ID = Tgt.REGISTRANT_ID
		
	            WHEN	  MATCHED
	            THEN	  UPDATE 
                      SET CREATED = CASE  WHEN NewCreated > NewUpdated 
                                          THEN CASE WHEN NewUpdated > OldUpdated
                                                    THEN CASE WHEN OldUpdated > OldCreated
                                                              THEN OldCreated 
                                                              ELSE OldUpdated  END
                                                    ELSE CASE WHEN NewUpdated > OldCreated
                                                              THEN OldCreated
                                                              ELSE NewUpdated END
                                                    END
                                          WHEN NewCreated > OldUpdated
                                          THEN CASE WHEN OldUpdated > OldCreated
                                                    THEN OldCreated 
                                                    ELSE OldUpdated  END
                                          ELSE CASE WHEN NewCreated > OldCreated
                                                    THEN OldCreated
                                                    ELSE NewCreated END
                                          END
                        , UPDATED = CASE  WHEN NewCreated < NewUpdated 
                                          THEN CASE WHEN NewUpdated < OldUpdated
                                                    THEN CASE WHEN OldUpdated < OldCreated
                                                              THEN OldCreated 
                                                              ELSE OldUpdated  END
                                                    ELSE CASE WHEN NewUpdated = OldUpdated AND NewUpdated < DATEADD(SECOND,-1, GETDATE())
                                                         THEN GETDATE() --make sure that updated field is actually updated
                                                         ELSE NewUpdated END
                                                    END
                                          WHEN NewCreated < OldUpdated
                                          THEN CASE WHEN OldUpdated < OldCreated
                                                    THEN OldCreated 
                                                    ELSE OldUpdated  END
                                          ELSE CASE WHEN NewCreated < OldCreated
                                                    THEN OldCreated
                                                    ELSE NewCreated END
                                          END;
                
    END
GO

-------------------------------------------
-- VIEWS ----------------------------------
-------------------------------------------
CREATE VIEW [AHOBPR].[VIEW_REGISTRANT]
AS SELECT 
       reg.REGISTRANT_ID,
       reg.LAST_NAME + ', ' + reg.FIRST_NAME + ' ' + reg.MIDDLE_NAME AS REGISTRANT_FULL_NAME,
       reg.LAST_NAME,
       reg.FIRST_NAME,
       reg.MIDDLE_NAME,

       reg.STD_REGISTRANT_STATUS_ID,       
       regStat.REGISTRANT_STATUS,
       ISNULL(reg.REGISTRANT_STATUS_LAST_UPDATED_DATE, reg.UPDATED)   AS REGISTRANT_STATUS_LAST_UPDATED_DATE,
       DATEDIFF( DAY, ISNULL(reg.REGISTRANT_STATUS_LAST_UPDATED_DATE
                    , reg.UPDATED), GETDATE())                        AS REGISTRANT_DAYS_AT_CURRENT_STATUS,
       reg.[HEALTH_CONCERNS_RESPONSE]                                 AS REGISTRANT_HEALTH_CONCERNS_RESPONSE,
       reg.[REQUEST_SEEN_RESPONSE]                                    AS REGISTRANT_REQUEST_SEEN_RESPONSE,
       
       reg.BIRTH_DATE                                                 AS REGISTRANT_BIRTH_DATE,
       DATEDIFF(YEAR, reg.BIRTH_DATE, GETDATE())                      AS REGISTRANT_AGE,
       reg.GENDER                                                     AS REGISTRANT_GENDER,
       reg.STD_INSTITUTION_ID                                         AS REGISTRANT_ASSIGNED_INSTITUTION_ID,
       i.NAME                                                         AS REGISTRANT_ASSIGNED_INSTITUTION_NAME,
       reg.STD_SERVICE_STATUS_ID                                      AS REGISTRANT_STD_SERVICE_STATUS_ID, 
       
       reg.EDIPI                                                      AS REGISTRANT_EDIPI,
       SSN                                                            AS REGISTRANT_SSN,
       RIGHT(REG.SSN, 4)                                              AS REGUSTRANT_LAST_FOUR,
       USER_ID                                                        AS REGISTRANT_USER_ID,
       
       REG.CREATEDBY               AS REGISTRANT_CREATEDBY,
       REG.CREATED                 AS REGISTRANT_CREATED,
       REG.UPDATED                 AS REGISTRANT_UPDATED,
       REG.UPDATEDBY               ASREGISTRANT_UPDATEDBY
  FROM AHOBPR.REGISTRANT reg 
  LEFT
  JOIN  dbo.STD_INSTITUTION I
    ON  I.ID = reg.[STD_INSTITUTION_ID]
  JOIN  AHOBPR.STD_REGISTRANT_STATUS regStat
    ON  regStat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID;

    -- SELECT * FROM [AHOBPR].[VIEW_REGISTRANT]

GO
/****** Object:  View [AHOBPR].[VIEW_REGISTRANT_DEPLOYMENT]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [AHOBPR].[VIEW_REGISTRANT_DEPLOYMENT]
AS SELECT  
        R.REGISTRANT_FULL_NAME              AS DEPLOYED_REGISTRANT_FULL_NAME
      , [REGISTRANT_DEPLOYMENT_ID]   
      , D.[DEPLOYMENT_COUNTRY]  
      , D.[DEPLOYMENT_BASE]  
      , D.[DEPLOYMENT_START_DATE]   
      , D.[DEPLOYMENT_END_DATE]
      , D. [IS_ELIGIBLE_FLAG]               AS DEPLOYMENT_IS_ELIGIBLE_FLAG
      , D.[STD_BRANCH_OF_SERVICE_ID]        AS DEPLOYMENT_BRANCH_OF_SERVICE_ID
      , [BRANCH_OF_SERVICE]                 AS DEPLOYMENT_BRANCH_OF_SERVICE
      , [DUTY_PROJECT_CODE]
      , [USER_ENTERED_FLAG]         
      , [USER_VERIFIED_FLAG]

      , D.[STD_SERVICE_OCCUPATION_ID]       AS DEPLOYMENT_SERVICE_OCCUPATION_ID
      , [SERVICE_OCCUPATION_CODE]           AS DEPLOYMENT_SERVICE_OCCUPATION_CODE
      , [SERVICE_TITLE]                     AS DEPLOYMENT_SERVICE_TITLE
      , [MILITARY_RANK]                     AS DEPLOYMENT_MILITARY_RANK
      , [DEPLOYMENT_UIC]
      , [IS_GULF_WAR_VETERAN_FLAG]
      , D.[STD_COMPONENT_ID]                AS DEPLOYMENT_COMPONENT_ID
      , C.[CATEGORY_CODE]                   AS DEPLOYMENT_COMPONENT_CATEGORY_CODE
      , C.[DESCRIPTION]                     AS DEPLOYMENT_COMPONENT
      , R.*
FROM    [AHOBPR].[VIEW_REGISTRANT] AS R
JOIN    [AHOBPR].[REGISTRANT_DEPLOYMENT] AS D
  ON    R.[REGISTRANT_ID] = D.[REGISTRANT_ID]
LEFT
JOIN    [AHOBPR].[STD_BRANCH_OF_SERVICE] BoS
  ON    BoS.[STD_BRANCH_OF_SERVICE_ID] = D.[STD_BRANCH_OF_SERVICE_ID]
LEFT
JOIN    [AHOBPR].[STD_SERVICE_OCCUPATION] SO
  ON    SO.[STD_SERVICE_OCCUPATION_ID] = D.[STD_SERVICE_OCCUPATION_ID]
LEFT
JOIN    [AHOBPR].[STD_COMPONENT] C
  ON    C.[STD_COMPONENT_ID] = D.[STD_COMPONENT_ID];
  

GO
/****** Object:  View [AHOBPR].[VIEW_REGISTRANT_QUESTION]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [AHOBPR].[VIEW_REGISTRANT_QUESTION]
AS SELECT  
           r.REGISTRANT_ID                        AS ASKED_REGISTRANT_ID
         , R.REGISTRANT_FULL_NAME                 AS ASKED_REGISTRANT_NAME
         , SFQ.[FORM_QUESTION_UNIQUE_ID]
         , PQ.[SHORT_TEXT]                AS PARENT_QUESTION_TEXT
         , SFQ.[SHORT_TEXT]               AS QUESTION_TEXT
         , SFQ.[TYPE]                     AS QUESTION_TYPE
         , FRQ.[STARTED_DATE]             AS QUESTION_STARTED_DATE
         , FRQ.[COMPLETED_DATE]           AS QUESTION_COMPLETED_DATE
         , FR.FORM_RESPONSE_ID
         , FRQ.FORM_RESPONSE_QUESTION_ID
         , FRQ.[STD_FORM_QUESTION_ID] 
         , R.*
         , D.[REGISTRANT_DEPLOYMENT_ID]

        , D.[DEPLOYMENT_COUNTRY]  
        , D.[DEPLOYMENT_BASE]  
        , D.[DEPLOYMENT_START_DATE]   
        , D.[DEPLOYMENT_END_DATE]
        , D.DEPLOYMENT_IS_ELIGIBLE_FLAG
        , D.DEPLOYMENT_BRANCH_OF_SERVICE_ID
        , D.DEPLOYMENT_BRANCH_OF_SERVICE
        , D.[DUTY_PROJECT_CODE]
        , D.[USER_ENTERED_FLAG]         
        , D.[USER_VERIFIED_FLAG]

         , FR.CREATEDBY               AS RESPONSE_CREATEDBY
         , FR.CREATED                 AS RESPONSE_CREATED
         , FR.UPDATED                 AS RESPONSE_UPDATED
         , FR.UPDATEDBY               AS RESPONSE_UPDATEDBY
         , FRQ.CREATEDBY              AS RESPONSE_QUESTION_CREATEDBY
         , FRQ.CREATED                AS RESPONSE_QUESTION_CREATED
         , FRQ.UPDATEDBY              AS RESPONSE_QUESTION_UPDATEDBY
         , FRQ.UPDATED                AS RESPONSE_QUESTION_UPDATED
        
FROM    [AHOBPR].[VIEW_REGISTRANT] AS R
JOIN    [AHOBPR].[FORM_RESPONSE] AS FR
  ON    R.[REGISTRANT_ID] = FR.[REGISTRANT_ID]
JOIN    [AHOBPR].[FORM_RESPONSE_QUESTION] AS FRQ
  ON     FR.[FORM_RESPONSE_ID] = FRQ.[FORM_RESPONSE_ID]
JOIN    [AHOBPR].[STD_FORM_QUESTION] AS SFQ
  ON    FRQ.[STD_FORM_QUESTION_ID] = SFQ.[STD_FORM_QUESTION_ID]
LEFT
JOIN    [AHOBPR].[STD_FORM_QUESTION] AS PQ
  ON    PQ.[STD_FORM_QUESTION_ID] = SFQ.[PARENT_ID]
LEFT
JOIN    [AHOBPR].VIEW_REGISTRANT_DEPLOYMENT D
  ON    D.[REGISTRANT_DEPLOYMENT_ID] = FRQ.[REGISTRANT_DEPLOYMENT_ID];

GO
/****** Object:  View [AHOBPR].[VIEW_REGISTRANT_ANSWER]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [AHOBPR].[VIEW_REGISTRANT_ANSWER]
AS SELECT  SFA.[TEXT]                 AS ANSWER_TEXT
         , FRA.ANSWER_VALUE
         , ISNULL(SFA.[TEXT], ANSWER_VALUE)  AS ANSWER_COALESCED
         , SFA.[ORDER]                AS ANSWER_ORDER
         , SFA.[EDITABLE]             AS EDITABLE
         , SFA.HELP                   AS ANSWER_HELP
         , Q.*
        
FROM    [AHOBPR].VIEW_REGISTRANT_QUESTION AS Q
JOIN    [AHOBPR].[FORM_RESPONSE_ANSWER] AS FRA
  ON    Q.[FORM_RESPONSE_QUESTION_ID] = FRA.[FORM_RESPONSE_QUESTION_ID]
JOIN    [AHOBPR].[STD_FORM_ANSWER] AS SFA
  ON    FRA.[STD_FORM_ANSWER_ID] = SFA.[STD_FORM_ANSWER_ID];


GO
/****** Object:  View [AHOBPR].[VIEW_REGISTRANT_DEPLOYMENT_EXPOSURE_RESPONSE]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [AHOBPR].[VIEW_REGISTRANT_DEPLOYMENT_EXPOSURE_RESPONSE]
AS  SELECT  V.*
    FROM    AHOBPR.VIEW_REGISTRANT_DEPLOYMENT V
    JOIN    AHOBPR.VIEW_REGISTRANT_ANSWER exposure 
      ON    V.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID 
    WHERE FORM_QUESTION_UNIQUE_ID = '1.2.A';

GO
/****** Object:  View [AHOBPR].[VIEW_REGISTRANT_VISIT]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [AHOBPR].[VIEW_REGISTRANT_VISIT]
AS SELECT 
        R.REGISTRANT_ID           AS PATIENT_REGISTRANT_ID
      , R.REGISTRANT_FULL_NAME    AS PATIENT_NAME
      , V.[VISIT_DATE_TIME]
      , [EVALUATION_FLAG]
      , [APPOINTMENT_TYPE]
      , [STOP_CODE]
      , [VISTA_EncounterID]
      , [VISTA_Sta3n]
      , [VISTA_EligibilityStatus]
      , I.NAME                    AS INSTITUTION_NAME
      , VISTANAME
      , FT.NAME                   AS FACILITY_TYPE
      , CASE FT.ISMEDICALTREATING WHEN 1 THEN 'True' WHEN '0' THEN 'False' ELSE FT.ISMEDICALTREATING END AS IS_MEDICAL_TREATING
      , R.*
      , V.[CREATEDBY] AS VISIT_CREATED_BY
      , V.[UPDATEDBY] AS VISIT_UPDATEDBY
      , V.[CREATED]   AS VISIT_CREATED
      , V.[UPDATED]   AS VISIT_UPDATED
      
FROM    [AHOBPR].VIEW_REGISTRANT AS R
JOIN    [AHOBPR].[REGISTRANT_VISIT] V
  ON    V.REGISTRANT_ID = R.REGISTRANT_ID
LEFT
JOIN    dbo.STD_INSTITUTION I
  ON    I.ID = V.[STD_INSTITUTION_ID]
LEFT
JOIN    [dbo].[STD_FACILITYTYPE] FT
  ON    FT.[ID] = I.[STD_FACILITYTYPE_ID];


GO
/****** Object:  View [AHOBPR].[VIEW_REGISTRANT_EVALUATION]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [AHOBPR].[VIEW_REGISTRANT_EVALUATION]
AS SELECT *
  FROM VIEW_REGISTRANT_VISIT
  WHERE [EVALUATION_FLAG] = 'Y';


GO
/****** Object:  View [AHOBPR].[VIEW_REGISTRANT_STATUS]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [AHOBPR].[VIEW_REGISTRANT_STATUS] AS
WITH deployments AS
(
   SELECT REGISTRANT_ID, COUNT(*) AS NUMBER_OF_DEPLOYMENTS 
     FROM AHOBPR.REGISTRANT_DEPLOYMENT 
    GROUP BY REGISTRANT_ID
)
, Logins AS
(
  SELECT MAX(CREATED) AS LAST_LOGIN_DATE
      ,  MIN(CREATED) AS FIRST_LOGIN_DATE
      ,  COUNT(*) AS NUMBER_OF_LOGINS
      , USER_ID 
  FROM  AHOBPR.DATA_ACCESS_LOG
  WHERE PAGE_NAME = 'Login'
  GROUP BY USER_ID
)
SELECT 
       reg.REGISTRANT_FULL_NAME              AS STATUS_FULL_NAME,
       info.EDIPI_MISMATCHED_FLAG,
       info.EDIPI_VERIFIED_DATE,
       info.EULA_ACCEPTED_DATE,
       info.CONTACT_INFO_VERIFIED_DATE,
       frs.[FORM_RESPONSE_STATUS_ID],
       frs.[LAST_SECTION_ID],
       sfs.TITLE as LAST_SECTION,
       frs.[LAST_SUB_SECTION_ID],
       ssfs.TITLE as LAST_SUB_SECTION,
       frs.[QUESTIONNAIRE_STARTED_DATE],
       frs.[QUESTIONNAIRE_COMPLETED_DATE],
       frs.[UPDATED] AS QUESIONNAIRE_LAST_UPDATED,
       deployments.NUMBER_OF_DEPLOYMENTS,
       Logins.*,
       reg.*
  FROM AHOBPR.[VIEW_REGISTRANT] reg
  LEFT JOIN Logins
    ON LOGINs.USER_ID = reg.REGISTRANT_USER_ID
   LEFT JOIN AHOBPR.[REGISTRANT_RECORD_INFO] info
          ON info.REGISTRANT_ID = reg.REGISTRANT_ID
   LEFT JOIN AHOBPR.FORM_RESPONSE fr
          ON fr.REGISTRANT_ID = reg.REGISTRANT_ID
   LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS frs
          ON frs.FORM_RESPONSE_ID = fr.FORM_RESPONSE_ID
   LEFT JOIN deployments
          ON deployments.REGISTRANT_ID = reg.REGISTRANT_ID
   LEFT JOIN AHOBPR.STD_FORM_SECTION sfs
         ON sfs.STD_FORM_SECTION_ID = LAST_SECTION_ID
   LEFT JOIN AHOBPR.STD_FORM_SUB_SECTION ssfs
         ON ssfs.STD_FORM_SUB_SECTION_ID = LAST_SUB_SECTION_ID;

GO
/****** Object:  View [AHOBPR].[VIEW_REGISTRANT_STATUS_pre_2_0_2_1]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [AHOBPR].[VIEW_REGISTRANT_STATUS_pre_2_0_2_1] AS
WITH deployments AS
(
   SELECT REGISTRANT_ID, COUNT(*) AS NUMBER_OF_DEPLOYMENTS 
     FROM AHOBPR.REGISTRANT_DEPLOYMENT 
    GROUP BY REGISTRANT_ID
)
, Logins AS
(
  SELECT MAX(CREATED) AS LAST_LOGIN_DATE
      ,  MIN(CREATED) AS FIRST_LOGIN_DATE
      ,  COUNT(*) AS NUMBER_OF_LOGINS
      , USER_ID 
  FROM  AHOBPR.DATA_ACCESS_LOG
  WHERE PAGE_NAME = 'Login'
  GROUP BY USER_ID
)
SELECT 
       reg.REGISTRANT_FULL_NAME              AS STATUS_FULL_NAME,
       info.EDIPI_MISMATCHED_FLAG,
       info.EDIPI_VERIFIED_DATE,
       info.EULA_ACCEPTED_DATE,
       info.CONTACT_INFO_VERIFIED_DATE,
       frs.[FORM_RESPONSE_STATUS_ID],
       frs.[LAST_SECTION_ID],
       sfs.TITLE as LAST_SECTION,
       frs.[LAST_SUB_SECTION_ID],
       ssfs.TITLE as LAST_SUB_SECTION,
       frs.[QUESTIONNAIRE_STARTED_DATE],
       frs.[QUESTIONNAIRE_COMPLETED_DATE],
       frs.[UPDATED] AS QUESIONNAIRE_LAST_UPDATED,
       deployments.NUMBER_OF_DEPLOYMENTS,
       Logins.*,
       reg.*
  FROM AHOBPR.[VIEW_REGISTRANT] reg
  LEFT JOIN Logins
    ON LOGINs.USER_ID = reg.REGISTRANT_USER_ID
   LEFT JOIN AHOBPR.[REGISTRANT_RECORD_INFO] info
          ON info.REGISTRANT_ID = reg.REGISTRANT_ID
   LEFT JOIN AHOBPR.FORM_RESPONSE fr
          ON fr.REGISTRANT_ID = reg.REGISTRANT_ID
   LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS frs
          ON frs.FORM_RESPONSE_ID = fr.FORM_RESPONSE_ID
   LEFT JOIN deployments
          ON deployments.REGISTRANT_ID = reg.REGISTRANT_ID
   LEFT JOIN AHOBPR.STD_FORM_SECTION sfs
         ON sfs.STD_FORM_SECTION_ID = LAST_SECTION_ID
   LEFT JOIN AHOBPR.STD_FORM_SUB_SECTION ssfs
         ON ssfs.STD_FORM_SUB_SECTION_ID = LAST_SUB_SECTION_ID;

GO

/****** Object:  View [AHOBPR].[VIEW_ETL_LOOKUP]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE VIEW [AHOBPR].[VIEW_ETL_LOOKUP] WITH SCHEMABINDING AS

 WITH src
 AS( 
  SELECT DISTINCT
          'STD_MARITALSTATUS' AS [TYPE],
          [MARITAL_STATUS] AS [DESCRIPTION]
    FROM  [AHOBPR].[REGISTRANT]
  UNION
  SELECT DISTINCT
          'STD_GENDER' AS [TYPE],
          [GENDER]
    FROM  [AHOBPR].[REGISTRANT]
  UNION
  SELECT DISTINCT
          'STD_RACE' AS [TYPE],
          RACE
    FROM  [AHOBPR].[REGISTRANT]
  UNION
  SELECT DISTINCT
          'STD_ELIGIBLITYSTATUS' AS [TYPE],
          ELIGIBILITY_STATUS
    FROM  [AHOBPR].[REGISTRANT]
  UNION
  SELECT DISTINCT
          'STD_ETHNICITY' AS [TYPE],
          [ETHNICITY]
    FROM  [AHOBPR].[REGISTRANT]
 )
 SELECT [TYPE],
        ROW_NUMBER() OVER( ORDER BY [TYPE],[DESCRIPTION] ) AS ID,
        ISNULL([DESCRIPTION],'No Data Available') AS [DESCRIPTION]
   FROM Src;

go

/****** Object:  View [AHOBPR].[VIEW_LOOKUP]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

create VIEW [AHOBPR].[VIEW_LOOKUP] 
--last updated in 2.0.30.1 script
WITH SCHEMABINDING 
AS
SELECT 'REGISTRY_FLAG' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG
 WHERE STD_REGISTRY_FLAG_ID > 0
UNION ALL
SELECT 'REGISTRY_STATUS' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,ORDINAL_VALUE AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
 WHERE STD_REGISTRANT_STATUS_ID > 0
UNION ALL
SELECT 'REGISTRY_FLAG_TYPE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_TYPE_ID AS ID
       ,REGISTRY_FLAG_TYPE AS CODE
       ,REGISTRY_FLAG_TYPE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG_TYPE
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1 AND STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,ID 
       ,POSTALNAME AS CODE
       ,POSTALNAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM DBO.STD_STATE
WHERE COUNTRY_ID = 1006840
	  AND POSTALNAME IN ('AL', 'AK', 'AR', 'AZ', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 
	  'IA', 'ID', 'IL', 'IN', 'KS', 'KY', 'LA', 'MA', 'MD', 'ME', 'MI', 'MN', 'MO', 'MS', 
	  'MT', 'NC', 'ND', 'NE', 'NH', 'NJ', 'NM', 'NV', 'NY', 'OH', 'OK', 'OR', 'PA', 'RI', 
	  'SC', 'SD', 'TN', 'TX', 'UT', 'VA', 'VT', 'WA', 'WI', 'WV', 'WY', 'DC', 'AS', 'GU', 'PR', 'VI', 'MP', 'AA', 'AE', 'AP')
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,0 
       ,'Foreign Country/Other' AS CODE
       ,'Foreign Country/Other' AS NAME
       ,0 AS PARENT_ID
       ,9999 AS SORT_ORDER 
UNION ALL
SELECT 'ADMINTRACKING_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1
  AND STD_REGISTRY_FLAG_TYPE_ID = 1 
  AND (PREDEFINED = 0 
		OR (PREDEFINED = 1 AND REGISTRY_FLAG_NAME = 'Eligibility Review - More Documentation Needed'))--2.0.13.1 changed this line
UNION ALL
SELECT 'STD_SERVICE_STATUS' AS LOOKUP_TYPE  
	   ,STD_SERVICE_STATUS_ID As ID
       ,SERVICE_STATUS AS CODE
       ,SERVICE_STATUS AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_SERVICE_STATUS
 WHERE STD_SERVICE_STATUS_ID > 0
  UNION ALL
SELECT 'STD_FORM_QUESTION' AS LOOKUP_TYPE  
	     ,STD_FORM_QUESTION_ID As ID
       ,FORM_QUESTION_UNIQUE_ID AS CODE
       ,FORM_QUESTION_UNIQUE_ID AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM_QUESTION
UNION ALL
SELECT 'REGISTRY_STATUS_INELIGIBLE' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (3, 4, 5)
UNION ALL
SELECT 'REGISTRY_STATUS_REVIEWED' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (5, 8)
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,1 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,2 AS ID
       ,'Facility' AS CODE
       ,'Facility' AS NAME
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,3 AS ID
       ,'VISN' AS CODE
       ,'VISN' AS NAME
       ,0 AS PARENT_ID
       ,3 AS SORT_ORDER
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'ADMIN_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 1
UNION ALL
SELECT 'HEALTH_FACTOR' AS LOOKUP_TYPE
	     ,A.[STD_HEALTH_FACTOR_ID] AS ID
       ,A.[NAME] AS CODE
       ,B.[DESCRIPTION] + ': ' + A.DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[STD_HEALTH_FACTOR] A INNER JOIN [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY] B ON A.STD_HEALTH_FACTOR_CATEGORY_ID = B.STD_HEALTH_FACTOR_CATEGORY_ID
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT]
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY_EXPOSURE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] A JOIN AHOBPR.FORM_RESPONSE_QUESTION B
	ON A.REGISTRANT_DEPLOYMENT_ID = B.REGISTRANT_DEPLOYMENT_ID
	UNION ALL
SELECT 'STD_RACE' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_RACE'
  AND ID > 0
UNION ALL
SELECT 'STD_GENDER' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_GENDER'
  AND ID > 0
UNION ALL
SELECT 'STD_SEPARATIONFAMILY' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_FAMILY_ID] AS ID
        ,[FAMILY_CODE] AS CODE
        ,[FAMILY]  AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_FAMILY
  WHERE  [STD_SEPARATION_FAMILY_ID] > 0
 UNION ALL  
 SELECT 'STD_SEPARATIONREASON' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_REASON_ID] AS ID
        ,[REASON_CODE] AS CODE
        ,[REASON] AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_REASON
  WHERE  [STD_SEPARATION_REASON_ID] > 0
UNION ALL
SELECT 'STD_ELIGIBLITYSTATUS' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ELIGIBLITYSTATUS'
  AND ID > 0
UNION ALL
SELECT 'STD_ETHNICITY' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ETHNICITY'
  AND ID > 0
UNION ALL 
 SELECT 'STD_CHARACTEROFSERVICE' AS LOOKUP_TYPE  
	     ,STD_DISCHARGE_CHARACTER_ID As ID
       ,DISCHARGE_CHARACTER_CODE AS CODE
       ,DISCHARGE_CHARACTER AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_DISCHARGE_CHARACTER
UNION ALL
SELECT 'TEMPLATE_MESSAGE_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,TITLE AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True' AND CREATEDBY_ADVANCED_USER_FLAG = 0
  AND TITLE NOT IN ('Eligible for Burn Pit Registry', 'Not Eligible for Burn Pit Registry', 'New Follow-up Questions', 'Need More Documentation') 
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,2 As ID,'multipleChoice' AS CODE,'Dropdown List - Multiple Choice' AS NAME,0 AS PARENT_ID,1 AS SORT_ORDER
UNION ALL
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,1 As ID,'multiSelect' AS CODE,'Checkboxes - Multiple Select' AS NAME,0 AS PARENT_ID,2 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,3 As ID,'text' AS CODE,'Radio Buttons with Free Text' AS NAME,0 AS PARENT_ID,3 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,4 As ID,'number' AS CODE,'Radio Buttons with Numeric Value' AS NAME,0 AS PARENT_ID,4 AS SORT_ORDER
UNION ALL
SELECT 'FOLLOWUP_QUESTION_GROUP_LIST' AS LOOKUP_TYPE  
	   ,STD_FORM_ID AS ID
       ,NAME AS CODE
       ,NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM A
  WHERE FOLLOWUP_FLAG = 1
  --Follow up Send Page > Deactivated groups showing in Drop down (272277)
   AND NOT EXISTS (SELECT 'X' FROM AHOBPR.TOOL_FORM WHERE TOOL_FORM_ID = A.TOOL_FORM_ID AND ACTIVE_FLAG = 0)
UNION ALL
SELECT DISTINCT 'CONTACT_PREFERENCE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[CONTACT_PREFERENCE] AS CODE
       ,[CONTACT_PREFERENCE] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT]
  WHERE CONTACT_PREFERENCE > ''
UNION ALL
SELECT 'MY_TEMPLATES_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,CREATEDBY AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True' AND CREATEDBY_ADVANCED_USER_FLAG = 1
UNION ALL
SELECT DISTINCT 'ENROLLMENT_STATUS' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[ENROLLMENT_STATUS] AS CODE
       ,[ENROLLMENT_STATUS] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT]
   WHERE ENROLLMENT_STATUS > ''

-- select * from  [AHOBPR].[VIEW_LOOKUP]


GO
/****** Object:  View [AHOBPR].[VIEW_ETHNICITY]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE VIEW [AHOBPR].[VIEW_ETHNICITY] WITH SCHEMABINDING 
    AS SELECT 
    ID,
    ABBREVIATION,
    NAME,
    DESCRIPTION_TEXT
  FROM dbo.[STD_ETHNICITY]

GO
/****** Object:  View [AHOBPR].[VIEW_FACILITY_LOOKUP]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE VIEW [AHOBPR].[VIEW_FACILITY_LOOKUP]
AS
SELECT 'Visn' AS LOOKUP_TYPE  
  	   ,CASE WHEN len('0' + SUBSTRING(visn.NAME, 6, 5)) > 2 
                      THEN SUBSTRING(visn.NAME, 6, 5) 
                      ELSE '0' + SUBSTRING(visn.NAME, 6, 5) END AS ID
  	   ,'V'+CASE WHEN len('0' + SUBSTRING(visn.NAME, 6, 5)) > 2 
                      THEN SUBSTRING(visn.NAME, 6, 5) 
                      ELSE '0' + SUBSTRING(visn.NAME, 6, 5) END AS CODE
  	   ,'V'+ CASE WHEN len('0' + SUBSTRING(visn.NAME, 6, 5)) > 2 
                  THEN SUBSTRING(visn.NAME, 6, 5) 
                  ELSE '0' + SUBSTRING(visn.NAME, 6, 5) END AS NAME
       ,0 AS PARENT_ID
       ,CONVERT(INT, SUBSTRING(visn.NAME, 6, 5)) AS SORT_ORDER
       , 'V' + CASE WHEN len('0' + SUBSTRING(visn.NAME, 6, 5)) > 2 
                    THEN SUBSTRING(visn.NAME, 6, 5) 
                    ELSE '0' + SUBSTRING(visn.NAME, 6, 5) END AS VisnID
       ,CONVERT(INT,0) AS BASE_ID
  FROM dbo.STD_INSTITUTION AS visn
 WHERE SUBSTRING(visn.NAME,1,5) = 'VISN '
UNION ALL
SELECT 'MainFacility' AS LOOKUP_TYPE  
	     ,fac.ID
       ,fac.STATIONNUMBER AS CODE
       ,'(V' + SUBSTRING(visn.NAME, 6, 5) + ')(' + fac.STATIONNUMBER + ') ' 
                + fac.NAME + ', ' 
                + ISNULL(fac.STREETCITY, '') + ', ' 
                + ISNULL(S.POSTALNAME, '<blank name>') AS Name
       ,CONVERT(int, SUBSTRING(visn.NAME, 6, 5)) AS PARENT_ID
       ,CONVERT(int, SUBSTRING(visn.NAME, 6, 5)) AS SORT_ORDER
       ,'V' + CASE WHEN len('0' + SUBSTRING(visn.NAME, 6, 5)) > 2 
                   THEN SUBSTRING(visn.NAME, 6, 5) 
                   ELSE '0' + SUBSTRING(visn.NAME, 6, 5) END AS VisnID
       ,fac.ID AS BASE_ID
  FROM     dbo.STD_INSTITUTION visn
  JOIN     dbo.STD_INSTITUTION AS fac ON visn.ID = fac.VISN_ID 
LEFT JOIN  dbo.STD_STATE AS S ON S.ID = fac.STREETSTATE_ID
WHERE SUBSTRING(visn.NAME,1,5) = 'VISN '
  AND LEN(fac.STATIONNUMBER) = 3
UNION ALL
SELECT 'Facility' AS LOOKUP_TYPE  
	     ,fac.ID
       ,fac.STATIONNUMBER AS CODE
       ,'(V' + SUBSTRING(visn.NAME, 6, 5) + ')(' + fac.STATIONNUMBER + ') ' 
                + fac.NAME + ', ' 
                + ISNULL(fac.STREETCITY, '') + ', ' 
                + ISNULL(S.POSTALNAME, '<blank name>') AS Name
       ,base.ID AS  PARENT_ID
       ,CONVERT(int, SUBSTRING(visn.NAME, 6, 5)) AS SORT_ORDER
       ,'V' + CASE WHEN len('0' + SUBSTRING(visn.NAME, 6, 5)) > 2 
                   THEN SUBSTRING(visn.NAME, 6, 5) 
                   ELSE '0' + SUBSTRING(visn.NAME, 6, 5) END AS VisnID
       ,base.ID AS BASE_ID
  FROM     dbo.STD_INSTITUTION visn
  JOIN     dbo.STD_INSTITUTION AS fac ON visn.ID = fac.VISN_ID 
  JOIN     dbo.STD_INSTITUTION base ON base.STATIONNUMBER = SUBSTRING(fac.STATIONNUMBER,1,3)
LEFT JOIN  dbo.STD_STATE AS S ON S.ID = fac.STREETSTATE_ID
 WHERE SUBSTRING(visn.NAME,1,5) = 'VISN '
   AND LEN(fac.STATIONNUMBER) > 3
;

GO
/****** Object:  View [AHOBPR].[VIEW_FORM]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


CREATE VIEW [AHOBPR].[VIEW_FORM] AS 
SELECT AHOBPR.STD_FORM.STD_FORM_ID, AHOBPR.STD_FORM.NAME, AHOBPR.STD_FORM.VERSION, AHOBPR.STD_FORM.TITLE, 
	AHOBPR.STD_FORM_SECTION.STD_FORM_SECTION_ID, AHOBPR.STD_FORM_SECTION.TITLE AS SECTION, 
	AHOBPR.STD_FORM_SUB_SECTION.STD_FORM_SUB_SECTION_ID, AHOBPR.STD_FORM_SUB_SECTION.title AS SUBSECTION_TITLE, 
	AHOBPR.STD_FORM_SUB_SECTION.introduction AS SUBSECTION_INTRODUCTION, 
	AHOBPR.STD_FORM_QUESTION.STD_FORM_QUESTION_ID, AHOBPR.STD_FORM_QUESTION.TEXT, 
	AHOBPR.STD_FORM_QUESTION.TYPE, AHOBPR.STD_FORM_QUESTION.MIN, AHOBPR.STD_FORM_QUESTION.MAX, AHOBPR.STD_FORM_QUESTION.MAX_CHOICES,
	AHOBPR.STD_FORM_ANSWER.STD_FORM_ANSWER_ID, AHOBPR.STD_FORM_ANSWER.[ORDER], AHOBPR.STD_FORM_ANSWER.TEXT AS ANSWER_TEXT, 
	AHOBPR.STD_FORM_ANSWER.HELP, AHOBPR.STD_FORM_SECTION.BRP_FORM_SECTION_ID, AHOBPR.STD_FORM_SUB_SECTION.BRP_FORM_SUB_SECTION_ID, 
	AHOBPR.STD_FORM_QUESTION.BRP_FORM_QUESTION_ID, AHOBPR.STD_FORM_ANSWER.BRP_FORM_ANSWER_ID 
FROM AHOBPR.STD_FORM, AHOBPR.STD_FORM_SECTION,  AHOBPR.STD_FORM_SUB_SECTION, AHOBPR.STD_FORM_QUESTION, AHOBPR.STD_FORM_ANSWER
WHERE AHOBPR.STD_FORM.STD_FORM_ID = AHOBPR.STD_FORM_SECTION.STD_FORM_ID 
	  AND AHOBPR.STD_FORM_SECTION.STD_FORM_SECTION_ID = AHOBPR.STD_FORM_SUB_SECTION.STD_FORM_SECTION_ID 
	  AND AHOBPR.STD_FORM_SUB_SECTION.STD_FORM_SUB_SECTION_ID = AHOBPR.STD_FORM_QUESTION.STD_FORM_SUB_SECTION_ID
	  AND AHOBPR.STD_FORM_QUESTION.STD_FORM_QUESTION_ID = AHOBPR.STD_FORM_ANSWER.STD_FORM_QUESTION_ID

GO
/****** Object:  View [AHOBPR].[VIEW_HEALTH_FACTOR]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE VIEW [AHOBPR].[VIEW_HEALTH_FACTOR] WITH SCHEMABINDING 
    AS SELECT 
       A.REGISTRANT_HEALTH_FACTOR_ID, 
       A.REGISTRANT_VISIT_ID, 
       D.REGISTRANT_ID, 
       D.VISIT_DATE_TIME AS EVALUATION_DATE_TIME, 
       B.DESCRIPTION AS HEALTH_FACTOR, 
	     C.DESCRIPTION AS HEALTH_FACTOR_CATEGORY, 
	     C.TOOLTIP as CATEGORY_TOOLTIP, 
	     B.SORT_ORDER AS SORT_ORDER, 
	     B.STD_HEALTH_FACTOR_CATEGORY_ID
  FROM AHOBPR.[REGISTRANT_HEALTH_FACTOR] A, 
       AHOBPR.STD_HEALTH_FACTOR B, 
       AHOBPR.STD_HEALTH_FACTOR_CATEGORY C,
	     AHOBPR.REGISTRANT_VISIT D
 WHERE A.STD_HEALTH_FACTOR_ID = B.STD_HEALTH_FACTOR_ID 
   AND B.STD_HEALTH_FACTOR_CATEGORY_ID = C.STD_HEALTH_FACTOR_CATEGORY_ID
   AND A.REGISTRANT_VISIT_ID = D.REGISTRANT_VISIT_ID
   AND D.EVALUATION_FLAG = 'Y'

GO
/****** Object:  View [AHOBPR].[VIEW_INSTITUTION]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [AHOBPR].[VIEW_INSTITUTION]
AS
       SELECT  dbo.STD_INSTITUTION.ID, 
               dbo.STD_INSTITUTION.NAME,
               dbo.STD_INSTITUTION.STATIONNUMBER, 
               dbo.STD_INSTITUTION.VISTANAME, 
               dbo.STD_INSTITUTION.AGENCY_ID,
               dbo.STD_FACILITYTYPE.NAME AS FACILITY_TYPE,
               dbo.STD_INSTITUTION.MFN_ZEG_RECIPIENT, 
               dbo.STD_INSTITUTION.PARENT_ID, 
               dbo.STD_INSTITUTION.REALIGNEDFROM_ID, 
               dbo.STD_INSTITUTION.REALIGNEDTO_ID, 
               dbo.STD_INSTITUTION.VISN_ID, 
               dbo.STD_INSTITUTION.IS_ACTIVE, 
               dbo.STD_INSTITUTION.STREETADDRESSLINE1,  
               dbo.STD_INSTITUTION.STREETCITY, 
               dbo.STD_INSTITUTION.STREETPOSTALCODE, 
               dbo.STD_COUNTRY.SHORTNAME AS COUNTRY_NAME, 
               dbo.STD_COUNTRY.ALPHA3CODE AS COUNTRY_CODE, 
               dbo.STD_STATE.FIPSCODE AS STATE_CODE, 
               dbo.STD_STATE.NAME AS STATE_NAME, 
               dbo.STD_COUNTY.NAME AS COUNTY_NAME, 
               dbo.STD_COUNTY.COUNTYNUMBER, 
               dbo.STD_COUNTY.DESCRIPTION_TEXT AS COUNTY_DESC
         FROM  dbo.STD_INSTITUTION 
         JOIN  dbo.STD_FACILITYTYPE 
           ON  dbo.STD_INSTITUTION.STD_FACILITYTYPE_ID = dbo.STD_FACILITYTYPE.ID 
    LEFT JOIN  dbo.STD_COUNTY 
           ON  dbo.STD_INSTITUTION.STREETCOUNTY_ID = dbo.STD_COUNTY.ID 
    LEFT JOIN  dbo.STD_COUNTRY 
           ON  dbo.STD_INSTITUTION.STREETCOUNTRY_ID = dbo.STD_COUNTRY.ID 
    LEFT JOIN  dbo.STD_STATE 
           ON  dbo.STD_INSTITUTION.STREETSTATE_ID = dbo.STD_STATE.ID;
          
-- SELECT * FROM [AHOBPR].[VIEW_INSTITUTION]         

GO
/****** Object:  View [AHOBPR].[VIEW_INSTITUTION_NAME]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE VIEW [AHOBPR].[VIEW_INSTITUTION_NAME]
AS
       SELECT  dbo.STD_INSTITUTION.ID, 
               dbo.STD_INSTITUTION.NAME,
               dbo.STD_INSTITUTION.STATIONNUMBER, 
               dbo.STD_INSTITUTION.VISTANAME, 
               dbo.STD_INSTITUTION.AGENCY_ID,
               dbo.STD_FACILITYTYPE.NAME AS FACILITY_TYPE,
               dbo.STD_INSTITUTION.PARENT_ID,
               dbo.STD_INSTITUTION.VISN_ID               
         FROM  dbo.STD_INSTITUTION 
         JOIN  dbo.STD_FACILITYTYPE 
           ON  dbo.STD_INSTITUTION.STD_FACILITYTYPE_ID = dbo.STD_FACILITYTYPE.ID 
       UNION
       SELECT -1,
              'No Facitilty Assigned',
              'NULL',
              'No Facitilty Assigned',
              NULL,
              NULL,
              NULL,
              '-1'
              ;
          
-- SELECT TOP(100) * FROM [AHOBPR].[VIEW_INSTITUTION_NAME]         

GO
/****** Object:  View [AHOBPR].[VIEW_OPERATION_METRICS]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [AHOBPR].[VIEW_OPERATION_METRICS]
AS SELECT 
      ( select count(*)  from ahobpr.error_log
        where created >= cast(getdate() as date))errors_logged_today,
    
      ( select count(distinct user_id) 
        from ahobpr.data_access_log
        where page_name = 'login'
        and created >= cast(getdate() as date)) distinct_registrants_today,

      ( select count(*) 
      from ahobpr.data_access_log
      where page_name = 'public'
      and created >= cast(getdate() as date)) public_page_requests,

      ( select avg(public_page_requests) 
        from (
              select count(*) public_page_requests
              from ahobpr.data_access_log
              where page_name = 'public'
              and created between dateadd(day, -7, cast(getdate() as date)) and cast(getdate() as date)
              group by cast(created as date)
             ) src) avg_public_page_requests_per_day_last_7d,

      ( select avg(public_page_requests) 
        from (
              select count(*) public_page_requests
              from ahobpr.data_access_log
              where page_name = 'public'
              and created between dateadd(day, -30, cast(getdate() as date)) and cast(getdate() as date)
              group by cast(created as date)
             ) src ) avg_public_page_requests_per_day_last_30d,

      ( select avg(public_page_requests) 
        from (
              select count(*) public_page_requests
              from ahobpr.data_access_log
              where page_name = 'public'
              and created between '2015-11-01' and cast(getdate() as date)
              group by cast(created as date)
             ) src ) avg_public_page_requests_per_day_since_11_1_2015, 

      ( select avg(distinct_registrants_today) 
          from
          (
            select count(distinct user_id) distinct_registrants_today
            from ahobpr.data_access_log
            where page_name = 'login'
            and created between dateadd(day, -7, cast(getdate() as date)) and cast(getdate() as date)
            group by cast(created as date)
          ) src ) avg_reg_users_per_day_over_last_7d ,

      ( select avg(distinct_registrants_today) 
        from
        (
          select count(distinct user_id) distinct_registrants_today
          from ahobpr.data_access_log
          where page_name = 'login'
          and created between dateadd(day, -30, cast(getdate() as date)) and cast(getdate() as date)
          group by cast(created as date)
        ) src ) avg_reg_users_per_day_over_last_30d,


       ( select avg(distinct_registrants_today) 
          from
          (
            select count(distinct user_id) distinct_registrants_today
            from ahobpr.data_access_log
            where page_name = 'login'
            and created between '2015-11-01' and cast(getdate() as date)
            group by cast(created as date)
          ) src ) avg_reg_users_per_day_since_11_1_2015,

       ( select count(*) 
          from ahobpr.data_access_log
          where page_name = 'login'
          and created >= cast(getdate() as date) ) logins_today,

       ( select max(created) 
          from ahobpr.data_access_log
          where page_name = 'login' )last_registrant_login,

       ( select max(created) 
          from ahobpr.registrant_json
          where createdby = 'Restful Service' ) last_registrant_portal_save,

       ( select count(*) 
          from ahobpr.registrant_json
          where created >= cast(getdate() as date)
          and createdby = 'Restful Service' ) RegistrantPortalDataSaves_today, 

       ( select count(*) 
          from ahobpr.registrant_json
          where created >= cast(getdate() as date)
          and object_type = 'responses'
          and createdby = 'Restful Service' ) QuestionnaireSaves_today,

       ( select count(*) 
          from ahobpr.audit_log
          where created >= cast(getdate() as date)
          and  type_id = 1 ) clinical_user_logins,

       ( select count(*) 
          from ahobpr.form_response_status
          where questionnaire_completed_date between dateadd(day,-1, cast(getdate() as date)) and cast(getdate() as date) ) completed_questionnaires_yesterday,

       ( select avg(completed_questionnaires_per_day) 
          from (
                select count(*) completed_questionnaires_per_day
                from ahobpr.form_response_status
                where questionnaire_completed_date between dateadd(day,-7, cast(getdate() as date)) and cast(getdate() as date)
                group by cast(questionnaire_completed_date as date)
              ) src ) avg_questionniares_complete_per_day_last_7d,


       ( select avg(completed_questionnaires_per_day) 
        from (
                select count(*) completed_questionnaires_per_day
                from ahobpr.form_response_status
                where questionnaire_completed_date between dateadd(day,-30, cast(getdate() as date)) and cast(getdate() as date)
                group by cast(questionnaire_completed_date as date)
              ) src ) avg_questionniares_complete_per_day_last_30d, 


       ( select avg(completed_questionnaires_per_day) 
          from (
                select count(*) completed_questionnaires_per_day
                from ahobpr.form_response_status
                where questionnaire_completed_date between '2015-11-01' and cast(getdate() as date)
                group by cast(questionnaire_completed_date as date)
              ) src ) avg_questionniares_complete_per_day_since_11_1_2015,


       ( select avg(avg_mins_to_complete_top80pct) 
          from (  select avg(mins_to_complete_top80pct) avg_mins_to_complete_top80pct
                  from  (
                        select TOP (80) percent datediff(minute, questionnaire_started_date, questionnaire_completed_date) mins_to_complete_top80pct
                                      , cast(questionnaire_completed_date as date) questionnaire_completed_date
                        from ahobpr.form_response_status
                        where questionnaire_completed_date between dateadd(day,-7, cast(getdate() as date)) and cast(getdate() as date)
                        ORDER BY datediff(minute, questionnaire_started_date, questionnaire_completed_date)
                        ) daily
                  group by questionnaire_completed_date
                ) avg_daily ) avg_mins_to_complete_top80pct_last_7d,
    
       ( select avg(avg_mins_to_complete_top90pct) 
          from (  select avg(mins_to_complete_top90pct) avg_mins_to_complete_top90pct
                  from  (
                        select TOP (90) percent datediff(minute, questionnaire_started_date, questionnaire_completed_date) mins_to_complete_top90pct
                                      , cast(questionnaire_completed_date as date) questionnaire_completed_date
                        from ahobpr.form_response_status
                        where questionnaire_completed_date between dateadd(day,-7, cast(getdate() as date)) and cast(getdate() as date)
                        ORDER BY datediff(minute, questionnaire_started_date, questionnaire_completed_date)
                        ) daily
                  group by questionnaire_completed_date
                ) avg_daily ) avg_mins_to_complete_top90pct_last_7d,
    
       ( select avg(avg_mins_to_complete) 
          from (  select avg(mins_to_complete) avg_mins_to_complete
                  from  (
                        select  datediff(minute, questionnaire_started_date, questionnaire_completed_date) mins_to_complete
                              , cast(questionnaire_completed_date as date) questionnaire_completed_date
                        from ahobpr.form_response_status
                        where questionnaire_completed_date between dateadd(day,-7, cast(getdate() as date)) and cast(getdate() as date)
                        ) daily
                  group by questionnaire_completed_date
                ) avg_daily ) avg_mins_to_complete_last_7d,

       ( select avg(avg_mins_to_complete_top80pct) 
          from (  select avg(mins_to_complete_top80pct) avg_mins_to_complete_top80pct
                  from  (
                        select TOP (80) percent datediff(minute, questionnaire_started_date, questionnaire_completed_date) mins_to_complete_top80pct
                                      , cast(questionnaire_completed_date as date) questionnaire_completed_date
                        from ahobpr.form_response_status
                        where questionnaire_completed_date between dateadd(day,-30, cast(getdate() as date)) and cast(getdate() as date)
                        ORDER BY datediff(minute, questionnaire_started_date, questionnaire_completed_date)
                        ) daily
                  group by questionnaire_completed_date
                ) avg_daily ) avg_mins_to_complete_top80pct_last_30d,
    
      ( select avg(avg_mins_to_complete_top90pct) 
        from (  select avg(mins_to_complete_top90pct) avg_mins_to_complete_top90pct
                from  (
                      select TOP (90) percent datediff(minute, questionnaire_started_date, questionnaire_completed_date) mins_to_complete_top90pct
                                    , cast(questionnaire_completed_date as date) questionnaire_completed_date
                      from ahobpr.form_response_status
                      where questionnaire_completed_date between dateadd(day,-30, cast(getdate() as date)) and cast(getdate() as date)
                      ORDER BY datediff(minute, questionnaire_started_date, questionnaire_completed_date)
                      ) daily
                group by questionnaire_completed_date
              ) avg_daily ) avg_mins_to_complete_top90pct_last_30d,
    
        ( select avg(avg_mins_to_complete) 
          from (  select avg(mins_to_complete) avg_mins_to_complete
                  from  (
                        select  datediff(minute, questionnaire_started_date, questionnaire_completed_date) mins_to_complete
                              , cast(questionnaire_completed_date as date) questionnaire_completed_date
                        from ahobpr.form_response_status
                        where questionnaire_completed_date between dateadd(day,-30, cast(getdate() as date)) and cast(getdate() as date)
                        ) daily
                  group by questionnaire_completed_date
                ) avg_daily ) avg_mins_to_complete_last_30d,

       ( select avg(avg_mins_to_complete_top80pct) 
          from (  select avg(mins_to_complete_top80pct) avg_mins_to_complete_top80pct
                  from  (
                        select TOP (80) percent datediff(minute, questionnaire_started_date, questionnaire_completed_date) mins_to_complete_top80pct
                                      , cast(questionnaire_completed_date as date) questionnaire_completed_date
                        from ahobpr.form_response_status
                        where questionnaire_completed_date between '2015-11-01' and cast(getdate() as date)
                        ORDER BY datediff(minute, questionnaire_started_date, questionnaire_completed_date)
                        ) daily
                  group by questionnaire_completed_date
                ) avg_daily ) avg_mins_to_complete_top80pct_since_11_1_2015,
    
        ( select avg(avg_mins_to_complete_top90pct) 
          from (  select avg(mins_to_complete_top90pct) avg_mins_to_complete_top90pct
                  from  (
                        select TOP (90) percent datediff(minute, questionnaire_started_date, questionnaire_completed_date) mins_to_complete_top90pct
                                      , cast(questionnaire_completed_date as date) questionnaire_completed_date
                        from ahobpr.form_response_status
                        where questionnaire_completed_date between '2015-11-01' and cast(getdate() as date)
                        ORDER BY datediff(minute, questionnaire_started_date, questionnaire_completed_date)
                        ) daily
                  group by questionnaire_completed_date
                ) avg_daily ) avg_mins_to_complete_top90pct_since_11_1_2015,
    
       ( select avg(avg_mins_to_complete) 
          from (  select avg(mins_to_complete) avg_mins_to_complete
                  from  (
                        select  datediff(minute, questionnaire_started_date, questionnaire_completed_date) mins_to_complete
                              , cast(questionnaire_completed_date as date) questionnaire_completed_date
                        from ahobpr.form_response_status
                        where questionnaire_completed_date between '2015-11-01' and cast(getdate() as date)
                        ) daily
                  group by questionnaire_completed_date
                ) avg_daily ) avg_mins_to_complete_since_11_1_2015


GO
/****** Object:  View [AHOBPR].[VIEW_REGISTRANTS]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [AHOBPR].[VIEW_REGISTRANTS] AS
/********************************************************************** 
***********************************************************************/
WITH addr AS
(
   SELECT * 
     FROM AHOBPR.REGISTRANT_ADDRESS 
    WHERE TYPE = 'HOME'
)
SELECT reg.REGISTRANT_ID,
       reg.LAST_NAME + ', ' + reg.FIRST_NAME + ' ' + reg.MIDDLE_NAME AS FULL_NAME,
       reg.BIRTH_DATE,
       DATEDIFF(YEAR, reg.BIRTH_DATE, GETDATE()) AS REGISTRANT_AGE,
       reg.GENDER,
       reg.STD_SERVICE_STATUS_ID,
       reg.STD_REGISTRANT_STATUS_ID,
       reg.STD_INSTITUTION_ID,
       ISNULL(reg.REGISTRANT_STATUS_LAST_UPDATED_DATE, reg.UPDATED) AS STATUS_LAST_UPDATED_DATE,
       DATEDIFF(DAY, ISNULL(reg.REGISTRANT_STATUS_LAST_UPDATED_DATE, reg.UPDATED), GETDATE()) As DAYS_AT_CURRENT_STATUS,
       info.EDIPI_MISMATCHED_FLAG,
       info.EDIPI_VERIFIED_DATE,
       info.EULA_ACCEPTED_DATE,
       info.CONTACT_INFO_VERIFIED_DATE,
       addr.COUNTRY,
       addr.STATE,
       addr.CITY
  FROM AHOBPR.REGISTRANT reg
   LEFT JOIN AHOBPR.[REGISTRANT_RECORD_INFO] info
          ON info.REGISTRANT_ID = reg.REGISTRANT_ID
   LEFT JOIN AHOBPR.REGISTRANT_CONTACT_INFO cont
          ON cont.REGISTRANT_ID = info.REGISTRANT_ID
   LEFT JOIN addr
          ON addr.REGISTRANT_ID = cont.REGISTRANT_ID;
    
   
    -- SELECT * FROM [AHOBPR].[VIEW_REGISTRANTS]

GO
/****** Object:  View [AHOBPR].[VIEW_US_LOCATIONS]    Script Date: 7/27/2016 11:11:49 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [AHOBPR].[VIEW_US_LOCATIONS]
AS
  SELECT STD_COUNTRY.ID AS COUNTRY_ID,
         STD_COUNTRY.ALPHA3CODE AS COUNTRY_CODE,
         STD_COUNTRY.POSTALNAME AS COUNTRY_NAME,
         STD_STATE.ID AS STATE_ID,
         STD_STATE.POSTALNAME AS STATE_CODE,
         STD_STATE.NAME AS STATE_NAME,
         STD_COUNTY.ID AS COUNTY_ID,
         STD_COUNTY.NAME AS COUNTY_NAME       
    FROM dbo.STD_COUNTY
    JOIN dbo.STD_STATE
      ON STD_STATE.ID = STD_COUNTY.STATE_ID
    JOIN dbo.STD_COUNTRY
      ON STD_COUNTRY.ID = STD_STATE.COUNTRY_ID;

GO
---------------------------------------------------------------
-- Stored Procedures
---------------------------------------------------------------

/****** Object:  StoredProcedure [AHOBPR].[ERROR_LOG_Log]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
-- =============================================
-- Author:		Dave May
-- Create date: 22 July 2012
-- Description:	Used to log errors to the ERROR_LOG table.
-- =============================================
CREATE PROCEDURE [AHOBPR].[ERROR_LOG_Log]
	@ErrorProcedure nvarchar(128),
	@ErrorMessage nvarchar(4000) 
AS
BEGIN
  SET NOCOUNT ON;
  SET IMPLICIT_TRANSACTIONS OFF ;

  DECLARE @User varchar(255) = ORIGINAL_LOGIN();
  DECLARE @Now datetime2(0) = GETDATE();
  
  INSERT 
    INTO [AHOBPR].[ERROR_LOG]
         ([COMPONENT_TYPE]
         ,[ERROR_TYPE]
         ,[ERROR_SOURCE]
         ,[ERROR_MESSAGE]
         ,[CREATEDBY]
         ,[UPDATEDBY]
         ,[UPDATED]
          )
    VALUES
		       ('Database', 
		        'Stored Procedure',
			      @ErrorProcedure,
			      @ErrorMessage,
			      @User,
			      @User,
			      @Now
			     );
      
  RETURN SCOPE_IDENTITY();
END

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_ClearProcessMetrics]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: July, 13 2015
-- Description: Called from Mirgation routine to remove any Process Metrics records created, 
--              as they do not have vaild dates.
CREATE PROCEDURE [AHOBPR].[SP_ClearProcessMetrics] AS
BEGIN
	SET NOCOUNT ON;

	TRUNCATE TABLE [AHOBPR].[PROCESS_METRICS];

END

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_DeleteOneRegistrant]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [AHOBPR].[SP_DeleteOneRegistrant]
	@firstName  VARCHAR(50),
	@lastName  VARCHAR(50)
AS

DECLARE @registrantId int, @userId varchar(256)
BEGIN
	SELECT @registrantId = REGISTRANT_ID, @userId = USER_ID FROM [AHOBPR].[REGISTRANT] WHERE FIRST_NAME = @firstName AND LAST_NAME = @lastName
	
	DELETE FROM [AHOBPR].[REGISTRANT_JSON] WHERE OBJECT_ID = @userId

	DELETE FROM [AHOBPR].[REGISTRANT_JSON_FOLLOWUP] WHERE OBJECT_ID = @userId

	DELETE FROM [AHOBPR].[REGISTRANT_FILE] WHERE FILE_ID = @userId

	exec ahobpr.SP_DeleteRegistrantAndResponse @registrantId

END

GO

-- =============================================
-- Author:		Bruce Clegg
-- Create date: 4/24/2015
-- Description:	Called after loading Response
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_DeleteRegistrantAndResponse]
       @registrantId INT = NULL 
AS
BEGIN

  DELETE FROM AHOBPR.FORM_RESPONSE_ANSWER
  WHERE FORM_RESPONSE_ANSWER_ID IN
         ( 
          SELECT c.FORM_RESPONSE_ANSWER_ID
            FROM AHOBPR.FORM_RESPONSE r
            JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
            JOIN AHOBPR.FORM_RESPONSE_ANSWER c ON a.FORM_RESPONSE_QUESTION_ID = c.FORM_RESPONSE_QUESTION_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );
         
  DELETE FROM AHOBPR.FORM_RESPONSE_QUESTION
  WHERE FORM_RESPONSE_QUESTION_ID IN
         ( 
          SELECT a.FORM_RESPONSE_QUESTION_ID
            FROM AHOBPR.FORM_RESPONSE r
            JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );      
            
  DELETE FROM AHOBPR.FORM_RESPONSE_STATUS
  WHERE FORM_RESPONSE_STATUS_ID IN
         ( 
          SELECT a.FORM_RESPONSE_STATUS_ID
            FROM AHOBPR.FORM_RESPONSE r
            JOIN AHOBPR.FORM_RESPONSE_STATUS a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );      

  DELETE FROM AHOBPR.FORM_RESPONSE   
        WHERE REGISTRANT_ID  = @registrantId;
 
   DELETE FROM AHOBPR.FOLLOWUP_FORM_RESPONSE_ANSWER
  WHERE FOLLOWUP_FORM_RESPONSE_ANSWER_ID IN
         ( 
          SELECT c.FOLLOWUP_FORM_RESPONSE_ANSWER_ID
            FROM AHOBPR.FOLLOWUP_FORM_RESPONSE r
            JOIN AHOBPR.FOLLOWUP_FORM_RESPONSE_QUESTION a ON r.FOLLOWUP_FORM_RESPONSE_ID = a.FOLLOWUP_FORM_RESPONSE_ID
            JOIN AHOBPR.FOLLOWUP_FORM_RESPONSE_ANSWER c ON a.FOLLOWUP_FORM_RESPONSE_QUESTION_ID = c.FOLLOWUP_FORM_RESPONSE_QUESTION_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );
         
  DELETE FROM AHOBPR.FOLLOWUP_FORM_RESPONSE_QUESTION
  WHERE FOLLOWUP_FORM_RESPONSE_QUESTION_ID IN
         ( 
          SELECT a.FOLLOWUP_FORM_RESPONSE_QUESTION_ID
            FROM AHOBPR.FOLLOWUP_FORM_RESPONSE r
            JOIN AHOBPR.FOLLOWUP_FORM_RESPONSE_QUESTION a ON r.FOLLOWUP_FORM_RESPONSE_ID = a.FOLLOWUP_FORM_RESPONSE_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );      
            

  DELETE FROM AHOBPR.FOLLOWUP_FORM_RESPONSE   
        WHERE REGISTRANT_ID  = @registrantId;
      
  DELETE FROM AHOBPR.REGISTRANT_DEPLOYMENT   
        WHERE REGISTRANT_ID  = @registrantId;

  DELETE FROM AHOBPR.REGISTRANT_ADDRESS   
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT_PHONE
        WHERE REGISTRANT_ID  = @registrantId;  
        
   DELETE FROM AHOBPR.REGISTRANT_EMAIL     
        WHERE REGISTRANT_ID  = @registrantId;  
        
      
  DELETE FROM AHOBPR.REGISTRANT_CONTACT_INFO
        WHERE REGISTRANT_ID  = @registrantId;  
     
  DELETE FROM AHOBPR.REGISTRANT_HEALTH_FACTOR
        WHERE REGISTRANT_VISIT_ID IN
              (SELECT REGISTRANT_VISIT_ID
                 FROM AHOBPR.REGISTRANT_VISIT
                WHERE REGISTRANT_ID = @registrantId);  
        
  DELETE FROM AHOBPR.REGISTRANT_VISIT
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT_RECORD_INFO
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT_REGISTRY_FLAG
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT_SERVICE_EPISODE
        WHERE REGISTRANT_ID  = @registrantId;  
    
  DELETE FROM AHOBPR.PROCESS_METRICS
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.EMAIL_LOG
        WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE FROM AHOBPR.REGISTRANT
        WHERE REGISTRANT_ID  = @registrantId;              
END;
-- EXECUTE [AHOBPR].[SP_DeleteRegistrantAndResponse]  140

GO

/****** Object:  StoredProcedure [AHOBPR].[SP_FixDataParticipantStatus]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [AHOBPR].[SP_FixDataParticipantStatus] AS
BEGIN

	-- UPDATE STATUS FROM PARTICIPANT TO ELIGIBLE
	UPDATE  [AHOBPR].REGISTRANT
	  SET   STD_REGISTRANT_STATUS_ID = 6, UPDATED = GETDATE(), UPDATEDBY = 'SP_FixDataParticipantStatus'
	  WHERE REGISTRANT_ID IN (
		                        SELECT A.REGISTRANT_ID
		                        FROM  [AHOBPR].REGISTRANT A 
                            LEFT OUTER JOIN [AHOBPR].[FORM_RESPONSE] B ON B.REGISTRANT_ID = A.REGISTRANT_ID
		                        LEFT OUTER JOIN [AHOBPR].[FORM_RESPONSE_STATUS] C ON B.FORM_RESPONSE_ID = C.FORM_RESPONSE_ID
		                        WHERE C.[QUESTIONNAIRE_COMPLETED_DATE] IS  NULL
                              AND A.STD_REGISTRANT_STATUS_ID = 7
		                          AND EXISTS (SELECT 'X' FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] D
					                                WHERE D.REGISTRANT_ID = A.REGISTRANT_ID AND [IS_ELIGIBLE_FLAG] = 1
                           )
	  );

    -- UPDATE STATUS FROM PARTICIPANT TO NOT ELIGIBLE
	UPDATE  [AHOBPR].REGISTRANT
	  SET STD_REGISTRANT_STATUS_ID = 3, UPDATED = GETDATE(), UPDATEDBY = 'SP_FixDataParticipantStatus'
	  WHERE REGISTRANT_ID IN (
		                        SELECT A.REGISTRANT_ID
		                        FROM  [AHOBPR].REGISTRANT A 
                            LEFT OUTER JOIN [AHOBPR].[FORM_RESPONSE] B ON B.REGISTRANT_ID = A.REGISTRANT_ID
		                        LEFT OUTER JOIN [AHOBPR].[FORM_RESPONSE_STATUS] C ON B.FORM_RESPONSE_ID = C.FORM_RESPONSE_ID
		                        WHERE C.[QUESTIONNAIRE_COMPLETED_DATE] IS  NULL 
                              AND A.STD_REGISTRANT_STATUS_ID = 7
		                          AND NOT EXISTS (SELECT 'X' FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] D
					                                    WHERE D.REGISTRANT_ID = A.REGISTRANT_ID AND [IS_ELIGIBLE_FLAG] = 1
                          )
	  );

END
GO
/****** Object:  StoredProcedure [AHOBPR].[SP_GetFailedtoSendQuestions]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [AHOBPR].[SP_GetFailedtoSendQuestions]
AS

BEGIN
	SELECT A.REGISTRANT_ID
      , (ISNULL(A.LAST_NAME,'{Last Name Not Found}') + ISNULL(', ' + A.FIRST_NAME,'')) AS REGISTRANT_NAME
      , C.NAME AS FOLLOW_UP_GROUP
      , B.CREATED AS DATE_FAILED
      , C.STD_FORM_ID
	FROM AHOBPR.REGISTRANT A
  JOIN AHOBPR.FOLLOWUP_FORM_RESPONSE B
    ON A.REGISTRANT_ID = B.REGISTRANT_ID
  JOIN AHOBPR.STD_FORM C 
    ON B.STD_FORM_ID = C.STD_FORM_ID
	WHERE B.COMPLETED_DATE IS NULL 
		AND NOT EXISTS
		(
			SELECT 'X'
			FROM AHOBPR.REGISTRANT_JSON_FOLLOWUP D
			WHERE D.OBJECT_TYPE = 'user_form'
				AND D.OBJECT_ID = A.USER_ID
        AND D.INSTANCE_ID = C.BPR_FORM_ID
		)
	

END;

-- Test Cases
-- exec [AHOBPR].[SP_GetFailedtoSendQuestions]


GO
/****** Object:  StoredProcedure [AHOBPR].[SP_GetJsonFollowup]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [AHOBPR].[SP_GetJsonFollowup]
 @ObjectType VARCHAR(100),
 @ObjectId VARCHAR(256),
 @InstanceId VARCHAR(100)
AS

BEGIN

  WITH 
    RankedRow AS 
    (
      SELECT [REGISTRANT_JSON_FOLLOWUP_ID], JSON_DATA, STATUS
            ,RANK() OVER(PARTITION BY [OBJECT_TYPE], [OBJECT_ID], [INSTANCE_ID]
                             ORDER BY REGISTRANT_JSON_FOLLOWUP_ID DESC) AS RowRank
        FROM 
            [AHOBPR].[REGISTRANT_JSON_FOLLOWUP] WITH (READPAST)--don't bother with records that are locked
        WHERE OBJECT_ID = @ObjectId AND OBJECT_TYPE = @ObjectType AND INSTANCE_ID = @InstanceId
    )
   SELECT   [REGISTRANT_JSON_FOLLOWUP_ID], JSON_DATA, STATUS
     FROM   RankedRow
     WHERE  RowRank = 1
END
-- EXECUTE AHOBPR.[SP_GetJsonFollowup] 5187

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_GetJsonFollowups]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [AHOBPR].[SP_GetJsonFollowups]
 @ObjectType VARCHAR(100),
 @ObjectId VARCHAR(256)
AS

BEGIN

  WITH 
    RankedRow AS 
    (
      SELECT [REGISTRANT_JSON_FOLLOWUP_ID], JSON_DATA, STATUS
            ,RANK() OVER(PARTITION BY [OBJECT_TYPE], [OBJECT_ID], [INSTANCE_ID]
                             ORDER BY REGISTRANT_JSON_FOLLOWUP_ID DESC) AS RowRank
        FROM 
            [AHOBPR].[REGISTRANT_JSON_FOLLOWUP] WITH (READPAST)--don't bother with records that are locked
        WHERE OBJECT_ID = @ObjectId AND OBJECT_TYPE = @ObjectType
    )
   SELECT   [REGISTRANT_JSON_FOLLOWUP_ID], JSON_DATA, STATUS
     FROM   RankedRow
     WHERE  RowRank = 1
END
-- EXECUTE AHOBPR.SP_GetJsonFollowups 5187

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_GetJsonQueue]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [AHOBPR].[SP_GetJsonQueue]
AS
/*
SP_GetJsonQueue 
Get all the items that need to be processed by JSON_QUEUE_IDs:
a.    INSERT new REGISTRANT_JSON rows to [AHOBPR].[REGISTRANT_JSON_H]
b.    Delete any unlocked and superseded records from REGISTRANT_JSON table
c.    Insert the new records to JSON_QUEUE table, ignoring any 'response' REGISTRANT_JSON records that are less than 30 minutes old
d.    Return the JSON_QUEUE_IDs to be processed ordered by object_type in the following order:  USER, INFO, RESPONSE  
*/

BEGIN

  -- INSERT new REGISTRANT_JSON rows to [AHOBPR].[REGISTRANT_JSON_H]
  WITH  MasterData
  AS    ( 
            SELECT REGISTRANT_JSON_ID
                    ,[OBJECT_ID]
                    ,[OBJECT_TYPE]
                    ,[JSON_DATA]
                    ,[CREATEDBY]
                    ,[UPDATEDBY]
                    ,[CREATED]
                    ,[UPDATED]
              FROM [AHOBPR].[REGISTRANT_JSON] A
              WHERE created >= '2015-09-01'
        )
  MERGE
    INTO  [AHOBPR].[REGISTRANT_JSON_H] AS Tgt
    USING MasterData AS Src
    ON    Tgt.REGISTRANT_JSON_ID = Src.REGISTRANT_JSON_ID
  WHEN  NOT MATCHED
    THEN  INSERT
        (REGISTRANT_JSON_ID,[OBJECT_ID],[OBJECT_TYPE],[JSON_DATA],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED]) 
        VALUES
        (Src.REGISTRANT_JSON_ID,Src.[OBJECT_ID],Src.[OBJECT_TYPE],Src.[JSON_DATA],Src.[CREATEDBY],Src.[UPDATEDBY],Src.[CREATED],Src.[UPDATED]);

  -- DELETE any duplicate REGISTRANT_JSON rows
  WITH 
    RankedRow AS 
    (
      SELECT [REGISTRANT_JSON_ID]
            ,RANK() OVER(PARTITION BY [OBJECT_TYPE], [OBJECT_ID]
                             ORDER BY [REGISTRANT_JSON_ID] DESC) AS RowRank
        FROM 
            [AHOBPR].[REGISTRANT_JSON] WITH (READPAST)--don't bother with records that are locked
    )
  , Duplicate AS
    (
       SELECT   [REGISTRANT_JSON_ID] 
         FROM   RankedRow
         WHERE  RowRank > 1
    )
  DELETE 
    FROM [AHOBPR].[REGISTRANT_JSON] WITH (READPAST)--don't bother with records that are locked
    WHERE EXISTS  ( SELECT * 
                    FROM  Duplicate
                    WHERE Duplicate.REGISTRANT_JSON_ID = REGISTRANT_JSON.REGISTRANT_JSON_ID
                  );
                     
  -- Insert the new records in the JSON_QUEUE     
  -- Ignore any 'response' REGISTRANT_JSON records that are less than 30 minutes old
  DECLARE @ThirtyMinutesAgo DATETIME2(0) = DATEADD(MINUTE, -30, GETDATE());
  WITH 
    RankedRow AS --we just deleted duplicates above, but since we used READPAST and since there is no
                 --guarantee that new dup has not been added since, we take the precaution of ranking
                 --them again.
    ( SELECT *
            ,RANK() OVER(PARTITION BY [OBJECT_TYPE], [OBJECT_ID]
                             ORDER BY [REGISTRANT_JSON_ID] DESC) AS RowRank
       FROM [AHOBPR].[REGISTRANT_JSON] WITH (READPAST) --don't bother with records that are locked
    )
  , Src AS
    ( SELECT [REGISTRANT_JSON_ID]
            ,[CREATED]
            ,[UPDATED]
            ,[CREATEDBY]
            ,[UPDATEDBY]
      FROM  RankedRow
      WHERE RowRank = 1    --the most recent (all others are superseded)
        AND ( UPDATED < @ThirtyMinutesAgo --only applies to response objects
           OR OBJECT_TYPE IN ('user','info')
            )  
    )
    MERGE 
      INTO  [AHOBPR].[JSON_QUEUE] Tgt
      USING Src
        ON  Tgt.[REGISTRANT_JSON_ID] = Src.[REGISTRANT_JSON_ID]
       WHEN NOT MATCHED
       THEN INSERT  
            ( [REGISTRANT_JSON_ID]
            , [CREATED]
            , [UPDATED]
            , [CREATEDBY]
            , [UPDATEDBY]
            )
            VALUES
            (  Src.[REGISTRANT_JSON_ID]
              ,Src.[CREATED]
              ,Src.[UPDATED]
              ,Src.[CREATEDBY]
              ,Src.[UPDATEDBY]
            );
            
-- Get the IDs of the queued JSON objects to be parsed
-- Order the JSON_QUEUE_IDs to be processed by object_type in the following order:  USER, INFO, RESPONSE 

--Switched to just pull records from the JSON QUEUE table where there are NO
--corresponding records in the JSON_QUEUE_STATUS table.  I.e., only grab items
--that have never been tried before.  9/30/15 MW.
  SELECT JSON_QUEUE_ID
    FROM AHOBPR.JSON_QUEUE Q
    JOIN AHOBPR.REGISTRANT_JSON AS J ON Q.REGISTRANT_JSON_ID = J.REGISTRANT_JSON_ID
   WHERE NOT EXISTS(SELECT * FROM AHOBPR.JSON_QUEUE_STATUS S WHERE S.JSON_QUEUE_ID = Q.JSON_QUEUE_ID)
     AND J.OBJECT_TYPE != 'form'
  ORDER
    BY    CASE J.OBJECT_TYPE  WHEN 'user' THEN 1
                              WHEN 'info' THEN 2
                              WHEN 'responses' THEN 3
                              ELSE 99 --should not happen
							  END;
END  -- 12 rows
GO
/****** Object:  StoredProcedure [AHOBPR].[SP_GetJsonQueueFollowup]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [AHOBPR].[SP_GetJsonQueueFollowup]
AS
/*
[SP_GetJsonQueueFollowup] 
Get all the items that need to be processed by [REGISTRANT_JSON_FOLLOWUP_ID]:
a.    Delete the previous/old/duplicated records from REGISTRANT_JSON_FOLLOWUP table
b.    Insert the new records to JSON_QUEUE_FOLLOWUP table
*/

BEGIN

  -- DELETE any duplicate REGISTRANT_JSON rows
  WITH 
    RankedRow AS 
    (
      SELECT [REGISTRANT_JSON_FOLLOWUP_ID]
            ,RANK() OVER(PARTITION BY [OBJECT_TYPE], [OBJECT_ID], [INSTANCE_ID]
                             ORDER BY [REGISTRANT_JSON_FOLLOWUP_ID] DESC) AS RowRank
        FROM 
            [AHOBPR].[REGISTRANT_JSON_FOLLOWUP] WITH (READPAST)--don't bother with records that are locked
    )
  , Duplicate AS
    (
       SELECT   [REGISTRANT_JSON_FOLLOWUP_ID] 
         FROM   RankedRow
         WHERE  RowRank > 1
    )
  DELETE 
    FROM [AHOBPR].[REGISTRANT_JSON_FOLLOWUP] WITH (READPAST)--don't bother with records that are locked
    WHERE EXISTS  ( SELECT * 
                    FROM  Duplicate
                    WHERE Duplicate.REGISTRANT_JSON_FOLLOWUP_ID = REGISTRANT_JSON_FOLLOWUP.REGISTRANT_JSON_FOLLOWUP_ID
                  );
                     
  -- Insert the new records in the JSON_QUEUE_FOLLOWUP     
   WITH 
    RankedRow AS --we just deleted duplicates above, but since we used READPAST and since there is no
                 --guarantee that new dup has not been added since we take the precaution of ranking
                 --them again.
    ( SELECT *
            ,RANK() OVER(PARTITION BY [OBJECT_TYPE], [OBJECT_ID], [INSTANCE_ID]
                             ORDER BY [REGISTRANT_JSON_FOLLOWUP_ID] DESC) AS RowRank
       FROM [AHOBPR].[REGISTRANT_JSON_FOLLOWUP] WITH (READPAST) --don't bother with records that are locked
       WHERE NOT EXISTS ( SELECT  *
                          FROM    AHOBPR.JSON_QUEUE_FOLLOWUP AS Q
                          WHERE   Q.REGISTRANT_JSON_FOLLOWUP_ID = [REGISTRANT_JSON_FOLLOWUP].REGISTRANT_JSON_FOLLOWUP_ID
                        )
             AND OBJECT_TYPE = 'responses_followup'
    )
  , Src AS
    ( SELECT [REGISTRANT_JSON_FOLLOWUP_ID]
            ,[CREATED]
            ,[UPDATED]
            ,[CREATEDBY]
            ,[UPDATEDBY]
      FROM  RankedRow
      WHERE RowRank = 1      
    )
    MERGE 
      INTO  [AHOBPR].[JSON_QUEUE_FOLLOWUP] Tgt
      USING Src
        ON  Tgt.[REGISTRANT_JSON_FOLLOWUP_ID] = Src.[REGISTRANT_JSON_FOLLOWUP_ID]
       WHEN NOT MATCHED
       THEN INSERT  
            ( [REGISTRANT_JSON_FOLLOWUP_ID]
            , [CREATED]
            , [UPDATED]
            , [CREATEDBY]
            , [UPDATEDBY]
            )
            VALUES
            (  Src.[REGISTRANT_JSON_FOLLOWUP_ID]
              ,Src.[CREATED]
              ,Src.[UPDATED]
              ,Src.[CREATEDBY]
              ,Src.[UPDATEDBY]
            );
            
-- Get the IDs of the queued JSON objects to be parsed
-- Order the JSON_QUEUE_IDs to be processed by object_type in the following order:  USER, INFO, RESPONSE 

--Switched to just pull records from the JSON QUEUE table where there are NO
--corresponding records in the JSON_QUEUE_STATUS table.  I.e., only grab items
--that have never been tried before.  9/30/15 MW.
  SELECT JSON_QUEUE_FOLLOWUP_ID
    FROM AHOBPR.JSON_QUEUE_FOLLOWUP Q
    JOIN AHOBPR.REGISTRANT_JSON_FOLLOWUP AS J ON Q.REGISTRANT_JSON_FOLLOWUP_ID = J.REGISTRANT_JSON_FOLLOWUP_ID
   WHERE NOT EXISTS(SELECT * FROM AHOBPR.JSON_QUEUE_FOLLOWUP_STATUS S WHERE S.JSON_QUEUE_FOLLOWUP_ID = Q.JSON_QUEUE_FOLLOWUP_ID)
     AND J.OBJECT_TYPE = 'responses_followup'
END  
-- EXECUTE [AHOBPR].[SP_GetJsonFollowup]

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_GetJsonQueueFollowupRow]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [AHOBPR].[SP_GetJsonQueueFollowupRow]
	@jsonQueueFollowupId	INT
AS
BEGIN
	SET NOCOUNT ON;

	SELECT JSON_QUEUE_FOLLOWUP_ID
		   , REGISTRANT_JSON_FOLLOWUP_ID
	 FROM AHOBPR.JSON_QUEUE_FOLLOWUP
	WHERE JSON_QUEUE_FOLLOWUP_ID = @jsonQueueFollowupId;

END;


GO
/****** Object:  StoredProcedure [AHOBPR].[SP_GetJsonQueueRow]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


CREATE PROCEDURE [AHOBPR].[SP_GetJsonQueueRow]
	@jsonQueueId	INT
AS
BEGIN
	SET NOCOUNT ON;

	SELECT JSON_QUEUE_ID
		   , REGISTRANT_JSON_ID
		   , PROCESS_START_DATE
		   , PROCESS_COMPLETE_DATE
		   , PROCESS_STATUS
		   , PROCESS_ERROR
		   , CREATEDBY
		   , CREATED
		   , UPDATEDBY
		   , UPDATED
		   , ROW_VERSION
	 FROM AHOBPR.JSON_QUEUE
	WHERE JSON_QUEUE_ID = @jsonQueueId;

END

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_GetRegistrantAddFlag]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Create date: December 1, 2015
-- Description:	Used to create the list of registrant to add mass Admin & Sub-population flags.  

-- Modification log
-- 2016-02-03 - D. Barr - Fixed logic on Evaluation Location (Script 2.0.32.1)
-- 
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_GetRegistrantAddFlag]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @state varchar(8000) = NULL, -- Multiple states, comma-separated values when not NULL   
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (8000) = NULL, -- Multiple subpopulationFlags, comma-separated values when not NULL  
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @excludeAdminFlag varchar(1) = 'N',
       @deploymentStartFromDateText varchar(100) = NULL,
       @deploymentStartToDateText varchar(100) = NULL,
       @deploymentCompletionFromDateText varchar(100) = NULL,
       @deploymentCompletionToDateText varchar(100) = NULL
       
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
          @deploymentStartFromDate DATETIME2(0) = NULL,
          @deploymentStartToDate DATETIME2(0) = NULL,
          @deploymentCompletionFromDate DATETIME2(0) = NULL,
          @deploymentCompletionToDate DATETIME2(0) = NULL
          
  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);   
  
   --Temp table concatnate flags for Registrants with multiple flags
  CREATE TABLE #state
  (
     [Registrant_Id] INT,
     [state] VARCHAR(8000)
  ) 

  SET @state = REPLACE(@state, 'Foreign Country/Other', 'FM,MH,PW,UM,US,CANAD,MX,EU,PI,FG,OT,UN')

  INSERT INTO #state ([Registrant_Id], [state])
  -- Load Table
  SELECT a.REGISTRANT_ID, 
        STUFF((SELECT ', ' + b.STATE 
                 FROM AHOBPR.REGISTRANT_ADDRESS b 
                WHERE a.REGISTRANT_ID = b.REGISTRANT_ID 
                FOR XML PATH('')), 1, 1, '')  [STATE]
    FROM AHOBPR.REGISTRANT a
   GROUP BY a.REGISTRANT_ID;
   
                

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
  SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));
  SET @deploymentStartFromDate = dbo.CleanDate(@deploymentStartFromDateText);
  SET @deploymentStartToDate = dbo.AddMaxTime(dbo.CleanDate(@deploymentStartToDateText));
  SET @deploymentCompletionFromDate = dbo.CleanDate(@deploymentCompletionFromDateText);
  SET @deploymentCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@deploymentCompletionToDateText)); 
  
     

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
-- Set InstitutionID values if needed.
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, '+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',(a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',s.STATE AS State ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
         
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
		                             ',RIGHT(a.SSN, 4) AS SSN ' +
		                    'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                                'LEFT JOIN #state s ' +  'ON a.REGISTRANT_ID = s.Registrant_Id ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.REGISTRANT_DEPLOYMENT rd ON a.REGISTRANT_ID =  rd.REGISTRANT_ID ';

  
    
--used to get all registrant without the selected adminflag
IF ISNULL(@excludeAdminFlag, 'N') = 'Y'
    SET @MainQuery = @MainQuery + ' Left JOIN (SELECT REGISTRANT_ID, STD_REGISTRY_FLAG_ID FROM AHOBPR.REGISTRANT_REGISTRY_FLAG  ' +
								  '	WHERE STD_REGISTRY_FLAG_ID IN (' + @adminFlag + '))  AS af on af.REGISTRANT_ID = a.REGISTRANT_ID ';  
     
								  	      
    SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
    
	
IF ISNULL(@excludeAdminFlag, 'N') = 'Y'	
	SET @MainQuery = @MainQuery + ' AND STD_REGISTRY_FLAG_ID is NULL ';
                                                

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
     
  IF @deploymentStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND rd.DEPLOYMENT_START_DATE >= ''' + CONVERT(VARCHAR(20),@deploymentStartFromDate,121) + '''';
     
  IF @deploymentStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND rd.DEPLOYMENT_START_DATE <= ''' + CONVERT(VARCHAR(20),@deploymentStartToDate,121) + '''';
    
  IF @deploymentCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND rd.DEPLOYMENT_END_DATE >= ''' + CONVERT(VARCHAR(20),@deploymentCompletionFromDate,121) + '''';

  IF @deploymentCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND rd.DEPLOYMENT_END_DATE <= ''' + CONVERT(VARCHAR(20),@deploymentCompletionToDate,121) + '''';
     
   

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF (ISNULL(@adminFlag,'') != '' AND ISNULL(@excludeAdminFlag,'N') = 'N') 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
                                                  
                     
                                                                  
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ; 
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
               

                                                      
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';
  
  IF ISNULL(@state,'') > ''
    BEGIN
      SET @state = REPLACE(@State,',',''',''');
      SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT DISTINCT addr.REGISTRANT_ID ' + 
                                          'FROM AHOBPR.REGISTRANT_ADDRESS addr ' + 
                                         'WHERE addr.REGISTRANT_ID = a.REGISTRANT_ID ' + 
                                           'AND addr.STATE  IN ( ''' + @state + ''') ) ';
    END;  
          
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
      
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
   
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
     
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith +  @MainQuery + @RegCriteria;            

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] 
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @state = 'MD,VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @deploymentStartFromDateText  = '20120101' 
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @subpopulationFlag = '85,87,89,105,106,91'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @deploymentAll = 'Iraq,djibouti'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_GetRegistrantAddFlag] @adminFlag = '117', @excludeAdminFlag = 'Y' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag]
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantAddFlag] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'


GO

/****** Object:  StoredProcedure [AHOBPR].[SP_GetRegistrantFile]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [AHOBPR].[SP_GetRegistrantFile]
 @fileType VARCHAR(100),
 @fileId VARCHAR(256)
AS

BEGIN

      SELECT FILE_CONTENT
        FROM 
            AHOBPR.REGISTRANT_FILE
        WHERE FILE_ID = @fileId AND FILE_TYPE = @fileType 
END
-- EXECUTE AHOBPR.SP_JsonGetCurrent 5187

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_GetRegistrantJsonFollowupRow]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [AHOBPR].[SP_GetRegistrantJsonFollowupRow]
	@jsonFollowupId	INT
AS
BEGIN
	SET NOCOUNT ON;

	SELECT REGISTRANT_JSON_FOLLOWUP_ID
		   , OBJECT_ID
		   , OBJECT_TYPE
		   , INSTANCE_ID
		   , JSON_DATA
	 FROM AHOBPR.REGISTRANT_JSON_FOLLOWUP
	WHERE REGISTRANT_JSON_FOLLOWUP_ID = @jsonFollowupId;

END

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_GetRegistrantJsonRow]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


CREATE PROCEDURE [AHOBPR].[SP_GetRegistrantJsonRow]
	@jsonId	INT
AS
BEGIN
	SET NOCOUNT ON;

	SELECT REGISTRANT_JSON_ID
		   , OBJECT_ID
		   , OBJECT_TYPE
		   , JSON_DATA
		   , CREATEDBY
		   , UPDATEDBY
		   , CREATED
		   , UPDATED
		   , ROW_VERSION
	 FROM AHOBPR.REGISTRANT_JSON
	WHERE REGISTRANT_JSON_ID = @jsonId;

END

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_GetRegistrantSendMessage]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Create date: October 28, 2015
-- Description:	Used to create the list of registrant to send email/notifications to.  

-- Modification log
-- 2016-02-03 - D. Barr - Fixed logic on Evaluation Location (Script 2.0.32.1)
-- 2016-02-08 - D. Barr - Added logic from Dave to addressed performance of specific question query
-- 
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_GetRegistrantSendMessage]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @state varchar(8000) = NULL, -- Multiple states, comma-separated values when not NULL   
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (8000) = NULL, -- Multiple subpopulationFlags, comma-separated values when not NULL  
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @contactPreference varchar(100) = '',
       @lastName varchar(50) = '',
       @ssn varchar(4) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @formBirthDateText varchar(100) = NULL,
       @email varchar(100) = 'All',
       @evaluation varchar(100) = 'All',
       @excludeAdminFlag varchar(1) = 'N'
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
          @formBirthDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);
  DECLARE @AnswerWith VARCHAR(8000) = '';   
    
  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
	SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));
   SET @formBirthDate = dbo.CleanDate(@formBirthDateText); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
-- Set InstitutionID values if needed.
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, '+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',(a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
                            --',RIGHT(a.SSN, 4) AS SSN ';
--Decide which query to run depending on if a question was selected as a parameter for the report
  IF ISNULL(@questionNumber, '') = ''
    SET @MainQuery = @MainQuery + ','''' AS QuestionNumber ' +
                                  ','''' AS Answer '
  ELSE                                  
    SET @MainQuery = @MainQuery + ',''' + @questionNumber + ''' AS QuestionNumber ' +
                                  ',STUFF((SELECT '', '' + stdAnswer.TEXT ' +
                                          '  FROM AHOBPR.FORM_RESPONSE_ANSWER answer ' + 
                                          '  JOIN AHOBPR.STD_FORM_ANSWER stdAnswer ON answer.STD_FORM_ANSWER_ID = stdAnswer.STD_FORM_ANSWER_ID ' +
                                          ' WHERE formQuestion.FORM_RESPONSE_QUESTION_ID = answer.FORM_RESPONSE_QUESTION_ID ' +
                                          ' FOR XML PATH('''')), 1, 1, '''') AS Answer ' ;                  
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
		                            ',RIGHT(a.SSN, 4) AS SSN ' +
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                                ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';
  							  	      
    SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
    

  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
 BEGIN    
      SET @AnswerWith = '
, selectedAnswerInstance as
(
  select BRP_FORM_ANSWER_ID, A.STD_FORM_QUESTION_ID, Q.FORM_QUESTION_UNIQUE_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on Q.STD_FORM_QUESTION_ID = A.STD_FORM_QUESTION_ID
  where a.STD_FORM_ANSWER_ID IN (' + @answer + ')--user specified answer
)
, selectedAnswer as
(
  select STD_FORM_ANSWER_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on A.STD_FORM_QUESTION_ID = Q.STD_FORM_QUESTION_ID
  where EXISTS (select * from selectedAnswerInstance --1:39 w/o brp_form_answer_id index 0:37 with
                where A.BRP_FORM_ANSWER_ID      = selectedAnswerInstance.BRP_FORM_ANSWER_ID
                  and Q.FORM_QUESTION_UNIQUE_ID = selectedAnswerInstance.FORM_QUESTION_UNIQUE_ID
                )
) ';
    SET @MainQuery = @MainQuery +  '
  AND EXISTS(select *
              from AHOBPR.FORM_RESPONSE_ANSWER a 
              join selectedAnswer on selectedAnswer.STD_FORM_ANSWER_ID = a.STD_FORM_ANSWER_ID
              where a.FORM_RESPONSE_QUESTION_ID = formQuestion.FORM_RESPONSE_QUESTION_ID
            )'; 
  END;                                                    

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
     
  IF @formBirthDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND a.BIRTH_DATE = ''' + CONVERT(VARCHAR(20),@formBirthDate,121) + '''';
     
   

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF (ISNULL(@adminFlag,'') != '') 
	  IF (ISNULL(@excludeAdminFlag,'N') = 'N') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) '
      ELSE  
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';                                         
   IF (@email = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                        ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND em.EMAIL != '''') '
   ELSE IF (@email = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                        ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND em.EMAIL != '''') ' ;  
                          
  IF (@evaluation = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ;                        
                                                                  
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                       
  IF ISNULL(@state,'') != '' 
	BEGIN
		SET @state = REPLACE(@State,',',''','''); 
		SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_ADDRESS addr ' +
                        ' WHERE addr.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          'AND addr.STATE  IN ( ''' + @state + ''') ) ';              
	END;
                                                  
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';
  
           
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@contactPreference,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @contactPreference + ''' = ISNULL(a.CONTACT_PREFERENCE,''No Data Available'') ';
    
  IF ISNULL(@ssn,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RIGHT(a.SSN, 4) = ''' + @ssn  + '''';
  
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@lastName,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RTRIM(LTRIM(a.LAST_NAME)) LIKE ''' + @lastName + ''''; 
    
  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
   
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
     
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith + @AnswerWith +  @MainQuery + @RegCriteria;             

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @evaluation = 'N', @status = '7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @contactPreference = 'Email from the VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @state = 'MD,VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage_changes] @formBirthDateText  = '19770707'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @subpopulationFlag = '85,87,89,105,106,91'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @deploymentAll = 'Egypt'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @adminFlag = '117', @excludeAdminFlag = 'Y' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @questionNumber = '5.4.A'  , @answer = '2221'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage]
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage]  @ssn = '1125'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'


GO

/****** Object:  StoredProcedure [AHOBPR].[SP_GetRegistrantSendQuestions]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Create date: October 28, 2015
-- Description:	Used to create the list of registrant to send follow-up questions to.  

-- Modification log
-- -- 2016-02-08 - D. Barr - Added logic from Dave to addressed performance of specific question query
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_GetRegistrantSendQuestions]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'Y',
       @excludeAdminFlag varchar(1) = 'N',
       @lastName varchar(50) = '',
       @ssn varchar(4) = '',
       @formBirthDateText varchar(100) = NULL
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
          @formBirthDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);
  DECLARE @AnswerWith VARCHAR(8000) = '';                

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE()));
  SET @formBirthDate = dbo.CleanDate(@formBirthDateText); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, a.SSN,'+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',a.SSN, (a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',c.SERVICE_STATUS AS DutyStatus ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
--Decide which query to run depending on if a question was selected as a parameter for the report
  IF ISNULL(@questionNumber, '') = ''
    SET @MainQuery = @MainQuery + ','''' AS QuestionNumber ' +
                                  ','''' AS Answer '
  ELSE                                  
    SET @MainQuery = @MainQuery + ',''' + @questionNumber + ''' AS QuestionNumber ' +
                                  ',STUFF((SELECT '', '' + stdAnswer.TEXT ' +
                                          '  FROM AHOBPR.FORM_RESPONSE_ANSWER answer ' + 
                                          '  JOIN AHOBPR.STD_FORM_ANSWER stdAnswer ON answer.STD_FORM_ANSWER_ID = stdAnswer.STD_FORM_ANSWER_ID ' +
                                          ' WHERE formQuestion.FORM_RESPONSE_QUESTION_ID = answer.FORM_RESPONSE_QUESTION_ID ' +
                                          ' FOR XML PATH('''')), 1, 1, '''') AS Answer ' ;                  
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
		                            ',RIGHT(a.SSN, 4) AS Last4SSN ' +
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                              ' JOIN AHOBPR.STD_SERVICE_STATUS c ON a.STD_SERVICE_STATUS_ID = c.STD_SERVICE_STATUS_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';

  --used to get all registrant without the selected adminflag
IF ISNULL(@excludeAdminFlag, 'N') = 'Y'
    SET @MainQuery = @MainQuery + ' Left JOIN (SELECT REGISTRANT_ID, STD_REGISTRY_FLAG_ID FROM AHOBPR.REGISTRANT_REGISTRY_FLAG  ' +
								  '	WHERE STD_REGISTRY_FLAG_ID IN (' + @adminFlag + '))  AS af on af.REGISTRANT_ID = a.REGISTRANT_ID ';
  
  SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
  

IF ISNULL(@excludeAdminFlag, 'N') = 'Y'	
	SET @MainQuery = @MainQuery + ' AND STD_REGISTRY_FLAG_ID is NULL ';  

  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
    BEGIN    
      SET @AnswerWith = '
, selectedAnswerInstance as
(
  select BRP_FORM_ANSWER_ID, A.STD_FORM_QUESTION_ID, Q.FORM_QUESTION_UNIQUE_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on Q.STD_FORM_QUESTION_ID = A.STD_FORM_QUESTION_ID
  where a.STD_FORM_ANSWER_ID IN (' + @answer + ')--user specified answer
)
, selectedAnswer as
(
  select STD_FORM_ANSWER_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on A.STD_FORM_QUESTION_ID = Q.STD_FORM_QUESTION_ID
  where EXISTS (select * from selectedAnswerInstance --1:39 w/o brp_form_answer_id index 0:37 with
                where A.BRP_FORM_ANSWER_ID      = selectedAnswerInstance.BRP_FORM_ANSWER_ID
                  and Q.FORM_QUESTION_UNIQUE_ID = selectedAnswerInstance.FORM_QUESTION_UNIQUE_ID
                )
) ';
    SET @MainQuery = @MainQuery +  '
  AND EXISTS(select *
              from AHOBPR.FORM_RESPONSE_ANSWER a 
              join selectedAnswer on selectedAnswer.STD_FORM_ANSWER_ID = a.STD_FORM_ANSWER_ID
              where a.FORM_RESPONSE_QUESTION_ID = formQuestion.FORM_RESPONSE_QUESTION_ID
            )'; 
  END;                                                          

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
     
  IF @formBirthDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND a.BIRTH_DATE = ''' + CONVERT(VARCHAR(20),@formBirthDate,121) + '''';   

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF (ISNULL(@adminFlag,'') != '' AND ISNULL(@excludeAdminFlag,'N') = 'N') 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
                                              
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
                                                    
   IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                                      
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';

  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
    
  IF ISNULL(@ssn,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RIGHT(a.SSN, 4) = ''' + @ssn  + '''';  
  
  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
    
  IF ISNULL(@lastName,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RTRIM(LTRIM(a.LAST_NAME)) LIKE ''' + @lastName + '''';    
  
     
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID, a.SSN ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID, a.SSN ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID, a.SSN ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith + @AnswerWith +  @MainQuery + @RegCriteria;           

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions]
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @status = '6,7'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @formStartFromDateText  = '20010101'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @formStartToDateText = '20141231'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @formCompletionFromDateText  = '20010101'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @formCompletionToDateText  = '20141231'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @healthConcerns = 'Yes'     , 
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @subpopulationFlag = '64,65,66,67'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @deploymentAll = 'Egypt'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @deploymentExposure  = 'Iraq'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @adminFlag = '59,60' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @questionNumber = '5.4.A'  , @answer = '2221'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @lastName = 'horton'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @formBirthDateText = '05/05/1975'
-- exec [AHOBPR].[SP_GetRegistrantSendQuestions] @ssn = '1125'

GO

/****** Object:  StoredProcedure [AHOBPR].[SP_InsertErrorLog]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [AHOBPR].[SP_InsertErrorLog]
	@compoType		VARCHAR(100),
	@errorType		VARCHAR(100),
	@errorSource	VARCHAR(200),
	@errorMessage	VARCHAR(max),
	@created		  VARCHAR(30)
AS
BEGIN
	SET NOCOUNT ON;

	INSERT INTO AHOBPR.ERROR_LOG (
						COMPONENT_TYPE
					  , ERROR_TYPE
					  , ERROR_SOURCE
					  , ERROR_MESSAGE
					  , CREATED
					  , UPDATED
					  , CREATEDBY
					  , UPDATEDBY)
		VALUES (
						@compoType
					  , @errorType
					  , @errorSource
					  , @errorMessage
					  , GETDATE()
					  , GETDATE()
					  , @created
					  , @created);
					  
	SELECT SCOPE_IDENTITY();

END


GO
/****** Object:  StoredProcedure [AHOBPR].[SP_InsertJsonQueue]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [AHOBPR].[SP_InsertJsonQueue]
	@jsonQueueId		      INT,
	@registrantJsonId		  INT,
	@processStartDate		  DATETIME2(0) = null,
	@processCompleteDate	DATETIME2(0) = null,
	@processStatus			  VARCHAR(100),
	@processError			    VARCHAR(4000),
	@createdBy				    VARCHAR(30)
AS
BEGIN
	SET NOCOUNT ON;

	INSERT INTO AHOBPR.JSON_QUEUE_STATUS (
						  JSON_QUEUE_ID
					  , REGISTRANT_JSON_ID
					  , PROCESS_START_DATE
					  , PROCESS_COMPLETE_DATE
					  , PROCESS_STATUS
					  , PROCESS_ERROR
					  , CREATEDBY
					  , CREATED
					  , UPDATEDBY
					  , UPDATED)
	VALUES (		@jsonQueueId
					  , @registrantJsonId
					  , @processStartDate
					  , @processCompleteDate
					  , @processStatus
					  , @processError
					  , @createdBy
					  , GETDATE()
					  , @createdBy
					  , GETDATE());

	SELECT SCOPE_IDENTITY();

END

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_InsertJsonQueueFollowup]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [AHOBPR].[SP_InsertJsonQueueFollowup]
	@jsonQueueFollowupId		      INT,
	@registrantJsonFollowupId		  INT,
	@processStartDate		  DATETIME2(0) = null,
	@processCompleteDate	DATETIME2(0) = null,
	@processStatus			  VARCHAR(100),
	@processError			    VARCHAR(4000),
	@createdBy				    VARCHAR(30)
AS
BEGIN
	SET NOCOUNT ON;

	INSERT INTO AHOBPR.JSON_QUEUE_FOLLOWUP_STATUS (
						JSON_QUEUE_FOLLOWUP_ID
					  , REGISTRANT_JSON_FOLLOWUP_ID
					  , PROCESS_START_DATE
					  , PROCESS_COMPLETE_DATE
					  , PROCESS_STATUS
					  , PROCESS_ERROR
					  , CREATEDBY
					  , CREATED
					  , UPDATEDBY
					  , UPDATED)
	VALUES (		@jsonQueueFollowupId
					  , @registrantJsonFollowupId
					  , @processStartDate
					  , @processCompleteDate
					  , @processStatus
					  , @processError
					  , @createdBy
					  , GETDATE()
					  , @createdBy
					  , GETDATE());

	SELECT SCOPE_IDENTITY();

END

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_InsertRegistrantFile]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [AHOBPR].[SP_InsertRegistrantFile]
	@fileId			VARCHAR(256),
	@fileType		VARCHAR(256),
	@fileContent	VARBINARY(max),
	@createdBy		VARCHAR(30)
AS
BEGIN
	SET NOCOUNT ON;
	
	DECLARE @registrantFileId	uniqueidentifier;
	
	SELECT	@registrantFileId = registrant_file_id
	FROM	AHOBPR.REGISTRANT_FILE
	WHERE	FILE_ID = @fileId AND
			FILE_TYPE = @fileType;
	
	IF (@registrantFileId is null)
		BEGIN
			INSERT INTO AHOBPR.REGISTRANT_FILE 
				(REGISTRANT_FILE_ID,
				 FILE_ID, 
				 FILE_TYPE, 
				 FILE_CONTENT, 
				 CREATEDBY, 
				 UPDATEDBY, 
				 CREATED, 
				 UPDATED) 
			VALUES
				(NEWID(),
				 @fileId,
				 @fileType,
				 @fileContent,
				 @createdBy,
				 @createdBy,
				 GETDATE(),
				 GETDATE());
		END
	ELSE
		BEGIN
			UPDATE AHOBPR.REGISTRANT_FILE
			SET
				FILE_CONTENT = @fileContent,
				UPDATEDBY = @createdBy,
				UPDATED = GETDATE()
			WHERE REGISTRANT_FILE_ID = @registrantFileId;
		END
END

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_InsertRegistrantJson]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


CREATE PROCEDURE [AHOBPR].[SP_InsertRegistrantJson]
	@objectId	  VARCHAR(256),
	@objectType	VARCHAR(100),
	@jsonData	  VARCHAR(max),
	@createdBy	VARCHAR(30)
AS
BEGIN
	SET NOCOUNT ON;

	INSERT INTO AHOBPR.REGISTRANT_JSON (
					    OBJECT_ID
					  , OBJECT_TYPE
					  , JSON_DATA
					  , CREATED
					  , CREATEDBY
					  , UPDATED
					  , UPDATEDBY)
	VALUES (
					    @objectId
					  , @objectType
					  , @jsonData
					  , GETDATE()
					  , @createdBy
					  , GETDATE()
					  , @createdBy);

	SELECT SCOPE_IDENTITY();

END

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_InsertRegistrantJsonFollowup]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [AHOBPR].[SP_InsertRegistrantJsonFollowup]
	@objectId	VARCHAR(256),
	@objectType	VARCHAR(100),
	@instanceId	VARCHAR(100),
	@jsonData	VARCHAR(max),
	@status	    VARCHAR(100),
	@createdBy	VARCHAR(30)
AS
BEGIN
	SET NOCOUNT ON;

	INSERT 
    INTO  AHOBPR.REGISTRANT_JSON_FOLLOWUP 
          (
					  OBJECT_ID
				  , OBJECT_TYPE
				  , INSTANCE_ID
				  , JSON_DATA
				  , [STATUS]
				  , CREATED
				  , CREATEDBY
				  , UPDATED
				  , UPDATEDBY
          )
	VALUES  (
					    @objectId
					  , @objectType
					  , @instanceId
					  , @jsonData
					  , @status
					  , GETDATE()
					  , @createdBy
					  , GETDATE()
					  , @createdBy
           );

	SELECT SCOPE_IDENTITY();

END

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_JsonGetCurrent]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [AHOBPR].[SP_JsonGetCurrent]
@ObjectType VARCHAR(100),
 @ObjectId VARCHAR(256)
as

begin

  declare @CurrentId int;
        
      -- Get the Most Current JSON ID for the Type and ID
  if @ObjectType = 'user' 
    --if there is a user json, there should always be an info and a responses json.
    --if this is not the case for any reason, do not return the user json.  
    --The registrant portal code will attempt to recreate all three if no user json is returned by this stored procedure.
    select @CurrentId = max([REGISTRANT_JSON_ID]) 
        from [AHOBPR].[REGISTRANT_JSON]  with (nolock)
       where [OBJECT_TYPE] = 'user'  
         and [OBJECT_ID] = @ObjectId
         and exists (select * from [AHOBPR].[REGISTRANT_JSON] where [OBJECT_ID] = @ObjectId and [OBJECT_TYPE] = 'info')
         and exists (select * from [AHOBPR].[REGISTRANT_JSON] where [OBJECT_ID] = @ObjectId and [OBJECT_TYPE] = 'responses')
  else
      select @CurrentId = MAX([REGISTRANT_JSON_ID]) 
      from   [AHOBPR].[REGISTRANT_JSON]  with (nolock)
      where  [OBJECT_TYPE] = @ObjectType  
         and [OBJECT_ID] = @ObjectId;
         
  -- Get the record   
  select 
                REGISTRANT_JSON_ID
              , OBJECT_ID
              , OBJECT_TYPE
              , JSON_DATA
              , CREATEDBY
              , UPDATEDBY
              , CREATED
              , UPDATED
    from [AHOBPR].[REGISTRANT_JSON] with (nolock)
    where [REGISTRANT_JSON_ID] = @CurrentId;

end
-- EXECUTE AHOBPR.SP_JsonGetCurrent 'user','09965f08893c3e7075d87368c60b1d1cd7b8248b2d4970afe4fc0009d9187cd98abdd4e8e23a2164443053382d8a6291627bbf0717e203d8b170657499f662eb'
/*
select top 1 * from ahobpr.registrant_json r where object_type = 'user'
  and (not exists (select * from [AHOBPR].[REGISTRANT_JSON] where [OBJECT_ID] =r.Object_Id and [OBJECT_TYPE] = 'info')
  or not exists (select * from [AHOBPR].[REGISTRANT_JSON] where [OBJECT_ID] = r.Object_Id and [OBJECT_TYPE] = 'responses'))
  */


GO
/****** Object:  StoredProcedure [AHOBPR].[SP_LoadDodDeploymentInsert]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 2015-08-07
-- Description:	Move data from Staged table, creating orphans and massaging data

-- Modification log
CREATE PROCEDURE [AHOBPR].[SP_LoadDodDeploymentInsert]
AS
BEGIN

  PRINT 'Truncate DoD Depoyment...';
  
  TRUNCATE TABLE [AHOBPR].[DOD_DEPLOYMENT_IMPORT];

  PRINT 'Add Orphan Country codes if needed...';

  WITH Staged
  AS( 
      SELECT DISTINCT LOCATION
        FROM AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT
     )
     INSERT INTO [AHOBPR].[STD_COUNTRY]
             ([CODE]
             ,[DESCRIPTION])
     SELECT LOCATION,
            LOCATION + ' - Orphan'
       FROM Staged
  WHERE NOT EXISTS(SELECT [CODE]
                     FROM [AHOBPR].[STD_COUNTRY]
                     WHERE [CODE] = LOCATION);
                     
  PRINT 'Add Orphan Pay Grade codes if needed...';

  WITH Staged
  AS( 
      SELECT DISTINCT GRADE
        FROM AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT
     )
     INSERT INTO AHOBPR.STD_PAY_PLAN_GRADE
             ([CODE]
             ,[DESCRIPTION])
     SELECT GRADE,
            GRADE + ' - Orphan'
       FROM Staged
  WHERE NOT EXISTS(SELECT [CODE]
                     FROM AHOBPR.STD_PAY_PLAN_GRADE
                     WHERE [CODE] = GRADE);

  PRINT 'Set Service Name values...';

  WITH MasterData
  AS (
      SELECT *
        FROM ( VALUES
        ('A','Army'),
        ('C','Coast Guard'),
        ('F','Air Force'),
        ('M','Marine Corps'),
        ('N','Navy')
              ) Record(Code, ServiceName)
       )
  ,Src 
  AS (
  SELECT Staged.DEPLOYMENT_ID, ServiceName
    FROM MasterData
    JOIN AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT AS Staged
      ON Staged.SVC = MasterData.Code
      )
  MERGE INTO AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT AS Tgt
  USING Src
     ON Tgt.DEPLOYMENT_ID = Src.DEPLOYMENT_ID
  WHEN MATCHED
  THEN UPDATE
          SET Tgt.[Service] = Src.ServiceName;

  PRINT 'Set Component Name values...';

  WITH MasterData
  AS (
      SELECT *
        FROM ( VALUES
        ('R','Regular'),
        ('V','Reserve'),
        ('G','Guard')
              ) Record(Code, CompoName)
       )
  ,Src 
  AS (
  SELECT Staged.DEPLOYMENT_ID, CompoName
    FROM MasterData
    JOIN AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT AS Staged
      ON Staged.COMPO = MasterData.Code
      )
  MERGE INTO AHOBPR.STAGED_DOD_DEPLOYMENT_IMPORT AS Tgt
  USING Src
     ON Tgt.DEPLOYMENT_ID = Src.DEPLOYMENT_ID
  WHEN MATCHED
  THEN UPDATE
          SET Tgt.[Component] = Src.CompoName;

  PRINT 'Load from Statged into DOD Deployment..';
                     
  DECLARE @Now DATETIME2(0) = GETDATE();
  DECLARE @DefaultStart DATETIME2(0) = '20010101';

  INSERT INTO [AHOBPR].[DOD_DEPLOYMENT_IMPORT]
             ([EDIPI]
             ,[SERVICE]
             ,[COMPO]
             ,[LOCATION]
             ,[DEPLOYMENT_START_DATE]
             ,[DEPLOYMENT_END_DATE]
             ,[LOCATION_START_DATE]
             ,[LOCATION_END_DATE]
             ,[PAY_PLAN_GRADE]
             ,[IMPORT_DATE])
  SELECT [EDIPI]
        ,ISNULL(SUBSTRING([Service],1,15),SVC)
        ,ISNULL(SUBSTRING([Component],1,10),COMPO)
        ,[LOCATION]
        ,ISNULL([DEP_BGN_CDT], @DefaultStart)
        ,ISNULL([DEP_END_CDT], @Now)
        ,ISNULL([LOC_BEGIN_DATE], @DefaultStart)
        ,ISNULL([LOC_END_DATE], @Now)
        ,[GRADE]
        ,@Now
        --,[PN_SEX_CD] -- New fields to be added next release
        --,[MRTL_STAT_CD]
        --,[EDU_LVL_CD]
        --,[RACE_CD]
        --,[ETH_AFF_CD]
        --,[DTY_DOD_OCC_CD]
    FROM [AHOBPR].[STAGED_DOD_DEPLOYMENT_IMPORT];
    
END;
    -- EXECUTE  [AHOBPR].[SP_LoadDodDeploymentInsert]    -- about 8 minutes

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_LoadJsonQueue]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE PROCEDURE [AHOBPR].[SP_LoadJsonQueue]
AS

BEGIN

  -- DELETE any duplicate REGISTRANT_JSON rows
  WITH AllRows
  AS (
      SELECT [REGISTRANT_JSON_ID]
            ,[OBJECT_ID]
            ,[OBJECT_TYPE]
            ,RANK() OVER(PARTITION BY [OBJECT_TYPE], [OBJECT_ID]
                             ORDER BY [REGISTRANT_JSON_ID] DESC) AS RowRank
        FROM [AHOBPR].[REGISTRANT_JSON]
       )
  ,Duplicates 
     AS(
         SELECT [REGISTRANT_JSON_ID] 
           FROM AllRows
           WHERE RowRank > 1
        )
      DELETE FROM [AHOBPR].[REGISTRANT_JSON]
       WHERE EXISTS(SELECT * FROM Duplicates 
                     WHERE Duplicates.REGISTRANT_JSON_ID = [REGISTRANT_JSON].REGISTRANT_JSON_ID);
                     
  -- Insert the rest into JSON_QUEUE     
  WITH Src 
AS(SELECT [REGISTRANT_JSON_ID]
         ,[CREATED]
         ,[UPDATED]
         ,[CREATEDBY]
         ,[UPDATEDBY]
     FROM [AHOBPR].[REGISTRANT_JSON]
     )
     MERGE INTO [AHOBPR].[JSON_QUEUE] Tgt
     USING Src
        ON Tgt.[REGISTRANT_JSON_ID] = Src.[REGISTRANT_JSON_ID]
     WHEN NOT MATCHED
     THEN INSERT  
            ([REGISTRANT_JSON_ID]
            ,[CREATED]
            ,[UPDATED]
            ,[CREATEDBY]
            ,[UPDATEDBY])
            VALUES(
         Src.[REGISTRANT_JSON_ID]
        ,Src.[CREATED]
        ,Src.[UPDATED]
        ,Src.[CREATEDBY]
        ,Src.[UPDATEDBY]);
END

-- EXECUTE [AHOBPR].[SP_LoadJsonQueue]

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_PostMigrationDataUpdates]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE PROCEDURE [AHOBPR].[SP_PostMigrationDataUpdates]
      
AS
BEGIN

  PRINT 'PostMigrationDataUpdates.sql started...';
  PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';

  PRINT 'Step 01 - Set display Question Number...'; 
   
  With GoodValues 
  AS (
  SELECT Q.STD_FORM_QUESTION_ID
        ,CONVERT(VARCHAR(10),sec.BRP_FORM_SECTION_ID) + '.'
        +CONVERT(VARCHAR(10),ss.[BRP_FORM_SUB_SECTION_ID])+ '.'
        +Q.BRP_FORM_QUESTION_ID AS CalculatedID
    FROM AHOBPR.STD_FORM_QUESTION Q 
    JOIN [AHOBPR].[STD_FORM_SUB_SECTION] ss  ON Q.STD_FORM_SUB_SECTION_ID = ss.STD_FORM_SUB_SECTION_ID
    JOIN AHOBPR.STD_FORM_SECTION sec         ON sec.STD_FORM_SECTION_ID = ss.STD_FORM_SECTION_ID 
    )
    MERGE INTO AHOBPR.STD_FORM_QUESTION as Tgt
    USING GoodValues AS Src
       ON tgt.STD_FORM_QUESTION_ID = Src.STD_FORM_QUESTION_ID
     WHEN MATCHED
     THEN  UPDATE
              SET Tgt.FORM_QUESTION_UNIQUE_ID = Src.CalculatedID;
 
  PRINT 'Step 02 - Clear all Clinical Relevant Flag...)';
  
  UPDATE AHOBPR.STD_FORM_ANSWER
    SET CLINICAL_RELEVANT_FLAG = 0;
  
  PRINT 'Step 03 - Setting Clinical Relevant Flag...)';
  
  WITH  MasterData
    AS ( 
          SELECT *
          FROM   ( VALUES
          ('1.2.A','Yes'),
          ('1.2.F','Yes'),
          ('1.2.G',''),
          ('1.3.B',''),
          ('1.4.C',''),
          ('1.4.D','Yes'),
          ('1.4.E',''),
          ('1.4.F','Yes'),
          ('2.1.D','can''t do it at all'),
          ('2.1.D','somewhat difficult'),
          ('2.1.D','very difficult'),
          ('2.1.E','can''t do it at all'),
          ('2.1.E','somewhat difficult'),
          ('2.1.E','very difficult'),
          ('2.1.F','Arthritis/rheumatism'),
          ('2.1.F','Back or neck problem'),
          ('2.1.F','Benign Tumors, Cysts'),
          ('2.1.F','Birth defect'),
          ('2.1.F','Brain injury, (for example, Traumatic Brain Injury/TBI, Intellectual disability)'),
          ('2.1.F','Cancer'),
          ('2.1.F','Circulation problems (including blood clots)'),
          ('2.1.F','Depression/anxiety/emotional problem'),
          ('2.1.F','Diabetes'),
          ('2.1.F','Epilepsy, seizures'),
          ('2.1.F','Fibromyalgia, lupus'),
          ('2.1.F','Fracture, bone/joint injury'),
          ('2.1.F','Hearing problem'),
          ('2.1.F','Heart problem'),
          ('2.1.F','Hernia'),
          ('2.1.F','Hypertension/high blood pressure'),
          ('2.1.F','Kidney, bladder or renal problems'),
          ('2.1.F','Knee problems (not arthritis, not joint injury)'),
          ('2.1.F','Lung/breathing problem (for example, asthma and emphysema)'),
          ('2.1.F','Migraine headaches (not just headaches)'),
          ('2.1.F','Missing limbs (fingers, toes or digits), amputee'),
          ('2.1.F','Multiple Sclerosis (MS), Muscular Dystrophy (MD)'),
          ('2.1.F','Osteoporosis, tendinitis'),
          ('2.1.F','Other developmental problem (for example, cerebral palsy)'),
          ('2.1.F','Other injury'),
          ('2.1.F','Other nerve damage, including carpal tunnel syndrome'),
          ('2.1.F','Parkinson''s disease, other tremors'),
          ('2.1.F','Polio (myelitis), paralysis, para/quadriplegia'),
          ('2.1.F','Senility'),
          ('2.1.F','Stroke problem'),
          ('2.1.F','Thyroid problems, Grave''s disease, gout'),
          ('2.1.F','Ulcer'),
          ('2.1.F','Varicose veins, hemorrhoids'),
          ('2.1.F','Vision/problem seeing'),
          ('2.1.F','Weight problem'),
          ('2.2.1.B','Yes'),
          ('2.2.1.C','Yes'),
          ('2.2.1.D','Yes'),
          ('2.2.1.E','Yes'),
          ('2.2.1.F','Yes'),
          ('2.2.1.G','Yes'),
          ('2.2.1.H','Yes'),
          ('2.2.1.I','After deployment'),
          ('2.2.1.I','Before deployment'),
          ('2.2.1.I','During deployment'),
          ('2.2.1.J','About the same'),
          ('2.2.1.J','Better'),
          ('2.2.1.J','Worse'),
          ('2.2.1.M','Stopping for breath after walking about 100 yards or after a few minutes on level ground'),
          ('2.2.1.M','Too breathless to leave the house, or breathless when dressing or undressing'),
          ('2.2.1.M','Walking slower than most people on level ground, stop after one mile, or stop after 15 minutes walking at my own pace'),
          ('2.4.A','Yes'),
          ('2.4.B','Bladder'),
          ('2.4.B','Blood'),
          ('2.4.B','Bone'),
          ('2.4.B','Brain'),
          ('2.4.B','Breast'),
          ('2.4.B','Cervix'),
          ('2.4.B','Colon'),
          ('2.4.B','Esophagus'),
          ('2.4.B','Gallbladder'),
          ('2.4.B','Kidney'),
          ('2.4.B','Larynx-windpipe'),
          ('2.4.B','Leukemia'),
          ('2.4.B','Liver'),
          ('2.4.B','Lung'),
          ('2.4.B','Lymphoma'),
          ('2.4.B','Melanoma'),
          ('2.4.B','Mouth/tongue/lip'),
          ('2.4.B','Other'),
          ('2.4.B','Ovary'),
          ('2.4.B','Pancreas'),
          ('2.4.B','Prostate'),
          ('2.4.B','Rectum'),
          ('2.4.B','Skin (Don''t Know what kind)'),
          ('2.4.B','Skin (non-melanoma)'),
          ('2.4.B','Soft tissue (muscle or fat)'),
          ('2.4.B','Stomach'),
          ('2.4.B','Testis'),
          ('2.4.B','Throat-pharynx'),
          ('2.4.B','Thyroid'),
          ('2.4.B','Uterus'),
          ('2.5.A','No'),
          ('2.5.A','Yes'),
          ('2.5.C','Don''t know'),
          ('2.5.C','Everyday'),
          ('2.5.C','I do not wish to answer'),
          ('2.5.C','Not at all'),
          ('2.5.C','Some days'),
          ('3.1.A','About the same'),
          ('3.1.A','Better'),
          ('3.1.A','Worse'),
          ('3.1.E','A little concerned'),
          ('3.1.E','Very concerned'),
          ('3.1.F','Cancer'),
          ('3.1.F','Effect on children or ability to have children'),
          ('3.1.F','Eye problem'),
          ('3.1.F','Gastrointestinal (GI) problem'),
          ('3.1.F','Heart problem'),
          ('3.1.F','Immune problem'),
          ('3.1.F','Lung/Respiratory/Breathing problem'),
          ('3.1.F','Neurological problem'),
          ('3.1.F','Other problem'),
          ('3.1.F','Skin problem'),
          ('3.1.H','Yes'),
          ('3.1.J','Cancer'),
          ('3.1.J','Effect on children or ability to have children'),
          ('3.1.J','Eyes'),
          ('3.1.J','Heart'),
          ('3.1.J','Lung/Respiratory/Breathing'),
          ('3.1.J','Other'),
          ('3.1.J','Skin'),
          ('5.4.A','Yes'),
          ('5.4.B.4','Yes'),
          ('5.5.D','Yes')
          )
           AS MasterRecord(QuestionID, AnswerText)
         )
         UPDATE AHOBPR.STD_FORM_ANSWER
         SET CLINICAL_RELEVANT_FLAG = 1
         WHERE STD_FORM_ANSWER_ID IN 
              (       
                SELECT A.STD_FORM_ANSWER_ID           
                  FROM AHOBPR.STD_FORM_ANSWER A
                  JOIN AHOBPR.STD_FORM_QUESTION B 
                    ON A.STD_FORM_QUESTION_ID = B.STD_FORM_QUESTION_ID 
                 WHERE EXISTS(SELECT * FROM MasterData 
                               WHERE B.FORM_QUESTION_UNIQUE_ID = MasterData.QuestionID
                                 AND ISNULL(A.[TEXT],'') = MasterData.AnswerText)
               );  
            
  PRINT 'Step 04 - Loading Tool Tips for Sections...';

  WITH  MasterData
  AS    ( 
          SELECT *
          FROM    ( VALUES       
        (1,'To view questionnaire responses for Deployment History select from the sub sections below.'),
        (2,'To view questionnaire responses to Symptoms & Medical History select from the sub sections below.'),
        (3,'Select to view registrant responses to Health Concerns.'),
        (4,'Select to view registrant responses to Places You''ve Lived.'),
        (5,'To view questionnaire responses to Work History select from the sub sections below.'),
        (6,'Select to view registrant responses to Home Environment & Hobbies.'),
        (7,'Select to view registrant responses to Health Care Utilization.'),
        (8,'Select to view registrant responses to Contact Preferences.')
        )
         AS MasterRecord(id, TextValue)
         )       
  MERGE
    INTO  AHOBPR.STD_FORM_SECTION   AS Tgt
    USING MasterData AS Src
    ON    Tgt.BRP_FORM_SECTION_ID = Src.id
   WHEN MATCHED 
   THEN UPDATE SET Tgt.TOOL_TIP = Src.TextValue;   
 
  PRINT 'Step 05 - Loading Tool Tips for Sub Sections...';
       
  WITH  MasterData
  AS    ( 
          SELECT *
          FROM    ( VALUES       
                    (1,1,'Select to view registrant deployment history received from deployment interfaces.'),
                    (1,2,'Select to view registrant responses for deployment specific questions.'),
                    (1,3,'Select to view registrant responses to Military Occupational Exposures.'),
                    (1,4,'Select to view registrant responses to Environment Exposures & Air Pollution.'),
                    (2,1,'Select to view registrant responses to Functional Limitations & Reported Causes.'),
                    (2,2,'Select to view registrant responses to Health Conditions.'),
                    (2,3,'Select to view registrant responses to Height & Weight.'),
                    (2,4,'Select to view registrant responses to Cancer History.'),
                    (2,5,'Select to view registrant responses to Tobacco Exposure.'),
                    (2,6,'Select to view registrant responses to Deployment Smoking History.'),
                    (2,7,'Select to view registrant responses to Month Alcohol Use.'),
                    (3,1,'Select to view registrant responses to Health Concerns.'),
                    (4,1,'Select to view registrant responses to Places You''ve Lived.'),
                    (5,1,'Select to view registrant responses to Current Occupational Status.'),
                    (5,2,'Select to view registrant responses to Main Occupation.'),
                    (5,3,'Select to view registrant responses to Dust Exposures.'),
                    (5,4,'Select to view registrant responses to Gas, Smoke, Vapors or Fumes Exposure.'),
                    (5,5,'Select to view registrant responses to Asbestos Exposure.'),
                    (6,1,'Select to view registrant responses to Home Environment & Hobbies.'),
                    (7,1,'Select to view registrant responses to Health Care Utilization.'),
                    (8,1,'Select to view registrant responses to Contact Preferences.')
        )
         AS MasterRecord(SectionId, SubSectionId, TextValue)
   )
   ,Src
   AS(     
     SELECT STD_FORM_SUB_SECTION_ID AS ssId, TextValue
       FROM [AHOBPR].[STD_FORM_SUB_SECTION]
       JOIN AHOBPR.STD_FORM_SECTION 
         ON STD_FORM_SECTION.STD_FORM_SECTION_ID = STD_FORM_SUB_SECTION.STD_FORM_SECTION_ID
       JOIN MasterData 
            ON MasterData.SectionId = STD_FORM_SECTION.BRP_FORM_SECTION_ID
            AND MasterData.SubSectionId = STD_FORM_SUB_SECTION.BRP_FORM_SUB_SECTION_ID
   )
  MERGE
    INTO  AHOBPR.STD_FORM_SUB_SECTION   AS Tgt
    USING  Src
    ON    Tgt.STD_FORM_SUB_SECTION_ID = Src.ssId
   WHEN MATCHED 
   THEN UPDATE SET Tgt.TOOL_TIP = Src.TextValue;
       
  PRINT 'Step 06 - Update STD_FORM_SECTION...';
 
  WITH  MasterData
    AS ( 
          SELECT *
          FROM   ( VALUES
					  (1,'Deployment History'),
					  (2,'Symptoms & Medical History'),
					  (3,'Health Concerns'),
					  (4,'Places You''ve Lived'),
					  (5,'Work History'),
					  (6,'Home Environment & Hobbies'),
					  (7,'Health Care Utilization'),
					  (8,'Contact Preferences')			   )
           AS MasterRecord([BRP_FORM_SECTION_ID], [MENU_ITEM_NAME]) 
         )
   , Src 
   AS (
       SELECT sec.STD_FORM_SECTION_ID, 
            MasterData.[BRP_FORM_SECTION_ID], MasterData.[MENU_ITEM_NAME]
       FROM MasterData 
       JOIN AHOBPR.STD_FORM_SECTION sec ON sec.[BRP_FORM_SECTION_ID] = MasterData.[BRP_FORM_SECTION_ID]
       )
       MERGE
    INTO  [AHOBPR].[STD_FORM_SECTION] AS Tgt
    USING  Src
    ON    Tgt.[STD_FORM_SECTION_ID] = Src.[STD_FORM_SECTION_ID]
    WHEN MATCHED 
   THEN UPDATE SET Tgt.[MENU_ITEM_NAME] = Src.[MENU_ITEM_NAME]; 
   
  PRINT 'Step 07 Update [STD_FORM_SUBSECTION]...';  

  WITH  MasterData
    AS ( 
          SELECT *
          FROM   ( VALUES
				  (1,1,'Deployments'),
				  (1,2,'Deployment Exposures'),
				  (1,3,'Military Occupational Exposures'),
				  (1,4,'Environmental Exposures & Air Pollution'),
				  (2,1,'Functional Limitation & Reported Cause'),
				  (2,2,'Health Conditions'),
				  (2,3,'Height & Weight'),
				  (2,4,'Cancer History'),
				  (2,5,'Tobacco Exposure'),
				  (2,6,'Deployment Smoking History'),
				  (2,7,'12 Month Alcohol Use'),
				  (5,1,'Current Occupational Status'),
				  (5,2,'Main Occupation'),
				  (5,3,'Dust Exposures'),
				  (5,4,'Gas, Smoke, Vapors or Fumes Exposure?'),
				  (5,5,'Asbestos Exposure')
			     )
           AS MasterRecord ( [SECTION_ID], [SUB_SECTION_ID], [MENU_ITEM]) 
         ),
  Src AS (
         SELECT ss.STD_FORM_SUB_SECTION_ID, -- [SECTION_ID], [SUB_SECTION_ID], 
                  [MENU_ITEM]
         FROM MasterData
         JOIN AHOBPR.[STD_FORM_SUB_SECTION] ss ON ss.[BRP_FORM_SUB_SECTION_ID] = MasterData.[SUB_SECTION_ID]
         JOIN AHOBPR.[STD_FORM_SECTION] sec ON ss.[STD_FORM_SECTION_ID] = sec.[STD_FORM_SECTION_ID]
         WHERE MasterData.[SECTION_ID] = sec.BRP_FORM_SECTION_ID
       )
    MERGE
    INTO  [AHOBPR].[STD_FORM_SUB_SECTION] AS Tgt
    USING  Src
    ON    Tgt.[STD_FORM_SUB_SECTION_ID] = Src.[STD_FORM_SUB_SECTION_ID]
    WHEN MATCHED 
    THEN UPDATE 
            SET Tgt.[MENU_ITEM_NAME] = Src.[MENU_ITEM];

  PRINT 'Step 08 - Set Short Text = Text with HTML removed.';       
       
  UPDATE [AHOBPR].[STD_FORM_QUESTION]
       SET SHORT_TEXT = REPLACE(REPLACE(REPLACE([TEXT],'<strong>',''),'</strong>',''),'</br>','');

 PRINT 'Step 09 - Update Question Unique ID to short form for sections 1,3,6,7 & 8 - Should be 33 ';       
 
  With ShortValues 
  AS (
  SELECT Q.STD_FORM_QUESTION_ID
        ,CONVERT(VARCHAR(10),sec.BRP_FORM_SECTION_ID) + '.'
        +Q.BRP_FORM_QUESTION_ID AS CalculatedID
   FROM AHOBPR.STD_FORM_QUESTION Q 
    JOIN [AHOBPR].[STD_FORM_SUB_SECTION] ss  ON Q.STD_FORM_SUB_SECTION_ID = ss.STD_FORM_SUB_SECTION_ID
    JOIN AHOBPR.STD_FORM_SECTION sec         ON sec.STD_FORM_SECTION_ID = ss.STD_FORM_SECTION_ID 
    WHERE sec.BRP_FORM_SECTION_ID IN (1,3,6,7,8)
      AND ss.BRP_FORM_SUB_SECTION_ID = 1
    )
    MERGE INTO AHOBPR.STD_FORM_QUESTION as Tgt
    USING ShortValues AS Src
       ON tgt.STD_FORM_QUESTION_ID = Src.STD_FORM_QUESTION_ID
     WHEN MATCHED
     THEN  UPDATE
              SET Tgt.FORM_QUESTION_UNIQUE_ID = Src.CalculatedID;  
              
  PRINT 'ENABLE TRIGGER TRG_REGISTRANT_JSON_INSERT';               
              
  ENABLE TRIGGER TRG_REGISTRANT_JSON_INSERT ON AHOBPR.REGISTRANT_JSON;
  
  PRINT 'DROP INDEX [IX_REGISTRANT_JSON_Object] If it exists..';    
  
  IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_JSON]') AND name = N'IX_REGISTRANT_JSON_Object')
      DROP INDEX [IX_REGISTRANT_JSON_Object] ON [AHOBPR].[REGISTRANT_JSON] WITH ( ONLINE = OFF );

  PRINT 'CREATE INDEX [IX_REGISTRANT_JSON_Object] ....';    

  CREATE NONCLUSTERED INDEX [IX_REGISTRANT_JSON_Object] ON [AHOBPR].[REGISTRANT_JSON] 
  (
	  [OBJECT_TYPE] ASC,
	  [OBJECT_ID] ASC,
	  [REGISTRANT_JSON_ID] ASC
  )WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [AHOBPR];

              

  PRINT '';
  PRINT 'PostMigrationDataUpdates.sql Script End.';
  PRINT '';
  PRINT 'Completed ' + CAST(GETDATE() AS varchar(20)) + '.';

END;

-- EXECUTE [AHOBPR].[SP_PostMigrationDataUpdates]

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_RecordEmailLog]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
-- =============================================
-- Author:		Deborah Barr
-- Create date: 2/23/2015
-- Description:	Used to log email
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_RecordEmailLog]
	@templateId as int,
	@registrantId as int,
	@userId as int,
	@eTo varchar(100),	 
	@eCC varchar(100),
	@eBCC varchar(max),
 	@subject varchar(200),
 	@body varchar(max)  ,
	@failed varchar(max),
	@createdBy varchar(30),
	@updatedBy varchar(30)
AS
BEGIN
	SET NOCOUNT ON;
	DECLARE @eId INT
	INSERT INTO
		EMAIL_LOG 
		(TEMPLATE_ID, REGISTRANT_ID, USER_ID ,EMAIL_SENT, EMAIL_TO  ,EMAIL_CC ,EMAIL_BCC ,subject , body, failed, CREATEDBY, UPDATEDBY )
	VALUES
		(@templateId, @registrantId, @userId, getdate(), @eTo, @eCC, @eBCC, @subject, @body, @failed, @createdBy, @updatedBy )

	SET @eId = SCOPE_IDENTITY() 
	SELECT @eId

END

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_ReportAdHocByIndividual]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report  

-- Modification log
-- 2014-12-31 - Changed from FLAG to RESPONSE for Health Concerns and REQUEST_SEEN, Reformatted statements for readability
-- 2015-01-05 - Change Date Format to MM/DD/YYYY
-- 2015-01-14 - Sherry Wang Add more parameters: @healthFactor, @formStartFromDate, @formStartToDate, @subpopulationFlag
-- 2015-01-14 - Sherry Wang Add more parameters: @adminFlag, @deploymentAll, @deploymentExposure, @adminFlagFromDate, @adminFlagToDate
-- 2015-01-16 - Bruce Clegg - Fix parameters and remove NULLs from display where possible
-- 2015-02-09 - Bruce Clegg - Change Health Factor Exists statements to use new REGISTRANT_VISIT
-- 2015-03-30 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 2015-04-27 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 2015-06-04 - Bruce Clegg - Add more parameters
-- 2015-06-18 - Bruce Clegg - Changed @separationType to an Integer 
-- 2015-07-09 - Bruce CLegg - Rewrote as Dynamic SQL for performance
-- 2016-02-03 - D. Barr - Fixed logic on Evaluation Location (Script 2.0.32.1)
-- 2016-02-07 - D. May - Addressed performance of specific question query
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportAdHocByIndividual]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @dutyStatus varchar(100) = NULL, -- Multiple states, comma-separated values when not NULL  
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @gender varchar(50) = '',
       @race varchar(50) = '',
       @ethnicity varchar(50) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @enrollmentStatus varchar(50) = '',
       @evaluation varchar(100) = 'All'
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);   
  DECLARE @AnswerWith VARCHAR(8000) = '';             

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
	SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText)); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
  -- Set InstitutionID values if needed.
  DECLARE @AssignedInstitutionId INT = 0,
          @EvaluatedInstitutionId INT = 0;


  IF @AssignedLocationType IN ('Base','Institution') 
  AND ISNUMERIC(@AssignedLocationKey) = 1
    SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
  IF @EvaluatedLocationType IN ('Base','Institution') 
  AND ISNUMERIC(@EvaluatedLocationKey) = 1
    SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);


  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = '
WITH SubPop AS 
     ( 
      SELECT a.REGISTRANT_ID, 
             STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME 
                    FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b 
                    JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID 
                    WHERE a.REGISTRANT_ID = b.REGISTRANT_ID 
                       AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) + '
                   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] 
      FROM AHOBPR.REGISTRANT a 
      WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = '
                    , Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = '
                    , Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                               ' FROM AHOBPR.REGISTRANT a ' +
                               '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',(a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',c.SERVICE_STATUS AS DutyStatus ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
--Decide which query to run depending on if a question was selected as a parameter for the report
  IF ISNULL(@questionNumber, '') = ''
    SET @MainQuery = @MainQuery + ','''' AS QuestionNumber ' +
                                  ','''' AS Answer '
  ELSE                                 
    SET @MainQuery = @MainQuery + ',''' + @questionNumber + ''' AS QuestionNumber ' +
                                  ',STUFF((SELECT '', '' + stdAnswer.TEXT ' +
                                          '  FROM AHOBPR.FORM_RESPONSE_ANSWER answer ' + 
                                          '  JOIN AHOBPR.STD_FORM_ANSWER stdAnswer ON answer.STD_FORM_ANSWER_ID = stdAnswer.STD_FORM_ANSWER_ID ' +
                                          ' WHERE formQuestion.FORM_RESPONSE_QUESTION_ID = answer.FORM_RESPONSE_QUESTION_ID ' +
                                          ' FOR XML PATH('''')), 1, 1, '''') AS Answer ' ;                  
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                              ' JOIN AHOBPR.STD_SERVICE_STATUS c ON a.STD_SERVICE_STATUS_ID = c.STD_SERVICE_STATUS_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';

  SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
  

  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
  BEGIN    
      SET @AnswerWith = '
, selectedAnswerInstance as
(
  select BRP_FORM_ANSWER_ID, A.STD_FORM_QUESTION_ID, Q.FORM_QUESTION_UNIQUE_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on Q.STD_FORM_QUESTION_ID = A.STD_FORM_QUESTION_ID
  where a.STD_FORM_ANSWER_ID IN (' + @answer + ')--user specified answer
)
, selectedAnswer as
(
  select STD_FORM_ANSWER_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on A.STD_FORM_QUESTION_ID = Q.STD_FORM_QUESTION_ID
  where EXISTS (select * from selectedAnswerInstance --1:39 w/o brp_form_answer_id index 0:37 with
                where A.BRP_FORM_ANSWER_ID      = selectedAnswerInstance.BRP_FORM_ANSWER_ID
                  and Q.FORM_QUESTION_UNIQUE_ID = selectedAnswerInstance.FORM_QUESTION_UNIQUE_ID
                )
) ';
    SET @MainQuery = @MainQuery +  '
  AND EXISTS(select *
              from AHOBPR.FORM_RESPONSE_ANSWER a 
              join selectedAnswer on selectedAnswer.STD_FORM_ANSWER_ID = a.STD_FORM_ANSWER_ID
              where a.FORM_RESPONSE_QUESTION_ID = formQuestion.FORM_RESPONSE_QUESTION_ID
            )'; 
  END;                                                   

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF ISNULL(@adminFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
                                              
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
  IF (@evaluation = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ;     
                                                      
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';

  IF ISNULL(@dutyStatus,'') > ''
    SET @RegCriteria = @RegCriteria + ' AND a.STD_SERVICE_STATUS_ID IN (' + @dutyStatus + ')';
          
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@gender,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @gender + ''' = ISNULL(a.GENDER,''No Data Available'') ';
    
  IF ISNULL(@ethnicity,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @ethnicity + ''' = ISNULL(a.ETHNICITY,''No Data Available'') ';
  
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@race,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @race + ''' =  ISNULL(a.RACE ,''No Data Available'') ';
    
  IF ISNULL(@enrollmentStatus,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @enrollmentStatus + ''' = ISNULL(a.ENROLLMENT_STATUS,''No Data Available'') ';

  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
   
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
    
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith + @AnswerWith +  @MainQuery + @RegCriteria;            

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @dutyStatus = '1,2'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formStartFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @subpopulationFlag = '64,65,66,67'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @deploymentAll = 'Egypt'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @adminFlag = '59,60' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @questionNumber = '5.4.A'  , @answer = '2221'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual]
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual]  @ethnicity = 'JEWISH'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'


--EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual]  @status = '7', @questionNumber = '1.3.A'  , @answer = '39'; --4:08 atfer index
--


GO

/****** Object:  StoredProcedure [AHOBPR].[SP_ReportAdHocByLocation]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report  

-- Modification log
-- 2014-12-31 - Changed from FLAG to RESPONSE for Health Concerns and REQUEST_SEEN, Reformatted statements for readability
-- 2015-01-05 - Change Date Format to MM/DD/YYYY
-- 2015-01-14 - Sherry Wang Add more parameters: @healthFactor, @formStartFromDate, @formStartToDate, @subpopulationFlag
-- 2015-01-14 - Sherry Wang Add more parameters: @adminFlag, @deploymentAll, @deploymentExposure, @adminFlagFromDate, @adminFlagToDate
-- 2015-01-16 - Bruce Clegg - Fix parameters, Add distinct and outer query to group counts.
-- 2015-02-09 - Bruce Clegg - Change Health Factor Exists statements to use new REGISTRANT_VISIT
-- 2015-05-07 - Bruce Clegg - Change Facility name from "Other" to "No Facitilty Assigned" when not found
-- 2015-06-04 - Bruce Clegg - Add more parameters
-- 2015-06-18 - Bruce Clegg - Changed @separationType to an Integer 
-- 2015-07-09 - Bruce Clegg - Rewrote as Dynamic SQL for performance
-- 2015-08-05 - Bruce Clegg - Fix bug with AdminFlag - Set From and To date defaults
-- 2015-12-11 - D Barr      - added evaluation parameter
-- Deborah Barr - Script 2.0.16.1
-- 2016-02-08    D May - Performance Improvement when answer is specified. Script 2.0.32.2
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportAdHocByLocation]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @dutyStatus varchar(100) = NULL, -- Multiple states, comma-separated values when not NULL  
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(10) = 'All', 
       @requestToBeSeen varchar(10) = 'All',
       @groupBy VARCHAR(50) = '',                 -- 'VISN' or 'Facility'   
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @gender varchar(50) = '',
       @race varchar(50) = '',
       @ethnicity varchar(50) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @enrollmentStatus varchar(50) = '',
       @evaluation varchar(100) = 'All'
AS

BEGIN

  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL;
          
  DECLARE @Query VARCHAR(8000);         
  DECLARE @AnswerWith VARCHAR(8000) = '';

  -- Convert date parameters      

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
  SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));   

  -- Build Src TDE
  SET @Query = 'WITH ';

  IF ISNULL(@answer,'') != ''
    SET @Query = @Query + '
selectedAnswerInstance as
(
  select BRP_FORM_ANSWER_ID, A.STD_FORM_QUESTION_ID, Q.FORM_QUESTION_UNIQUE_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on Q.STD_FORM_QUESTION_ID = A.STD_FORM_QUESTION_ID
  where a.STD_FORM_ANSWER_ID IN (' + @answer + ')--user specified answer
)
, selectedAnswer as
(
  select STD_FORM_ANSWER_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on A.STD_FORM_QUESTION_ID = Q.STD_FORM_QUESTION_ID
  where EXISTS (select * from selectedAnswerInstance --1:39 w/o brp_form_answer_id index 0:37 with
                where A.BRP_FORM_ANSWER_ID      = selectedAnswerInstance.BRP_FORM_ANSWER_ID
                  and Q.FORM_QUESTION_UNIQUE_ID = selectedAnswerInstance.FORM_QUESTION_UNIQUE_ID
                )
), ';

 SET @Query = @Query + '
 Src 
    AS( SELECT a.REGISTRANT_ID, a.STD_INSTITUTION_ID 
        FROM AHOBPR.REGISTRANT a 
        WHERE 1 = 1 
';
                                   
  IF @status IS NOT NULL
    SET @Query = @Query + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';

  IF ISNULL(@dutyStatus,'') > ''
    SET @Query = @Query + ' AND a.STD_SERVICE_STATUS_ID IN (' + @dutyStatus + ')';
          
  IF @healthConcerns != 'All'
    SET @Query = @Query + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @Query = @Query + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
    
  IF @formStartFromDate IS NOT NULL OR @formStartToDate IS NOT NULL 
    OR @formCompletionFromDate IS NOT NULL OR @formCompletionToDate IS NOT NULL
  BEGIN
    SET @Query = @Query + '
AND EXISTS( SELECT d.REGISTRANT_ID 
            FROM AHOBPR.FORM_RESPONSE d 
		        JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID	
		        WHERE a.REGISTRANT_ID = d.REGISTRANT_ID ';
		IF @formStartFromDate IS NOT NULL                     
		    SET @Query = @Query + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
		IF @formStartToDate IS NOT NULL                     
		    SET @Query = @Query + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
		IF @formCompletionFromDate IS NOT NULL                     
		    SET @Query = @Query + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';
		IF @formCompletionToDate IS NOT NULL                     
		    SET @Query = @Query + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
		SET @Query = @Query + ' ) ' -- Close Exists statement
  END    
    
  IF ISNULL(@answer,'') != '' 
  BEGIN
    SET @Query = @Query +  '
and exists( select *
            from AHOBPR.FORM_RESPONSE_ANSWER fra 
            join AHOBPR.FORM_RESPONSE_QUESTION frq  on frq.FORM_RESPONSE_QUESTION_ID = fra.FORM_RESPONSE_QUESTION_id
            join AHOBPR.FORM_RESPONSE fr           on fr.FORM_RESPONSE_ID = frq.FORM_RESPONSE_ID
            join selectedAnswer                   on selectedAnswer.STD_FORM_ANSWER_ID = fra.STD_FORM_ANSWER_ID
            where a.REGISTRANT_ID = fr.REGISTRANT_ID
          )'; 
                 
--  SET @Query = @Query + '
--AND EXISTS(SELECT fr.REGISTRANT_ID FROM AHOBPR.FORM_RESPONSE_ANSWER ra ' + 
--                        'JOIN AHOBPR.FORM_RESPONSE_QUESTION rq ON rq.FORM_RESPONSE_QUESTION_ID = ra.FORM_RESPONSE_QUESTION_ID  ' + 
--                        'JOIN AHOBPR.FORM_RESPONSE fr ON fr.FORM_RESPONSE_ID = rq.FORM_RESPONSE_ID  ' + 
--                        'JOIN AHOBPR.STD_FORM_ANSWER A1 ON A1.STD_FORM_ANSWER_ID = ra.STD_FORM_ANSWER_ID ' + 
--                        'JOIN AHOBPR.STD_FORM_QUESTION Q1 ON Q1.STD_FORM_QUESTION_ID = rq.STD_FORM_QUESTION_ID ' + 
--                        'JOIN AHOBPR.STD_FORM_QUESTION Q2 ON Q2.FORM_QUESTION_UNIQUE_ID = Q1.FORM_QUESTION_UNIQUE_ID ' + 
--                        'JOIN AHOBPR.STD_FORM_ANSWER A2 ON A2.STD_FORM_QUESTION_ID = Q2.STD_FORM_QUESTION_ID ' + 
--                        ' AND A1.BRP_FORM_ANSWER_ID = A2.BRP_FORM_ANSWER_ID ' + 
--                      ' WHERE A2.STD_FORM_ANSWER_ID IN (' + @answer + ') AND fr.REGISTRANT_ID = a.REGISTRANT_ID )';                         
  END;                       
  
  IF ISNULL(@subpopulationFlag,'') != ''
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF ISNULL(@adminFlag,'') != ''
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
                            
  IF ISNULL(@healthFactor,'') != ''
    SET @Query = @Query + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

  IF ISNULL(@deploymentAll,'') != '' 
    SET @Query = @Query + ' AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                       ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                           AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;

  IF ISNULL(@deploymentExposure,'') != '' 
    SET @Query = @Query + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID = ''1.2.A'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
IF (@evaluation = 'Yes') 
		 SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @Query = @Query + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ;                                    
                                      
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @Query = @Query + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@gender,'') != ''
    SET @Query = @Query + ' AND ''' + @gender + ''' = ISNULL(a.GENDER,''No Data Available'') ';
    
  IF ISNULL(@ethnicity,'') != ''
    SET @Query = @Query + ' AND ''' + @ethnicity + ''' = ISNULL(a.ETHNICITY,''No Data Available'') ';
  
  IF ISNULL(@separationType,0) != 0
    SET @Query = @Query + ' AND ''' + @separationType + ''' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @Query = @Query + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @Query = @Query + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@race,'') != ''
    SET @Query = @Query + ' AND ''' + @race + ''' =  ISNULL(a.RACE ,''No Data Available'') ';
    
  IF ISNULL(@enrollmentStatus,'') != ''
    SET @Query = @Query + ' AND ''' + @enrollmentStatus + ''' = ISNULL(a.ENROLLMENT_STATUS,''No Data Available'') ';

  -- Add Summary TDE                   
  SET @Query = @Query + '  )	,Summary  AS( ' + 
                        ' SELECT Src.STD_INSTITUTION_ID, COUNT(*) AS TotalRegistrants FROM Src ' +
                        ' GROUP BY STD_INSTITUTION_ID ) ';
-- By Facility 
	IF @groupBy = 'Facility'
	BEGIN  SET @Query = @Query + ' 
SELECT  inst.Name AS Location, 
        ISNULL(CONVERT(VARCHAR(10),Summary.STD_INSTITUTION_ID),''-1'') AS LocationId, 
        SUM(TotalRegistrants) AS TotalRegistrants 
FROM      Summary
JOIN      AHOBPR.VIEW_INSTITUTION_NAME inst ON inst.ID = ISNULL(Summary.STD_INSTITUTION_ID,-1) 
GROUP BY  inst.Name,STD_INSTITUTION_ID 
OPTION    (OPTIMIZE FOR UNKNOWN);';
  END
  ELSE -- By VISN
  BEGIN
	  IF @groupBy = 'VISN'
	     SET @Query = @Query + '
,VisnSummary AS 
 ( 
  SELECT ISNULL(inst.VisnID,''NLA'') AS Location, 
        ISNULL(inst.VisnID, ''-1'') AS LocationId, 
        SUM(TotalRegistrants) AS TotalRegistrants        
   FROM Summary 
   LEFT JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = ISNULL(Summary.STD_INSTITUTION_ID,-1)  
   GROUP BY inst.VisnID  
 ) --close the WITH
 SELECT REPLACE(Location,''NLA'',''No Facitilty Assigned'') AS Location,
        CONVERT(VARCHAR(10),LocationId) AS LocationId, TotalRegistrants 
   FROM VisnSummary  
  ORDER BY Location 
  OPTION (OPTIMIZE FOR UNKNOWN); ' ;
	END;

  PRINT @Query;		
  		                     
  EXECUTE (@Query);  		                     		
END
-- Parameters
  --@status, @dutyStatus ,@questionnaireStartDate, @questionnaireCompleteDate, 
  --@questionNumber, @answer, @healthConcerns= 'All', @requestToBeSeen = 'All',
  --@registryFlag,@InstitutionId = 0, @VisnId = '' 
-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @evaluation = 'No'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @dutyStatus = '1,2'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formStartFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @healthConcerns = 'Yes' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @requestToBeSeen = 'Yes'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @subpopulationFlag = '64,65,66,67'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @deploymentAll = 'Iraq'    -- 'Egypt'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @adminFlag = '59,60' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @answer = '39'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy =  'Facility' , @status = '6,7' ,@answer = '2346,1571,17'   -- '20,795,1570' 

GO

/****** Object:  StoredProcedure [AHOBPR].[SP_ReportClinicallyRevelantSummary]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
-- =============================================
--      Author:		Bruce Clegg
-- Create date: February 4, 2015
-- Description:	Used for the AHOBPR Clinically Revelant Summary
--        Note: Data is massaged for questions 1.2.A, 1.2.F, 1.2.G, 2.5.A and 2.5.C 
-- Modification log
-- 20150427 - Clegg - get deployment counts independent of Question numbers
-- 20150811 - Clegg - remove testing value
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportClinicallyRevelantSummary]
       @RegistrantId INT = 0         
AS
BEGIN

   --Temp table concatenate Answers for Questions
  CREATE TABLE #Answers
  (
     QuestionNumber VARCHAR(100),
     QuestionNumberDisplay VARCHAR(100),
     AnswerValues VARCHAR(8000)
  ); 


  -- Load all clinical relevent answers that are NOT from a Deployment
  WITH Responses
  AS (SELECT qst.FORM_QUESTION_UNIQUE_ID AS QuestionNumber,
	           ISNULL(rAns.ANSWER_VALUE,ans.[TEXT])  AS AnswerValue
	      FROM AHOBPR.REGISTRANT reg
	      JOIN AHOBPR.FORM_RESPONSE fr ON fr.REGISTRANT_ID = Reg.REGISTRANT_ID
	      JOIN AHOBPR.FORM_RESPONSE_QUESTION rQst ON fr.FORM_RESPONSE_ID = rQst.FORM_RESPONSE_ID
	      JOIN AHOBPR.FORM_RESPONSE_ANSWER rAns ON rQst.FORM_RESPONSE_QUESTION_ID = rAns.FORM_RESPONSE_QUESTION_ID
	      JOIN AHOBPR.STD_FORM_ANSWER ans ON rAns.STD_FORM_ANSWER_ID = ans.STD_FORM_ANSWER_ID
	      JOIN AHOBPR.STD_FORM_QUESTION qst ON rQst.STD_FORM_QUESTION_ID = qst.STD_FORM_QUESTION_ID
	     WHERE fr.STD_FORM_ID = ans.STD_FORM_ID
	       AND qst.STD_FORM_ID = fr.STD_FORM_ID
	       AND ans.CLINICAL_RELEVANT_FLAG = 1
	       AND reg.REGISTRANT_ID = @RegistrantId
	       AND rQst.REGISTRANT_DEPLOYMENT_ID IS NULL
  )

  INSERT INTO #Answers (QuestionNumber, QuestionNumberDisplay, AnswerValues)
   SELECT a.QuestionNumber, a.QuestionNumber,
          STUFF((SELECT '~' + b.AnswerValue 
          FROM Responses b 
         WHERE a.QuestionNumber = b.QuestionNumber 
                FOR XML PATH('')), 1, 1, '')  AnswerValues
          FROM Responses a
      GROUP BY a.QuestionNumber
      ORDER BY a.QuestionNumber;
      
      
  -- Get Deployment Count without limiting it to a specific Question.
     DECLARE @DeploymentCount INT = 0;
     With Deployments 
     AS(   
         SELECT DISTINCT rQst.REGISTRANT_DEPLOYMENT_ID
           FROM AHOBPR.REGISTRANT reg
           JOIN AHOBPR.FORM_RESPONSE fr ON fr.REGISTRANT_ID = Reg.REGISTRANT_ID
           JOIN AHOBPR.FORM_RESPONSE_QUESTION rQst ON fr.FORM_RESPONSE_ID = rQst.FORM_RESPONSE_ID
          WHERE reg.REGISTRANT_ID = @RegistrantId 
            AND rQst.REGISTRANT_DEPLOYMENT_ID IS NOT NULL
        )
     SELECT @DeploymentCount =  COUNT(REGISTRANT_DEPLOYMENT_ID) 
       FROM Deployments;  
     
  -- Load specific clinical relevent answers summarized for all Deployments - '1.2.A','1.2.F' 
  INSERT INTO #Answers (QuestionNumber, QuestionNumberDisplay, AnswerValues)
       SELECT qst.FORM_QUESTION_UNIQUE_ID AS QuestionNumber
             ,qst.FORM_QUESTION_UNIQUE_ID AS QuestionNumberDisplay
	           ,'Said yes to '+ CONVERT(VARCHAR(2),SUM(CASE WHEN ISNULL(rAns.ANSWER_VALUE,ans.[TEXT]) = 'Yes' THEN 1 ELSE 0 END)) 
	           + ' of ' + CONVERT(VARCHAR(2),@DeploymentCount) + ' deployments' AS AnswerValues
          FROM AHOBPR.REGISTRANT reg
          JOIN AHOBPR.FORM_RESPONSE fr ON fr.REGISTRANT_ID = Reg.REGISTRANT_ID
          JOIN AHOBPR.FORM_RESPONSE_QUESTION rQst ON fr.FORM_RESPONSE_ID = rQst.FORM_RESPONSE_ID
          LEFT JOIN AHOBPR.FORM_RESPONSE_ANSWER rAns ON rQst.FORM_RESPONSE_QUESTION_ID = rAns.FORM_RESPONSE_QUESTION_ID
          LEFT JOIN AHOBPR.STD_FORM_ANSWER ans ON rAns.STD_FORM_ANSWER_ID = ans.STD_FORM_ANSWER_ID
          JOIN AHOBPR.STD_FORM_QUESTION qst ON rQst.STD_FORM_QUESTION_ID = qst.STD_FORM_QUESTION_ID
         WHERE qst.STD_FORM_ID = fr.STD_FORM_ID
           AND reg.REGISTRANT_ID = @RegistrantId
           AND qst.FORM_QUESTION_UNIQUE_ID in ('1.2.A','1.2.F')
           GROUP BY qst.FORM_QUESTION_UNIQUE_ID; 
  
    -- Always Delete any zero counts from above that were created in order to capture true Deployment count.          
  DELETE FROM #Answers WHERE AnswerValues LIKE 'Said yes to 0 of % deployments'
                          AND QuestionNumber in ('1.2.A','1.2.F');
  
    
  -- Load specific clinical relevent answers summarized for all Deployments -- '1.2.G'
  INSERT INTO #Answers (QuestionNumber, QuestionNumberDisplay, AnswerValues)
      SELECT qst.FORM_QUESTION_UNIQUE_ID AS QuestionNumber
           ,qst.FORM_QUESTION_UNIQUE_ID AS QuestionNumberDisplay
	         ,'Maximum: '+ CONVERT(VARCHAR(2),MAX(CONVERT(INT,rAns.ANSWER_VALUE))) 
	         + ' hours, Average: '+ LEFT(CONVERT(VARCHAR(20),AVG(CONVERT(DECIMAL(6,2),rAns.ANSWER_VALUE))),4)
	         + ' hours, Deployments: ' + CONVERT(VARCHAR(2),@DeploymentCount) AS AnswerValues
        FROM AHOBPR.REGISTRANT reg
        JOIN AHOBPR.FORM_RESPONSE fr ON fr.REGISTRANT_ID = Reg.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE_QUESTION rQst ON fr.FORM_RESPONSE_ID = rQst.FORM_RESPONSE_ID
        JOIN AHOBPR.FORM_RESPONSE_ANSWER rAns ON rQst.FORM_RESPONSE_QUESTION_ID = rAns.FORM_RESPONSE_QUESTION_ID
        JOIN AHOBPR.STD_FORM_QUESTION qst ON rQst.STD_FORM_QUESTION_ID = qst.STD_FORM_QUESTION_ID
       WHERE qst.STD_FORM_ID = fr.STD_FORM_ID
         AND qst.STD_FORM_ID = fr.STD_FORM_ID
         AND reg.REGISTRANT_ID = @RegistrantId
         AND qst.FORM_QUESTION_UNIQUE_ID = '1.2.G'
         GROUP BY qst.FORM_QUESTION_UNIQUE_ID; 
                                   
    -- Always Delete any Null or Empty Answers.          
  DELETE FROM #Answers WHERE ISNULL(AnswerValues,'')  = '';
      

  -- Tobacco Exposure
  -- if both 2.5.A and 2.5.C exist, replace with Combined answer text'  
  DECLARE @25A VARCHAR(200) = (SELECT AnswerValues FROM #Answers WHERE QuestionNumber = '2.5.A')
  DECLARE @25C VARCHAR(200) = (SELECT AnswerValues FROM #Answers WHERE QuestionNumber = '2.5.C')
  IF @25A = 'Yes'
       IF  @25C = 'Not at all'
          UPDATE #Answers SET AnswerValues = 'Past Smoker' 
                             ,QuestionNumberDisplay = '2.5'
                        WHERE QuestionNumber = '2.5.A';
       ELSE
          UPDATE #Answers SET AnswerValues = 'Current Smoker'
                             ,QuestionNumberDisplay = '2.5'
                        WHERE QuestionNumber = '2.5.A';
   IF  @25A = 'No'
       UPDATE #Answers SET AnswerValues = 'Never smoked' 
                             ,QuestionNumberDisplay = '2.5'
                        WHERE QuestionNumber = '2.5.A';

  -- Always Delete 2.5.C, as it cannot stand on it's own         
  DELETE FROM #Answers WHERE QuestionNumber = '2.5.C';     
      
  -- Final Query         
	SELECT DISTINCT 
          list.QuestionNumberDisplay AS QuestionNumber
	       ,CASE WHEN qst.SHORT_TEXT = 'Have you smoked at least 100 cigarettes in your entire life?'  -- 2.5.A
	             THEN 'Have you ever smoked?'
	             ELSE qst.SHORT_TEXT END  AS QuestionText
	       ,REPLACE(list.AnswerValues,'~','<br/>') AS AnswerValues
	       ,sec.STD_FORM_SECTION_ID AS SectionId                    
	       ,sub.STD_FORM_SUB_SECTION_ID AS SubsectionId	              
	       ,CASE WHEN ISNULL(sub.MENU_ITEM_NAME, '') = '' 
	             THEN Convert(VARCHAR, sec.BRP_FORM_SECTION_ID) + ' ' + sec.MENU_ITEM_NAME
	             ELSE Convert(VARCHAR, sec.BRP_FORM_SECTION_ID) + '.' + Convert(VARCHAR, sub.BRP_FORM_SUB_SECTION_ID) + ' ' + sec.MENU_ITEM_NAME + ' > ' + sub.MENU_ITEM_NAME
	             END AS SectionAndSubSection
	  FROM AHOBPR.REGISTRANT reg
	  JOIN AHOBPR.FORM_RESPONSE fr ON fr.REGISTRANT_ID = Reg.REGISTRANT_ID
	  JOIN AHOBPR.FORM_RESPONSE_QUESTION rQst ON fr.FORM_RESPONSE_ID = rQst.FORM_RESPONSE_ID
	  JOIN AHOBPR.STD_FORM_QUESTION qst ON rQst.STD_FORM_QUESTION_ID = qst.STD_FORM_QUESTION_ID
	  JOIN #Answers list ON qst.FORM_QUESTION_UNIQUE_ID = list.QuestionNumber 
	  JOIN STD_FORM_SECTION sec ON sec.STD_FORM_SECTION_ID = qst.STD_FORM_SECTION_ID
	  JOIN STD_FORM_SUB_SECTION sub ON sub.STD_FORM_SUB_SECTION_ID = qst.STD_FORM_SUB_SECTION_ID
	 WHERE qst.STD_FORM_ID = fr.STD_FORM_ID
	   AND reg.REGISTRANT_ID = @RegistrantId;
	  	 
  DROP TABLE #Answers
END

-- EXEC [AHOBPR].[SP_ReportClinicallyRevelantSummary] 149
-- 5  6  7  8  108

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_ReportContactHistory]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
-- =============================================
-- Object:      StoredProcedure [AHOBPR].[SP_ReportContactHistory]
-- Author:		  Bruce Clegg
-- Create date: 21 May 2015
-- Description:	Make 4 tables look like one
--
-- Modification Log:
-- 2015.05.21 Bruce Clegg - Create Procedure
-- 2015.07.14 CleggB - changed UpdatedDate and output from Date to DateTime2(0)
CREATE PROCEDURE [AHOBPR].[SP_ReportContactHistory]
	@RegistrantId INT = NULL 
WITH EXECUTE AS OWNER
AS
BEGIN

  DECLARE @RowCount SMALLINT = 0;

  DECLARE @Results TABLE(UpdatedDate        DATETIME2(0)
                         ,[STREET1]         VARCHAR(256)
                         ,[STREET2]         VARCHAR(256)
                         ,[CITY]            VARCHAR(100)
                         ,[STATE]           VARCHAR(100)
                         ,[ZIP]             VARCHAR(15)
                         ,[COUNTRY]         VARCHAR(100) 
                         ,PhoneNumber       VARCHAR(50)
                         ,MobileNumber      VARCHAR(50)
                         ,EMAIL             VARCHAR(256)  );  
                             
  DECLARE  @UpdatedDate    DATETIME2(0)
          ,@MyOrder        INT
          ,@Street1        VARCHAR(256)
          ,@Street2        VARCHAR(256)
          ,@City           VARCHAR(100)
          ,@State          VARCHAR(100)
          ,@Zip            VARCHAR(15)
          ,@Country        VARCHAR(100) 
          ,@PhoneNumber    VARCHAR(50)
          ,@MobileNumber   VARCHAR(50)
          ,@Email          VARCHAR(256);     

  DECLARE  @UpdatedDateOut    DATETIME2(0)
          ,@Street1Out        VARCHAR(256)
          ,@Street2Out        VARCHAR(256)
          ,@CityOut           VARCHAR(100)
          ,@StateOut          VARCHAR(100)
          ,@ZipOut            VARCHAR(15)
          ,@CountryOut        VARCHAR(100) 
          ,@PhoneNumberOut    VARCHAR(50)
          ,@MobileNumberOut   VARCHAR(50)
          ,@EmailOut          VARCHAR(256);                                        

  DECLARE MyCursor CURSOR LOCAL
  FOR
  WITH Addr
  AS (
      SELECT DISTINCT
             [REGISTRANT_ID]
            ,[STREET1]
            ,[STREET2]
            ,[CITY]
            ,[STATE]
            ,[ZIP]
            ,[COUNTRY]
            ,[Audit_Date] AS UpdatedDate
            ,CONVERT(INT,'1') AS MyOrder
        FROM [AHOBPR].[REGISTRANT_ADDRESS_H]
       WHERE [Audit_Type] != 'DELETE'
         AND [REGISTRANT_ID] = @RegistrantId
     )
    ,Phone
    AS (
        SELECT DISTINCT
               [REGISTRANT_ID]
              ,[PHONE_NUMBER] as PhoneNumber
              ,[Audit_Date] AS UpdatedDate
              ,CONVERT(INT,'2') AS MyOrder          
          FROM [AHOBPR].[REGISTRANT_PHONE_H]
         WHERE ISNULL([TYPE],'') != 'Mobile'
           AND [Audit_Type] != 'DELETE'
           AND [REGISTRANT_ID] = @RegistrantId      
        )
    ,Mobile
    AS (
        SELECT DISTINCT
               [REGISTRANT_ID]
              ,[PHONE_NUMBER] AS MobileNumber
              ,[Audit_Date] AS UpdatedDate
              ,CONVERT(INT,'3') AS MyOrder
          FROM [AHOBPR].[REGISTRANT_PHONE_H]
         WHERE [TYPE] = 'Mobile'
           AND [Audit_Type] != 'DELETE'
           AND [REGISTRANT_ID] = @RegistrantId          
        )  
   ,Email
   AS (
       SELECT DISTINCT 
              [REGISTRANT_ID]
             ,[EMAIL]
             ,[Audit_Date] AS UpdatedDate
             ,CONVERT(INT,'4') AS MyOrder          
         FROM [AHOBPR].[REGISTRANT_EMAIL_H]
        WHERE [Audit_Type] != 'DELETE'
          AND [REGISTRANT_ID] = @RegistrantId          
       )
        SELECT Addr.UpdatedDate
              ,Addr.Myorder
              ,[STREET1]
              ,[STREET2]
              ,[CITY]
              ,[STATE]
              ,[ZIP]
              ,[COUNTRY]
              ,NULL AS PhoneNumber
              ,NULL as MobileNumber
              ,NULL as EMAIL
          FROM Addr
       UNION
       SELECT Phone.UpdatedDate
              ,Phone.Myorder
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,PhoneNumber
              ,NULL as MobileNumber
              ,NULL as EMAIL
          FROM Phone
       UNION
       SELECT Mobile.UpdatedDate
              ,Mobile.Myorder
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL AS PhoneNumber
              ,MobileNumber
              ,NULL as EMAIL
          FROM Mobile        
        UNION
        SELECT Email.UpdatedDate
              ,Email.Myorder
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL
              ,NULL AS PhoneNumber
              ,NULL AS MobileNumber
              ,Email.EMAIL
          FROM Email          
          ORDER BY UpdatedDate DESC, MyOrder ASC;
          
          
    OPEN MyCursor;
    
    FETCH NEXT FROM MyCursor  -- priming read
     INTO @UpdatedDate
          ,@MyOrder   
          ,@Street1   
          ,@Street2   
          ,@City      
          ,@State     
          ,@Zip       
          ,@Country   
          ,@PhoneNumber
          ,@MobileNumber
          ,@Email;       
    
    SET @UpdatedDateOut = @UpdatedDate;          
     
    WHILE @@FETCH_STATUS = 0 -- Not End of file
      BEGIN
        -- If new date, or nowhere to put data value, Insert into temp and clear Output variables
        IF (@UpdatedDate != @UpdatedDateOut AND @RowCount > 0)
        OR (@MyOrder = 1 AND @Street1Out IS NOT NULL)
        OR (@MyOrder = 2 AND @PhoneNumberOut IS NOT NULL)
        OR (@MyOrder = 3 AND @MobileNumberOut IS NOT NULL)
        OR (@MyOrder = 4 AND @EmailOut IS NOT NULL)
        BEGIN
         INSERT INTO @Results (UpdatedDate
                             ,[STREET1]
                             ,[STREET2]
                             ,[CITY]        
                             ,[STATE]         
                             ,[ZIP]          
                             ,[COUNTRY]        
                             ,PhoneNumber     
                             ,MobileNumber    
                             ,EMAIL  )
                      VALUES(@UpdatedDateOut
                            ,@Street1Out
                            ,@Street2Out
                            ,@CityOut
                            ,@StateOut
                            ,@ZipOut
                            ,@CountryOut
                            ,@PhoneNumberOut
                            ,@MobileNumberOut
                            ,@EmailOut);
                            
         SET @UpdatedDateOut = @UpdatedDate;
         SET @Street1Out = NULL;
         SET @Street2Out = NULL;
         SET @CityOut = NULL;
         SET @StateOut = NULL;
         SET @ZipOut = NULL;
         SET @CountryOut = NULL;
         SET @PhoneNumberOut = NULL;
         SET @MobileNumberOut = NULL;
         SET @EmailOut = NULL;                           
        END
        
        SET @RowCount = @RowCount + 1;
        
        -- Set Address Fields
        IF @MyOrder = 1
           BEGIN
             SET @Street1Out = @Street1;
             SET @Street2Out = @Street2;
             SET @CityOut = @City;
             SET @StateOut = @State;
             SET @ZipOut = @Zip;
             SET @CountryOut = @Country;
           END;
                      
        -- Set Phone Number
        IF @MyOrder = 2   
           SET @PhoneNumberOut = @PhoneNumber;
           
        IF @MyOrder = 3
           SET @MobileNumberOut = @MobileNumber;
           
        IF @MyOrder = 4
           SET @EmailOut = @Email;        
      
        FETCH NEXT FROM MyCursor
         INTO @UpdatedDate
              ,@MyOrder   
              ,@Street1   
              ,@Street2   
              ,@City      
              ,@State     
              ,@Zip       
              ,@Country   
              ,@PhoneNumber
              ,@MobileNumber
              ,@Email;       
          
      END;  -- End of loop   
      
      --write last record
     INSERT INTO @Results (UpdatedDate
                   ,[STREET1]
                   ,[STREET2]
                   ,[CITY]        
                   ,[STATE]         
                   ,[ZIP]          
                   ,[COUNTRY]        
                   ,PhoneNumber     
                   ,MobileNumber    
                   ,EMAIL  )
            VALUES(@UpdatedDateOut
                  ,@Street1Out
                  ,@Street2Out
                  ,@CityOut
                  ,@StateOut
                  ,@ZipOut
                  ,@CountryOut
                  ,@PhoneNumberOut
                  ,@MobileNumberOut
                  ,@EmailOut);
    CLOSE MyCursor;
    
    SELECT UpdatedDate
          ,ISNULL(STREET1,'') AS Street1 
          ,ISNULL(STREET2,'') AS Street2
          ,ISNULL(CITY,'') AS City
          ,ISNULL(STATE,'') AS State
          ,ISNULL(ZIP,'') AS Zip
          ,ISNULL(COUNTRY,'') AS Country
          ,ISNULL(PhoneNumber,'') AS PhoneNumber
          ,ISNULL(MobileNumber,'') AS MobileNumber
          ,ISNULL(EMAIL,'') AS Email        
      FROM @Results
  ORDER BY UpdatedDate DESC;    
  
  END 
  
  -- EXECUTE [AHOBPR].[SP_ReportContactHistory] 5

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_ReportEligibility]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 01/20/2015
-- Description:	Used for the AHOBPR Eligibility Report  

-- Modification log

-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportEligibility]
       @status varchar(1000) = NULL, -- Multiple statues, comma-separated values when not NULL
       @adminFlag varchar (10) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL;
    
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE()));                         

    SELECT a.REGISTRANT_ID
		   ,a.SSN
           ,a.LAST_NAME 
           ,a.FIRST_NAME 
           ,a.MIDDLE_NAME
	  FROM AHOBPR.REGISTRANT a
	 WHERE (a.STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@status, ','))OR ISNULL(@status,'') = '')   
	   AND ((ISNULL(@adminFlag,'') = '')
 	         OR EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag
                      WHERE adminflag.STD_REGISTRY_FLAG_ID IN (SELECT * FROM fncSplit(@adminFlag, ','))
                        AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID
                        AND adminflag.CREATED BETWEEN @adminFlagFromDate AND @adminFlagToDate)); 			

END

-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportEligibility] 
-- EXECUTE [AHOBPR].[SP_ReportEligibility] @adminFlag = '59,60'
-- EXECUTE [AHOBPR].[SP_ReportEligibility] @status = '1,2,3,4'

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_ReportGetAnswerByID]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
-- =============================================
-- Author:		Deborah Barr
-- Create date: 1/9/2015
-- Description:	Used for the AHOBPR Ad Hoc Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetAnswerByID]
       @answerId varchar(100) = NULL -- Multiple statues, comma-separated values when not NULL 
       
AS
BEGIN
  DECLARE @answerDescription varchar(4000) = ''
  DECLARE @answer varchar(100)
	
  DECLARE curAnswer CURSOR 
      FOR
        SELECT TEXT
		FROM AHOBPR.STD_FORM_ANSWER
		WHERE STD_FORM_ANSWER_ID IN (SELECT * FROM fncSplit(@answerId, ','))
			OR ISNULL(@answerId, '') = '';

  OPEN curAnswer;
  FETCH NEXT FROM curAnswer INTO @answer;
  WHILE @@FETCH_STATUS = 0  -- Not End of file
	BEGIN
		if  @answerDescription != ''
			SET @answerDescription = @answerDescription + ', '
		
		SET @answerDescription = @answerDescription + @answer;
		FETCH NEXT FROM curAnswer INTO @answer;			
	END		
  CLOSE curAnswer;   
  DEALLOCATE curAnswer;    
  
  SELECT  @answerDescription AS ANSWER_DESCRIPTION 

END

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_ReportGetDutyStatusByID]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO

-- =============================================
-- Author:		Deborah Barr
-- Create date: December 08, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetDutyStatusByID]
       @dutyStatusId varchar(100) = NULL -- Multiple statues, comma-separated values when not NULL 
       
AS
BEGIN
  DECLARE @dutyStatusDescription varchar(4000) = ''
  DECLARE @dutyStatus varchar(100)
	
  DECLARE curDutyStatus CURSOR 
      FOR
        SELECT SERVICE_STATUS
		FROM AHOBPR.STD_SERVICE_STATUS
		WHERE STD_SERVICE_STATUS_ID IN (SELECT * FROM fncSplit(@dutyStatusId, ','))
			OR ISNULL(@dutyStatusId, '') = '';

  OPEN curDutyStatus;
  FETCH NEXT FROM curDutyStatus INTO @dutyStatus;
  WHILE @@FETCH_STATUS = 0  -- Not End of file
	BEGIN
		if  @dutyStatusDescription != ''
			SET @dutyStatusDescription = @dutyStatusDescription + ', '
		
		SET @dutyStatusDescription = @dutyStatusDescription + @dutyStatus;
		FETCH NEXT FROM curDutyStatus INTO @dutyStatus;			
	END		
  CLOSE curDutyStatus;   
  DEALLOCATE curDutyStatus;    
  
  SELECT  @dutyStatusDescription AS DUTY_STATUS_DESCRIPTION 

END

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_ReportGetFacilityNameByID]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
-- =============================================
-- Author:		Sherry Wang
-- Create date: January 07, 2015
-- Description:	Used for the AHOBPR Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetFacilityNameByID]
       @InstitutionId VARCHAR(50) = '0' 
       
AS
 BEGIN
  IF ISNULL(@InstitutionId,'0')  <> '0'
  AND ISNUMERIC(@InstitutionId) = 1
	  SELECT TOP (1) Name
	  FROM AHOBPR.VIEW_FACILITY_LOOKUP
	  WHERE ID =  @InstitutionId;
 END;
-- EXEC [AHOBPR].[SP_ReportGetFacilityNameByID] '1000109'

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_ReportGetFlagNameByID]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO


-- =============================================
-- Author:		Deborah Barr
-- Create date: 1/9/2015
-- Description:	Used for the AHOBPR Ad Hoc Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetFlagNameByID]
       @FlagId INT = 0 
       
AS
BEGIN  
	  SELECT  REGISTRY_FLAG_NAME
	  FROM AHOBPR.STD_REGISTRY_FLAG
	  WHERE STD_REGISTRY_FLAG_ID = @FlagId

END

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_ReportGetQuestionByID]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
-- =============================================
-- Author:		Deborah Barr
-- Create date: 1/9/2015
-- Description:	Used for the AHOBPR Ad Hoc Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetQuestionByID]
       @QuestionUniqueId varchar(100) = NULL
       
AS
BEGIN  
	  --SELECT  {fn concat(FORM_QUESTION_UNIQUE_ID, TEXT)} AS QUESTION_DESCRIPTION
	  SELECT  FORM_QUESTION_UNIQUE_ID + '  ' + TEXT AS QuestionDescription 
	  FROM AHOBPR.STD_FORM_QUESTION
	  WHERE FORM_QUESTION_UNIQUE_ID = @QuestionUniqueId

END

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_ReportGetStateByID]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
-- =============================================
-- Author:		Sherry Wang
-- Create date: December 01, 2014
-- Description:	Used for the AHOBPR Status by Location Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetStateByID]
       @stateId varchar(1000) = NULL -- Multiple statues, comma-separated values when not NULL 
       
AS
BEGIN
  SELECT  AHOBPR.GetStateCodeByID (@stateId) AS STATE_DESCRIPTION 
END

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_ReportGetStatusByID]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
-- =============================================
-- Author:		Sherry Wang
-- Create date: December 01, 2014
-- Description:	Used for the AHOBPR Status by Location Report
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportGetStatusByID]
       @statusId varchar(100) = NULL -- Multiple statues, comma-separated values when not NULL 
       
AS
BEGIN
  DECLARE @statusDescription varchar(4000) = ''
  DECLARE @status varchar(100)
	
  DECLARE curStatus CURSOR 
      FOR
        SELECT REGISTRANT_STATUS
		FROM AHOBPR.STD_REGISTRANT_STATUS
		WHERE STD_REGISTRANT_STATUS_ID IN (SELECT * FROM fncSplit(@statusId, ','))
			OR ISNULL(@statusId, '') = '';

  OPEN curStatus;
  FETCH NEXT FROM curStatus INTO @status;
  WHILE @@FETCH_STATUS = 0  -- Not End of file
	BEGIN
		if  @statusDescription != ''
			SET @statusDescription = @statusDescription + ', '
		
		SET @statusDescription = @statusDescription + @status;
		FETCH NEXT FROM curStatus INTO @status;			
	END		
  CLOSE curStatus;   
  DEALLOCATE curStatus;    
  
  SELECT  @statusDescription AS STATUS_DESCRIPTION 

END

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_ReportParticipantDetails]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:		Bruce Clegg
-- Create date: Jan 5, 2015
-- Description:	Used for the AHOBPR Participation Report Drilldown  -- exec [AHOBPR].[SP_ReportParticipantDetails]    (More options at bottom)
-- 20150330 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 20150427 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 20150504 - Bruce Clegg - Fix @RequestSeen selection logic to match Participation Report
-- 20150710 - Bruce Clegg - Rewrite using Dynamic SQL for Performance
-- 20150910 - Bruce Clegg - Removed selection for Question 1.2.A for Deployments
-- 20150916 - Bruce Clegg - Replace Eligable with Questionaire start date
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportParticipantDetails]
       @StartDate DATETIME2(0) = NULL,  
       @EndDate DATETIME2(0) = NULL,
       @RegistrantStatus  VARCHAR(50) = '',  -- 'Participant', 'Review - Not Eligible', 'Eligible', 'No Consent', 'Consent', 'Review'
       @SvcStatus  VARCHAR(50) = '',         -- 'Veteran', 'Retiree', 'Active Duty'
       @RequestSeen  VARCHAR(50) = '',       -- 'Yes', 'No', 'Unknown'
       @HealthConcern  VARCHAR(50) = '',     -- 'Yes', 'No'
       @DeploymentGroup VARCHAR(50) = '',    -- 'Afgh911', 'Iraq911', 'SouthwestAsiaAfter911', 'Pre911',  'DjiboutiAfter911'
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL   -- 'V16', 'V01'    1000109,  1000089
AS
BEGIN

  SET @StartDate = ISNULL(@StartDate,'19900802');  -- Desert Storm start date
  SET @EndDate = ISNULL(@EndDate, GetDate());
  SET @EndDate = dbo.AddMaxTime(@EndDate);  -- Adds 23:59:59 to criteria parameter

  DECLARE @AssignedInstitutionId INT = 0,
          @EvaluatedInstitutionId INT = 0;
  DECLARE @Query NVARCHAR(MAX);

  IF @AssignedLocationType IN ('Base','Institution') 
  AND ISNUMERIC(@AssignedLocationKey) = 1
    SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
  IF @EvaluatedLocationType IN ('Base','Institution') 
  AND ISNUMERIC(@EvaluatedLocationKey) = 1
    SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --Temp table for Deployments
  CREATE TABLE #Deployments
  (
	   [REGISTRANT_ID] INT
  ); 
  
  -- INSERT Registrants if they are in the Deployment Group
  SET @Query = ' INSERT INTO #Deployments([REGISTRANT_ID]) ' +
               ' SELECT DISTINCT deployment.REGISTRANT_ID ' +
               '   FROM AHOBPR.REGISTRANT_DEPLOYMENT deployment  ' +
               '  WHERE 1 = 1 ';
  IF @DeploymentGroup = 'Afgh911'    
     SET @Query =  @Query + ' AND [DEPLOYMENT_COUNTRY] = ''Afghanistan'' ' + 
                            ' AND [DEPLOYMENT_START_DATE] > ''20010911'' ';
  ELSE
  IF @DeploymentGroup = 'Iraq911'
      SET @Query =  @Query + ' AND [DEPLOYMENT_COUNTRY] = ''Iraq'' ' + 
                              'AND [DEPLOYMENT_START_DATE] > ''20010911'' '; 
  ELSE
  IF @DeploymentGroup = 'DjiboutiAfter911'
      SET @Query =  @Query + ' AND [DEPLOYMENT_COUNTRY] = ''Djibouti'' ' + 
                              'AND [DEPLOYMENT_START_DATE] > ''20010911'' '; 
  ELSE
  IF @DeploymentGroup = 'SouthwestAsiaAfter911'
      SET @Query =  @Query + ' AND [DEPLOYMENT_COUNTRY] IN (''Kuwait'',''Saudi Arabia'',''Bahrain'', ''Gulf of Aden'', ''Gulf of Oman'', ''Oman'', ''Qatar'', ''United Arab Emirates'', ''Persian Gulf'', ''Arabian Sea'', ''Red Sea'') ' +
                             'AND [DEPLOYMENT_START_DATE] > ''20010911''  ';
  ELSE
  IF @DeploymentGroup = 'Pre911'
      SET @Query =  @Query + ' AND [DEPLOYMENT_COUNTRY] IN (''Iraq'',''Kuwait'',''Saudi Arabia'',''Bahrain'', ''Gulf of Aden'', ''Gulf of Oman'', ''Oman'', ''Qatar'', ''United Arab Emirates'', ''Persian Gulf'', ''Arabian Sea'', ''Red Sea'') ' +     
                             ' AND [DEPLOYMENT_START_DATE] BETWEEN ''19900802'' AND ''20010911''  ';
  IF ISNULL(@DeploymentGroup,'') > ''
    EXECUTE(@Query);
   
  SET @Query = '
    WITH participant 
      AS (
         SELECT [REGISTRANT_ID], CONVERT(DATE,MAX([CREATED])) AS DateParticipant
           FROM [AHOBPR].[PROCESS_METRICS]
          WHERE [PROCESS_METRICS_VALUE] = ''Participant''   
          GROUP BY [REGISTRANT_ID]
          )        
  	SELECT reg.REGISTRANT_ID
		     ,(reg.LAST_NAME + '', '' + reg.FIRST_NAME) AS Name
		     ,stat.REGISTRANT_STATUS
		     ,svc.SERVICE_STATUS
		     ,QUESTIONNAIRE_COMPLETED_DATE
		     ,ISNULL(reg.REQUEST_SEEN_RESPONSE, ''Unknown'') AS REQUEST_SEEN_RESPONSE
		     ,ISNULL(reg.HEALTH_CONCERNS_RESPONSE,''No'') AS HEALTH_CONCERNS_RESPONSE
		     ,ISNULL(inst.Name,'''') AS InstitutionName
		     ,CONVERT(VARCHAR(10), responseStat.QUESTIONNAIRE_COMPLETED_DATE, 101) AS QUESTIONNAIRE_COMPLETED_Display
		     ,CASE WHEN DateParticipant > QUESTIONNAIRE_STARTED_DATE THEN DATEDIFF(Day,QUESTIONNAIRE_STARTED_DATE,DateParticipant) ELSE 0 END AS DaysEligibleToParticipant
         ,reg.BIRTH_DATE AS BirthDate
         ,CONVERT(VARCHAR(10), reg.BIRTH_DATE, 101) AS BirthDateDisplay
	  FROM AHOBPR.REGISTRANT reg
		JOIN AHOBPR.STD_REGISTRANT_STATUS stat 
		  ON reg.STD_REGISTRANT_STATUS_ID = stat.STD_REGISTRANT_STATUS_ID
		JOIN AHOBPR.STD_SERVICE_STATUS svc
		  ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID
		JOIN AHOBPR.FORM_RESPONSE resp 
		  ON resp.REGISTRANT_ID = reg.REGISTRANT_ID
		JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat
		  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID
    JOIN participant 
      ON reg.REGISTRANT_ID = participant.REGISTRANT_ID   		  
		LEFT JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst
		  ON inst.ID = reg.STD_INSTITUTION_ID
 	 WHERE responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN ''' + CONVERT(VARCHAR(20), @StartDate,121) + 
                                                   ''' AND ''' + CONVERT(VARCHAR(20), @EndDate,121) + ''' ';

  IF ISNULL(@RegistrantStatus,'') > ''
	  SET @Query = @Query + ' AND stat.REGISTRANT_STATUS = ''' + @RegistrantStatus + ''' ';

  IF ISNULL(@SvcStatus,'') > ''
    IF @SvcStatus = 'Veteran'
  	  SET @Query = @Query + ' AND svc.SERVICE_STATUS = ''Separated'' ';
  	ELSE
	    SET @Query = @Query + ' AND svc.SERVICE_STATUS = ''' +  @SvcStatus + ''' ';

  IF ISNULL(@HealthConcern,'') > ''
	  SET @Query = @Query + ' AND ISNULL(reg.HEALTH_CONCERNS_RESPONSE,''No'') = ''' +  @HealthConcern + ''' ';

  IF ISNULL(@RequestSeen,'') > ''
    IF @RequestSeen = 'Yes' OR @RequestSeen = 'No' 
	     SET @Query = @Query + 'AND reg.REQUEST_SEEN_RESPONSE = ''' + @RequestSeen + ''' ';
    ELSE
	     SET @Query = @Query + 'AND reg.REQUEST_SEEN_RESPONSE NOT IN ( ''Yes'', ''No'')  ';
	     

  IF ISNULL(@DeploymentGroup,'') > ''
	  SET @Query = @Query + 'AND EXISTS(SELECT * FROM #Deployments WHERE #Deployments.REGISTRANT_ID = reg.REGISTRANT_ID) ';

  IF @AssignedLocationType = 'NLA' 
    SET @Query = @Query + ' AND reg.STD_INSTITUTION_ID IS NULL ' ;

  IF @AssignedLocationType = 'VISN' 
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                          ' WHERE inst.ID = reg.STD_INSTITUTION_ID ' + 
                                                          '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
 
  IF @AssignedLocationType = 'Base' 
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                  ' WHERE inst.ID = reg.STD_INSTITUTION_ID ' +
                                                  '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
 
  IF @AssignedLocationType = 'Institution' 
    SET @Query = @Query + ' AND reg.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);

  IF @EvaluatedLocationType = 'NLA' 
    SET @Query = @Query + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                        ' WHERE eval.REGISTRANT_VISIT_ID = reg.REGISTRANT_ID ' +
                                                        '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
 
  IF @EvaluatedLocationType = 'VISN' 
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                    ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                  ' WHERE eval.REGISTRANT_VISIT_ID = reg.REGISTRANT_ID ' +
                                                    ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                    ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
 
  IF @EvaluatedLocationType = 'Base' 
    SET @Query = @Query +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                    ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                  ' WHERE eval.REGISTRANT_VISIT_ID = reg.REGISTRANT_ID ' +
                                                    ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                    ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
  
  IF @EvaluatedLocationType = 'Institution' 
    SET @Query = @Query +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                    ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                  ' WHERE eval.REGISTRANT_VISIT_ID = reg.REGISTRANT_ID ' +
                                                    ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                    ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 

  SET @Query = @Query + ' ORDER BY responseStat.QUESTIONNAIRE_COMPLETED_DATE ';

  PRINT @Query;
  
  EXECUTE(@Query);
      
  DROP TABLE #Deployments;                                                                                                       
END

-- exec [AHOBPR].[SP_ReportParticipantDetails] '20150901'
-- exec [AHOBPR].[SP_ReportParticipantDetails] '20140101', '20150101', NULL, NULL, 
-- exec [AHOBPR].[SP_ReportParticipantDetails] @RequestSeen = 'sdf'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, 'Participant'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, 'Separated'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, 'Yes'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, 'No'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, 'Unknown'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, 'Yes'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, 'No'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, 'Afgh911'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, 'Iraq911'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, 'SouthwestAsiaAfter911'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, 'DjiboutiAfter911'
-- exec [AHOBPR].[SP_ReportParticipantDetails] NULL, NULL, NULL, NULL, NULL, NULL, 'Pre911'

-- exec [AHOBPR].[SP_ReportParticipantDetails]
-- exec [AHOBPR].[SP_ReportParticipantDetails] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportParticipantDetails] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportParticipantDetails] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportParticipantDetails] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportParticipantDetails]
-- exec [AHOBPR].[SP_ReportParticipantDetails] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportParticipantDetails] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportParticipantDetails] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportParticipantDetails] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'



GO
/****** Object:  StoredProcedure [AHOBPR].[SP_ReportParticipation]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Bruce Clegg
-- Create date: Dec 30, 2014
-- Description:	Used for the AHOBPR Participation Report       -- exec [AHOBPR].[SP_ReportParticipation] 
-- 20150330 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 20150427 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 20150710 - Bruce Clegg - Rewrite using Dynamic SQL for Performance
-- 20150910 - Bruce Clegg - Removed selection for Question 1.2.A for Deployments
-- 20150915 - Bruce Clegg - Add Max Time to End date parameter
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportParticipation]
       @StartDate DATETIME2(0) = NULL,  
       @EndDate   DATETIME2(0) = NULL,
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL   -- 'V16', 'V01'    1000109,  1000089
AS
BEGIN

  SET @StartDate = ISNULL(@StartDate,'19900802'); -- Desert Storm start date
  SET @EndDate = ISNULL(@EndDate, GETDATE());
    
  SET @EndDate = dbo.AddMaxTime(@EndDate);
  
  DECLARE @ConsentStatusCount INT = 0,
          @EligibleStatusCount INT = 0,
          @ParticipantStatusCount INT = 0,
          @HealthConcernsCount INT = 0,
          @NoHealthConcernsCount INT = 0,
          @RequestSeenCount INT = 0,
          @NoRequestSeenCount INT = 0,
          @DoNotKnowRequestSeenCount INT = 0,
          @VeteranServiceStatusCount INT = 0,
          @ActiveDutyServiceStatusCount INT = 0,
          @RetireeServiceStatusCount INT = 0,
          @Afgh911Count INT = 0,
          @Iraq911Count INT = 0,
          @SWA911Count INT = 0,
          @Pre911Count INT = 0,
          @Djibouti911Count INT = 0,
          @MedianDaysToParticipant DECIMAL(9,2) = 0;    
  
  DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

  DECLARE @Query NVARCHAR(MAX);
  DECLARE @Criteria VARCHAR(2000) = '';

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --  Build Criteria string

  SET @Criteria = ' AND responseStat.QUESTIONNAIRE_COMPLETED_DATE BETWEEN ''' + CONVERT(VARCHAR(20),@StartDate,121) +
                                                                    ''' AND ''' + CONVERT(VARCHAR(20),@EndDate,121) + ''' ' ;
  IF @AssignedLocationType = 'NLA' 
    SET @Criteria = @Criteria + ' AND reg.STD_INSTITUTION_ID IS NULL ';

  IF @AssignedLocationType = 'VISN' 
    SET @Criteria = @Criteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                      ' WHERE inst.ID = reg.STD_INSTITUTION_ID ' +
                                         'AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
 	
  IF @AssignedLocationType = 'Base' 
    SET @Criteria = @Criteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                       'WHERE inst.ID = reg.STD_INSTITUTION_ID ' +
                                         'AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ' ) ';
            	
  IF @AssignedLocationType = 'Institution' 
    SET @Criteria = @Criteria + ' AND reg.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ' '	
  
  IF @EvaluatedLocationType = 'NLA' 
    SET @Criteria = @Criteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                            'WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                               'AND eval.EVALUATION_FLAG = ''Y'' ) ';
          
  IF @EvaluatedLocationType = 'VISN' 
    SET @Criteria = @Criteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                               'JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                             ' WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                                'AND inst.VisnID = ''' +  @EvaluatedLocationKey + ''' ' +
                                                'AND eval.EVALUATION_FLAG = ''Y'') ' ; 
         	
  IF @EvaluatedLocationType = 'Base' 
    SET @Criteria = @Criteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                               'JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                             ' WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + 
             	                          ' AND eval.EVALUATION_FLAG = ''Y'') '; 
  IF @EvaluatedLocationType = 'Institution' 
    SET @Criteria = @Criteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                      ' WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID '+
                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) +
                                        ' AND eval.EVALUATION_FLAG = ''Y'') '; 

  --  @ParticipantStatusCount
  SET @Query = ' SELECT @ParticipantStatusCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + @Criteria     
              + '  AND stat.REGISTRANT_STATUS = ''Participant'' '; 
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@ParticipantStatusCount INT OUTPUT',    @ParticipantStatusCount OUTPUT;

   
    --  @HealthConcernsCount
  SET @Query = ' SELECT @HealthConcernsCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + ' WHERE reg.HEALTH_CONCERNS_RESPONSE = ''Yes'' '
              + @Criteria; 
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@HealthConcernsCount INT OUTPUT',    @HealthConcernsCount OUTPUT;

  --  @NoHealthConcernsCount
  SET @Query = ' SELECT @NoHealthConcernsCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + ' WHERE reg.HEALTH_CONCERNS_RESPONSE IS NULL '
              + @Criteria; 
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@NoHealthConcernsCount INT OUTPUT',    @NoHealthConcernsCount OUTPUT;
                           

  --  @RequestSeenCount
  SET @Query = ' SELECT @RequestSeenCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + ' WHERE reg.REQUEST_SEEN_RESPONSE = ''Yes'' '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@RequestSeenCount INT OUTPUT',    @RequestSeenCount OUTPUT;
                                                     
  --  @NoRequestSeenCount
  SET @Query = ' SELECT @NoRequestSeenCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + ' WHERE reg.REQUEST_SEEN_RESPONSE = ''No'' '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@NoRequestSeenCount INT OUTPUT',    @NoRequestSeenCount OUTPUT;
                                                                                         
  --  @DoNotKnowRequestSeenCount
  SET @Query = ' SELECT @DoNotKnowRequestSeenCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID '  
              + ' WHERE ISNULL(reg.REQUEST_SEEN_RESPONSE,'''') NOT IN (''Yes'',''No'') '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@DoNotKnowRequestSeenCount INT OUTPUT', @DoNotKnowRequestSeenCount OUTPUT;      
                                                   
  --  @ActiveDutyServiceStatusCount
  SET @Query = ' SELECT @ActiveDutyServiceStatusCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID ' +
                '  JOIN AHOBPR.STD_SERVICE_STATUS svc  ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID '
              + ' WHERE svc.SERVICE_STATUS = ''Active Duty'' '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@ActiveDutyServiceStatusCount INT OUTPUT', @ActiveDutyServiceStatusCount OUTPUT;        
         
   
  --  @VeteranServiceStatusCount
  SET @Query = ' SELECT @VeteranServiceStatusCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID ' +
                '  JOIN AHOBPR.STD_SERVICE_STATUS svc  ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID '
              + ' WHERE svc.SERVICE_STATUS = ''Separated'' '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@VeteranServiceStatusCount INT OUTPUT', @VeteranServiceStatusCount OUTPUT;                    
 
  --  @RetireeServiceStatusCount
  SET @Query = ' SELECT @RetireeServiceStatusCount = COUNT(*) ' +
                '  FROM [AHOBPR].[REGISTRANT] reg ' +
                '  JOIN AHOBPR.STD_REGISTRANT_STATUS stat ON stat.STD_REGISTRANT_STATUS_ID = reg.STD_REGISTRANT_STATUS_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID ' +
                '  JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat  ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID ' +
                '  JOIN AHOBPR.STD_SERVICE_STATUS svc  ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID '
              + ' WHERE svc.SERVICE_STATUS = ''Retiree'' '
              + @Criteria;
                
  PRINT @Query;
  EXEC sp_executesql @Query,  N'@RetireeServiceStatusCount INT OUTPUT', @RetireeServiceStatusCount OUTPUT;                    
 
     
                                                         
-- Deployment Counts  
  SET @Query = 'WITH Deployments
  AS ( 
    SELECT 
        dply.REGISTRANT_ID ,
      CASE WHEN (SUM(CASE WHEN [DEPLOYMENT_COUNTRY] = ''Iraq'' 
                           AND [DEPLOYMENT_START_DATE] > ''20010911'' 
                           THEN 1 ELSE 0 END) )> 0 
           THEN 1 ELSE 0 END AS Iraq911Count,
      CASE WHEN (SUM(CASE WHEN [DEPLOYMENT_COUNTRY] = ''Afghanistan''  
                           AND [DEPLOYMENT_START_DATE] > ''20010911'' 
                          THEN 1 ELSE 0 END)) > 0
           THEN 1 ELSE 0 END AS Afgh911Count,              
      CASE WHEN (SUM(CASE WHEN [DEPLOYMENT_COUNTRY] = ''Djibouti''  
                           AND [DEPLOYMENT_START_DATE] > ''20010911'' 
                          THEN 1 ELSE 0 END)) > 0
           THEN 1 ELSE 0 END AS Djibouti911Count,              
      CASE WHEN (SUM(CASE WHEN [DEPLOYMENT_COUNTRY] IN (''Kuwait'',''Saudi Arabia'',''Bahrain'', ''Gulf of Aden'', ''Gulf of Oman'', ''Oman'', ''Qatar'', ''United Arab Emirates'', ''Persian Gulf'', ''Arabian Sea'', ''Red Sea'')
                           AND [DEPLOYMENT_START_DATE] > ''20010911'' 
                           THEN 1 ELSE 0 END)) > 0
           THEN 1 ELSE 0 END AS SWA911Count,
      CASE WHEN (SUM(CASE WHEN ([DEPLOYMENT_START_DATE] BETWEEN ''19900802'' AND ''20010911'' ) 
                           AND  [DEPLOYMENT_COUNTRY] IN (''Iraq'',''Kuwait'',''Saudi Arabia'',''Bahrain'', ''Gulf of Aden'', ''Gulf of Oman'', ''Oman'', ''Qatar'', ''United Arab Emirates'', ''Persian Gulf'', ''Arabian Sea'', ''Red Sea'')
                          THEN 1 ELSE 0 END)) > 0
           THEN 1 ELSE 0 END  AS Pre911Count
    FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] dply
        JOIN AHOBPR.REGISTRANT Reg ON Reg.REGISTRANT_ID = dply.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = dply.REGISTRANT_ID
        JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID   
	     WHERE 1 = 1 ' +
	     @Criteria +                
    ' GROUP BY dply.REGISTRANT_ID 
     )
     SELECT @Afgh911Count =  SUM(ISNULL(Deployments.Afgh911Count,0))  
           ,@Iraq911Count =  SUM(ISNULL(Deployments.Iraq911Count,0))
           ,@SWA911Count = SUM(ISNULL(Deployments.SWA911Count,0))
           ,@Pre911Count =   SUM(ISNULL(Deployments.Pre911Count,0))
           ,@Djibouti911Count = SUM(ISNULL(Deployments.Djibouti911Count,0))
      FROM Deployments' ;
      
  PRINT @Query;
  EXEC sp_executesql @Query,  
       N'@Afgh911Count INT OUTPUT, @Iraq911Count INT OUTPUT, @SWA911Count INT OUTPUT, @Pre911Count INT OUTPUT, @Djibouti911Count INT OUTPUT'
      , @Afgh911Count OUTPUT, @Iraq911Count OUTPUT, @SWA911Count OUTPUT, @Pre911Count OUTPUT, @Djibouti911Count OUTPUT;            

  
     CREATE TABLE #DaysToParticipant(DAYS INT);
   
    -- Median Days from Eligible to Participant Status    
    -- Note that only Registrants with Both values and DateParticipant > DateEligible will be counted for either Numerator or Denominator

    SET @Query = 'WITH eligible 
      AS ( 
          SELECT [REGISTRANT_ID],MIN([CREATED]) AS DateEligible
            FROM [AHOBPR].[PROCESS_METRICS]
           WHERE [PROCESS_METRICS_VALUE] = ''Eligible''
           GROUP BY [REGISTRANT_ID]
         ),
      participant 
      AS (
         SELECT [REGISTRANT_ID],MAX([CREATED]) AS DateParticipant
           FROM [AHOBPR].[PROCESS_METRICS]
          WHERE [PROCESS_METRICS_VALUE] = ''Participant''   
           GROUP BY [REGISTRANT_ID]
          )
     INSERT INTO #DaysToParticipant(DAYS)
    SELECT 
      CASE WHEN DateParticipant > DateEligible THEN DATEDIFF(Day,DateEligible,DateParticipant) ELSE 0 END AS DaysDifference
      FROM [AHOBPR].[REGISTRANT] reg
      JOIN eligible ON reg.REGISTRANT_ID = eligible.REGISTRANT_ID
      JOIN participant ON reg.REGISTRANT_ID = participant.REGISTRANT_ID   
      JOIN AHOBPR.FORM_RESPONSE resp ON resp.REGISTRANT_ID = reg.REGISTRANT_ID
      JOIN AHOBPR.FORM_RESPONSE_STATUS responseStat ON responseStat.FORM_RESPONSE_ID = resp.FORM_RESPONSE_ID ' +
    'WHERE 1 = 1 '  + @Criteria +  
   ' ORDER BY DaysDifference';

  PRINT @Query;
  EXECUTE(@Query);
     
    WITH Counts AS
    (
       SELECT c=COUNT(*)
       FROM #DaysToParticipant
    )
    SELECT @MedianDaysToParticipant = AVG(0. + DAYS)
    FROM Counts a
    CROSS APPLY
    (
       SELECT TOP(((a.c - 1) / 2) + (1 + (1 - a.c % 2)))
          DAYS, r=ROW_NUMBER() OVER (ORDER BY DAYS)
       FROM #DaysToParticipant b
       ORDER BY DAYS
    ) p
    WHERE r BETWEEN ((a.c - 1) / 2) + 1 AND (((a.c - 1) / 2) + (1 + (1 - a.c % 2))); 
         
    DROP  TABLE #DaysToParticipant;                   
 
 -- Return Results
   SELECT ISNULL(@ParticipantStatusCount,0) AS ParticipantStatusCount,
          ISNULL(@HealthConcernsCount,0) AS ReportedHealthConcernsCount,
          ISNULL(@NoHealthConcernsCount,0) AS  NoReportedHealthConcernsCount,
          ISNULL(@RequestSeenCount,0) AS RequestSeenCount,
          ISNULL(@NoRequestSeenCount,0) AS NoRequestSeenCount,
          ISNULL(@DoNotKnowRequestSeenCount,0) AS DoNotKnowRequestSeenCount,
          ISNULL(@VeteranServiceStatusCount,0) AS VeteranServiceStatusCount ,
          ISNULL(@ActiveDutyServiceStatusCount,0) AS  ActiveDutyServiceStatusCount,
          ISNULL(@RetireeServiceStatusCount,0) AS RetireeServiceStatusCount,
          ISNULL(@Afgh911Count,0) AS  Afgh911Count,
          ISNULL(@Iraq911Count,0) AS Iraq911Count,
          ISNULL(@SWA911Count,0) AS  SouthWestAsia911Count,
          ISNULL(@Pre911Count,0) AS  Pre911Count,
          ISNULL(@MedianDaysToParticipant,0.0) AS MedianDaysToParticipant,
          ISNULL(@Djibouti911Count,0) AS Djibouti911Count ;

END

-- exec [AHOBPR].[SP_ReportParticipation] @StartDate = '20150901'
-- exec [AHOBPR].[SP_ReportParticipation] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportParticipation] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportParticipation] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportParticipation] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportParticipation]
-- exec [AHOBPR].[SP_ReportParticipation] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportParticipation] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportParticipation] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportParticipation] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'




------------------------------------------------------------------------------------------

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_ReportRegistrantContact]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: Jan 12, 2015
-- Description:	Used for the AHOBPR Contact Report  -- exec [AHOBPR].[SP_ReportRegistrantContact]    (More options at bottom)
-- 2015-02-23 - Clegg - provide individual field names
-- 20150330 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 20150427 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 20150429 - Bruce Clegg - Added Email column (again)
-- 20150617 - D. Barr - Added state parameter
-- 20150722 - Bruce Clegg - Fix bug with @EvaluatedLocationType = 'Base'
-- 20150901 - Bruce Clegg Fix Main phone.  TYPE is not NULL so old way does not work
-- 20151028 - D. Barr - Changed input parameters
-- 2016-02-03 - D. Barr - Fixed logic on Evaluation Location (Script 2.0.32.1)
-- 2016-02-08 - D. Barr - Added logic from Dave to addressed performance of specific question query
-- 
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportRegistrantContact]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @state varchar(8000) = NULL, -- Multiple states, comma-separated values when not NULL   
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (8000) = NULL, -- Multiple subpopulationFlags, comma-separated values when not NULL  
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @contactPreference varchar(100) = '',
       @lastName varchar(50) = '',
       @ssn varchar(4) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @formBirthDateText varchar(100) = NULL,
       @email varchar(100) = 'All',
       @evaluation varchar(100) = 'All',
       @excludeAdminFlag varchar(1) = 'N'
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
          @formBirthDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);
  DECLARE @AnswerWith VARCHAR(8000) = '';    
  
 --registrant contact numbers
  CREATE TABLE #phone
  (
     [Registrant_Id] INT,
     [Phone] VARCHAR(50),
  ) 
  
   CREATE TABLE #mobile
  (
     [Registrant_Id] INT,
     [PhoneMobile] VARCHAR(50),
  )  
   INSERT INTO #phone ([Registrant_Id], [Phone])
  -- Load Table
  SELECT REGISTRANT_ID,		     
		       ISNULL(PHONE_NUMBER,'') 
      FROM AHOBPR.REGISTRANT_PHONE	
     WHERE ISNULL(TYPE,'') != 'Mobile'
     
          
 INSERT INTO #mobile ([Registrant_Id], [PhoneMobile])
  -- Load Table
  SELECT REGISTRANT_ID,		     
		       ISNULL(PHONE_NUMBER,'') 
      FROM AHOBPR.REGISTRANT_PHONE	
    WHERE TYPE = 'Mobile'
     
  
     
     
   
  CREATE TABLE #state
  (
     [Registrant_Id] INT,
     [state] VARCHAR(8000)
  ) 

  SET @state = REPLACE(@state, 'Foreign Country/Other', 'Foreign Country/Other,FM,MH,PW,UM,US,CANAD,MX,EU,PI,FG,OT,UN')

  INSERT INTO #state ([Registrant_Id], [state])
  -- Load Table
  SELECT a.REGISTRANT_ID, 
        STUFF((SELECT ', ' + b.STATE 
                 FROM AHOBPR.REGISTRANT_ADDRESS b 
                WHERE a.REGISTRANT_ID = b.REGISTRANT_ID 
                FOR XML PATH('')), 1, 1, '')  [STATE]
    FROM AHOBPR.REGISTRANT a
   GROUP BY a.REGISTRANT_ID;
   
                

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
	SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));
   SET @formBirthDate = dbo.CleanDate(@formBirthDateText); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
-- Set InstitutionID values if needed.
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = 'WITH SubPop AS ( SELECT a.REGISTRANT_ID, '+
                                             'STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                                     ' FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                                     ' JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                                    ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                                    '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) +
                                                      ' FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                                     ' FROM AHOBPR.REGISTRANT a ' +
                                     'WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = ', Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = ', Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',a.LAST_NAME AS LAST_NAME ' +
                            ',a.FIRST_NAME AS FIRST_NAME ' +
                            ',a.CONTACT_PREFERENCE AS ContactPreference ' +
                            ',regADDR.STREET1 AS STREET1 ' +
                            ',regADDR.STREET2 AS STREET2 ' +
                            ',regADDR.CITY AS CITY ' +
                            ',regADDR.STATE AS STATE ' +
                            ',regADDR.COUNTRY AS COUNTRY ' +
                            ',regADDR.ZIP AS ZIP ' +
                            ',regPhone.Phone AS  PHONE_NUMBER_Main' +
							',regMobile.PhoneMobile AS  PHONE_NUMBER_Mobile' +
                            ',regEmail.EMAIL AS EMAIL ';
                            
            
    
  SET @MainQuery = @MainQuery + 
		                            
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                                'LEFT JOIN #state s ' +  'ON a.REGISTRANT_ID = s.Registrant_Id ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.REGISTRANT_ADDRESS regAddr ON a.REGISTRANT_ID = regAddr.REGISTRANT_ID ' +
		                            ' LEFT JOIN #phone regPhone ON a.REGISTRANT_ID = regPhone.REGISTRANT_ID ' +
		                            ' LEFT JOIN #mobile regMobile ON a.REGISTRANT_ID = regMobile.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.REGISTRANT_EMAIL regEmail ON a.REGISTRANT_ID = regEmail.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';
                                
								  	      
    SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
  
	
  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
 BEGIN    
      SET @AnswerWith = '
, selectedAnswerInstance as
(
  select BRP_FORM_ANSWER_ID, A.STD_FORM_QUESTION_ID, Q.FORM_QUESTION_UNIQUE_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on Q.STD_FORM_QUESTION_ID = A.STD_FORM_QUESTION_ID
  where a.STD_FORM_ANSWER_ID IN (' + @answer + ')--user specified answer
)
, selectedAnswer as
(
  select STD_FORM_ANSWER_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on A.STD_FORM_QUESTION_ID = Q.STD_FORM_QUESTION_ID
  where EXISTS (select * from selectedAnswerInstance --1:39 w/o brp_form_answer_id index 0:37 with
                where A.BRP_FORM_ANSWER_ID      = selectedAnswerInstance.BRP_FORM_ANSWER_ID
                  and Q.FORM_QUESTION_UNIQUE_ID = selectedAnswerInstance.FORM_QUESTION_UNIQUE_ID
                )
) ';
    SET @MainQuery = @MainQuery +  '
  AND EXISTS(select *
              from AHOBPR.FORM_RESPONSE_ANSWER a 
              join selectedAnswer on selectedAnswer.STD_FORM_ANSWER_ID = a.STD_FORM_ANSWER_ID
              where a.FORM_RESPONSE_QUESTION_ID = formQuestion.FORM_RESPONSE_QUESTION_ID
            )'; 
  END;                                                       

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
     
  IF @formBirthDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND a.BIRTH_DATE = ''' + CONVERT(VARCHAR(20),@formBirthDate,121) + '''';
     
   

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

IF (ISNULL(@adminFlag,'') != '') 
	  IF (ISNULL(@excludeAdminFlag,'N') = 'N') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) '
      ELSE  
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';                                         
   IF (@email = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                        ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND em.EMAIL != '''') '
   ELSE IF (@email = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                        ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND em.EMAIL != '''') ' ;  
                          
  IF (@evaluation = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ; 
                     
                                                                  
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
               

                                                      
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';
  
  IF ISNULL(@state,'') > ''
    BEGIN
      SET @state = REPLACE(@State,',',''',''');
      SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT DISTINCT addr.REGISTRANT_ID ' + 
                                          'FROM AHOBPR.REGISTRANT_ADDRESS addr ' + 
                                         'WHERE addr.REGISTRANT_ID = a.REGISTRANT_ID ' + 
                                           'AND addr.STATE  IN ( ''' + @state + ''') ) ';
    END;  
          
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@contactPreference,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @contactPreference + ''' = ISNULL(a.CONTACT_PREFERENCE,''No Data Available'') ';
    
  IF ISNULL(@ssn,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RIGHT(a.SSN, 4) = ''' + @ssn  + '''';
  
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@lastName,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND RTRIM(LTRIM(a.LAST_NAME)) LIKE ''' + @lastName + ''''; 
    
  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
   
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
     
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith + @AnswerWith +  @MainQuery + @RegCriteria;          

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] 
-- EXECUTE [AHOBPR].[SP_ReportRegistrantContact] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @evaluation = 'N', @status = '7'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @contactPreference = 'Email from the VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @state = 'MD,VA'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage_changes] @formBirthDateText  = '19770707'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @subpopulationFlag = '85,87,89,105,106,91'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @deploymentAll = 'Egypt'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @adminFlag = '117', @excludeAdminFlag = 'Y' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_GetRegistrantSendMessage] @questionNumber = '5.4.A'  , @answer = '2221'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage]
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage]  @ssn = '1125'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_GetRegistrantSendMessage] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'


GO

/****** Object:  StoredProcedure [AHOBPR].[SP_ReportRegistrantStatusAging]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: Jan 8, 2015
-- Description:	Used for the AHOBPR Aging Report  -- exec [AHOBPR].[SP_ReportRegistrantStatusAging]    (More options at bottom)
-- Note: All 7 Registrant Status rows will be returned as possible values, so some rows may have all zeros.
-- 20150330 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 20150427 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 20150710 - Bruce Clegg - Rewrite using Dynamic SQL for Performance
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportRegistrantStatusAging]
       @AsOfDate              DATETIME2(0) = NULL,  
       @SvcStatus             VARCHAR(50)  = '',     -- 'Veteran', 'Retiree', 'Active Duty'
       @AssignedLocationType  VARCHAR(20)  = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50)  = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20)  = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50)  = NULL   -- 'V16', 'V01'    1000109,  1000089
AS
BEGIN

  SET @AsOfDate = dbo.AddMaxTime(ISNULL(@AsOfDate,GETDATE()));  -- adds 23:59:59

  DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0;

  DECLARE @Query VARCHAR(8000);

  IF @AssignedLocationType IN ('Base','Institution') 
  AND ISNUMERIC(@AssignedLocationKey) = 1
    SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
  IF @EvaluatedLocationType IN ('Base','Institution') 
  AND ISNUMERIC(@EvaluatedLocationKey) = 1
    SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

  SET @Query = 'WITH MostRecent AS ( ' +  
      'SELECT Metrics.REGISTRANT_ID,  ' +
             'MAX(Metrics.PROCESS_METRICS_ID) AS MaxMetricsID ' +
        'FROM [AHOBPR].[PROCESS_METRICS] Metrics ' +
        'JOIN AHOBPR.STD_PROCESS_METRICS_TYPE ProcessType ' +
          'ON ProcessType.STD_PROCESS_METRICS_TYPE_ID = Metrics.STD_PROCESS_METRICS_TYPE_ID ' +
       'WHERE ProcessType.PROCESS_METRICS = ''Registrant Status Change''  ' +
         'AND Metrics.CREATED <= ''' + CONVERT(VARCHAR(20),@AsOfDate,121) + ''' ' +
       'GROUP BY [REGISTRANT_ID] ' +
   '),  Stat   AS ( ' +
      'SELECT this.[REGISTRANT_ID],  ' +
             'this.PROCESS_METRICS_VALUE,  ' +
             'this.CREATED AS StatusDate, ' +
             'DATEDIFF(DAY, this.CREATED, ''' + CONVERT(VARCHAR(20),@AsOfDate,121) + ''') AS DaysDiff ' +
        'FROM [AHOBPR].[PROCESS_METRICS] this ' +
        'JOIN MostRecent ON MostRecent.MaxMetricsID = this.PROCESS_METRICS_ID ' +
    '),  Summary  AS (   ' +
      'SELECT Stat.PROCESS_METRICS_VALUE, ' +
             'SUM(CASE WHEN( Stat.DaysDiff < 31) THEN 1 ELSE 0 END) AS Age0to30, ' +
             'SUM(CASE WHEN( Stat.DaysDiff BETWEEN 31 AND 60) THEN 1 ELSE 0 END) AS Age31to60, ' +
             'SUM(CASE WHEN( Stat.DaysDiff BETWEEN 61 AND 90) THEN 1 ELSE 0 END) AS Age61to90, ' +
             'SUM(CASE WHEN( Stat.DaysDiff > 90) THEN 1 ELSE 0 END) AS Age91plus,  ' +
             'Count(*) AS TotalCount ' +
	      'FROM AHOBPR.REGISTRANT reg ' +
	      'JOIN Stat ON reg.REGISTRANT_ID = Stat.REGISTRANT_ID ' +
		    'JOIN AHOBPR.STD_SERVICE_STATUS svc ON svc.STD_SERVICE_STATUS_ID = reg.STD_SERVICE_STATUS_ID ' +
        'WHERE 1 = 1 ';

  IF ISNULL(@SvcStatus,'') != ''
    SET @Query = @Query + ' AND svc.SERVICE_STATUS = ''' + @SvcStatus + '''';
	            
  IF @AssignedLocationType = 'NLA' 
    SET @Query = @Query + ' AND reg.STD_INSTITUTION_ID IS NULL ';

  IF @AssignedLocationType = 'VISN' 
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                      ' WHERE inst.ID = reg.STD_INSTITUTION_ID ' +
                                         'AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
 	
  IF @AssignedLocationType = 'Base' 
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                       'WHERE inst.ID = reg.STD_INSTITUTION_ID ' +
                                         'AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ' ) ';
            	
  IF @AssignedLocationType = 'Institution' 
    SET @Query = @Query + ' AND reg.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ' '	
  
  IF @EvaluatedLocationType = 'NLA' 
    SET @Query = @Query + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                            'WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                               'AND eval.EVALUATION_FLAG = ''Y'' ) ';
          
  IF @EvaluatedLocationType = 'VISN' 
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                               'JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                             ' WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                                'AND inst.VisnID = ''' +  @EvaluatedLocationKey + ''' ' +
                                                'AND eval.EVALUATION_FLAG = ''Y'') ' ; 
         	
  IF @EvaluatedLocationType = 'Base' 
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                               'JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                             ' WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + 
             	                          ' AND eval.EVALUATION_FLAG = ''Y'') '; 
  IF @EvaluatedLocationType = 'Institution' 
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                      ' WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID '+
                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) +
                                        ' AND eval.EVALUATION_FLAG = ''Y'') '; 
           
                
  SET @Query = @Query + ' GROUP BY Stat.PROCESS_METRICS_VALUE  ) ' +       
    'SELECT Possible.ORDINAL_VALUE,  ' +
           'Possible.REGISTRANT_STATUS, ' +
           'ISNULL(Summary.Age0to30,0)    AS Age0to30, ' +
           'ISNULL(Summary.Age31to60, 0)  AS Age31to60, ' +
           'ISNULL(Summary.Age61to90, 0)  AS Age61to90, ' +
           'ISNULL(Summary.Age91plus, 0)  AS Age91plus, ' +
           'ISNULL(Summary.TotalCount, 0) AS TotalCount ' +
      'FROM [AHOBPR].[STD_REGISTRANT_STATUS] Possible ' +
      'LEFT JOIN Summary ON Summary.PROCESS_METRICS_VALUE = Possible.REGISTRANT_STATUS ' +
     ' ORDER BY Possible.ORDINAL_VALUE' + 
     ' OPTION (OPTIMIZE FOR UNKNOWN); ' ;
     
   PRINT @Query;
   
   EXECUTE(@Query);                             
END

-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] '20141130'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] '20150130', 'Veteran'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] '20150122', 'Retiree'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] '20150122', 'Active Duty'

-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130', @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130', @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130', @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130', @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130', @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130', @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130', @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportRegistrantStatusAging] @AsOfDate = '20150130', @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_ReportStatusByLocation]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Status by Location Report

-- Modification log
-- 20150114 - Sherry Wang: Changed query for @InstitutionId and @VisnId
-- 20150202 - Change state to use state codes, removed unneeded tables and joins, Removed Distinct
-- 20150219 - Change state to include territories and Military Bases
-- 20150330 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 20150427 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 20150722 - Bruce Clegg - Fix bug with @EvaluatedLocationType = 'Base'
-- 20150909 - Bruce Clegg - Rewrite as Dynamic SQL for Performance
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ReportStatusByLocation]
       @state varchar(8000) = NULL, -- Multiple states, comma-separated values when not NULL 
       @status varchar(1000) = NULL, -- Multiple statues, comma-separated values when not NULL        
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL  -- 'V16', 'V01'    1000109,  1000089
AS
BEGIN
  DECLARE @Today DATETIME2 = GETDATE();

  DECLARE @Query VARCHAR(8000);
 
   --Temp table concatnate flags for Registrants with multiple flags
  CREATE TABLE #state
  (
     [Registrant_Id] INT,
     [state] VARCHAR(8000)
  ) 

  SET @state = REPLACE(@state, 'Foreign Country/Other', 'FM,MH,PW,UM,US,CANAD,MX,EU,PI,FG,OT,UN')

  INSERT INTO #state ([Registrant_Id], [state])
  -- Load Table
  SELECT a.REGISTRANT_ID, 
        STUFF((SELECT ', ' + b.STATE 
                 FROM AHOBPR.REGISTRANT_ADDRESS b 
                WHERE a.REGISTRANT_ID = b.REGISTRANT_ID 
                FOR XML PATH('')), 1, 1, '')  [STATE]
    FROM AHOBPR.REGISTRANT a
   GROUP BY a.REGISTRANT_ID;
 
 
  SET @Query = 'SELECT  reg.REGISTRANT_ID ' +
		                   ',(reg.LAST_NAME + '', '' + reg.FIRST_NAME) AS Name ' +
		                   ',b.REGISTRANT_STATUS AS Status ' +
		                   ',DATEDIFF(day, reg.REGISTRANT_STATUS_LAST_UPDATED_DATE, ' +
		                   CONVERT(VARCHAR(10),@Today,121) + ') As Days ' +
		                   ',s.STATE AS State ' +
		                   ',RIGHT(inst.VisnID, 2)  AS VISN ' +
		                   ',inst.Name AS Facility ' +
		                   ',reg.BIRTH_DATE AS BirthDate ' +
                       ',CONVERT(VARCHAR(10), reg.BIRTH_DATE, 101) AS BirthDateDisplay ' +
	               'FROM AHOBPR.REGISTRANT reg ' +
		             'JOIN AHOBPR.STD_REGISTRANT_STATUS b ' + 
		               'ON reg.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	          'LEFT JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
		               'ON inst.ID = reg.STD_INSTITUTION_ID ' +
		        'LEFT JOIN #state s ' +
		               'ON reg.REGISTRANT_ID = s.Registrant_Id ' +
	              'WHERE  1 = 1 ';

	              
  IF ISNULL(@state,'') > ''
    BEGIN
      SET @state = REPLACE(@State,',',''',''');
      SET @Query = @Query + ' AND EXISTS(SELECT DISTINCT addr.REGISTRANT_ID ' + 
                                          'FROM AHOBPR.REGISTRANT_ADDRESS addr ' + 
                                         'WHERE addr.REGISTRANT_ID = reg.REGISTRANT_ID ' + 
                                           'AND addr.STATE  IN ( ''' + @state + ''') ) ';
    END;

  IF ISNULL(@status,'') > '' 
	 	 SET @Query = @Query + ' AND reg.STD_REGISTRANT_STATUS_ID IN (' + @status + ') ';
	 	 
  IF @AssignedLocationType = 'NLA' 
     SET @Query = @Query + ' AND reg.STD_INSTITUTION_ID IS NULL ';

  IF @AssignedLocationType = 'VISN' 
     SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                        'WHERE inst.ID = reg.STD_INSTITUTION_ID ' +
                                          'AND inst.VisnID = ''' + @AssignedLocationKey + ''' ) ';

  IF @AssignedLocationType = 'Base' 
     SET @Query = @Query + 'AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                       'WHERE inst.ID = reg.STD_INSTITUTION_ID ' +
                                         'AND inst.BASE_ID = ' + @AssignedLocationKey + ') ';

  IF @AssignedLocationType = 'Institution' 
     SET @Query = @Query + 'AND reg.STD_INSTITUTION_ID = ' + @AssignedLocationKey + ' ';            

  IF @EvaluatedLocationType = 'NLA' 
      SET @Query = @Query + 'AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                          '   WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                              ' AND eval.EVALUATION_FLAG = ''Y'') ';
 
  IF @EvaluatedLocationType = 'VISN' 
     SET @Query = @Query + 'AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                               'JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                              'WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                                'AND inst.VisnID = ''' + @EvaluatedLocationKey + ''' ' +
                                                'AND eval.EVALUATION_FLAG = ''Y'') ' 

  IF @EvaluatedLocationType = 'Base' 
     SET @Query = @Query + 'AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                               'JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                              'WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                                'AND inst.BASE_ID = ' + @EvaluatedLocationKey + ' ' + 
                                                'AND eval.EVALUATION_FLAG = ''Y'' ) '; 

  IF @EvaluatedLocationType = 'Institution' 
     SET @Query = @Query + 'AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                              'WHERE eval.REGISTRANT_ID = Reg.REGISTRANT_ID ' +
                                                'AND eval.STD_INSTITUTION_ID = ' + @EvaluatedLocationKey + ' ' +
                                                'AND eval.EVALUATION_FLAG = ''Y'' ) '; 

  PRINT  @Query;
  
  EXECUTE (@Query);  

  DROP TABLE #state;
  
END

-- EXEC [AHOBPR].[SP_ReportStatusByLocation] 
-- EXEC [AHOBPR].[SP_ReportStatusByLocation] @state = 'MD,VA'
-- EXEC [AHOBPR].[SP_ReportStatusByLocation] @status = '6,7'

-- exec [AHOBPR].[SP_ReportStatusByLocation]
-- exec [AHOBPR].[SP_ReportStatusByLocation] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportStatusByLocation] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportStatusByLocation] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportStatusByLocation] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportStatusByLocation]
-- exec [AHOBPR].[SP_ReportStatusByLocation] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportStatusByLocation] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportStatusByLocation] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportStatusByLocation] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_ResetDatabase]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
-- =============================================
-- Author:		Sherry Wang
-- Create date: 6/12/2015
-- Description:	Called to reset database
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_ResetDatabase]
AS

DECLARE @registrantId int
DECLARE @registrantCursor CURSOR
SET @registrantCursor = CURSOR FAST_FORWARD
	FOR
	SELECT REGISTRANT_ID FROM AHOBPR.REGISTRANT 
	WHERE USER_ID IN (SELECT OBJECT_ID FROM AHOBPR.REGISTRANT_JSON)
BEGIN

	OPEN @registrantCursor
	FETCH NEXT FROM @registrantCursor INTO @registrantId
	WHILE @@FETCH_STATUS = 0
		BEGIN
			exec ahobpr.SP_DeleteRegistrantAndResponse @registrantId
			
			FETCH NEXT FROM @registrantCursor INTO @registrantId
		END
	CLOSE @registrantCursor
	DEALLOCATE @registrantCursor

	DELETE FROM [AHOBPR].[JSON_queue]
	DELETE FROM [AHOBPR].[REGISTRANT_JSON] WHERE OBJECT_TYPE <> 'form'

END

-- EXEC [AHOBPR].[SP_ResetDatabase]

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_Test]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO

CREATE PROCEDURE [AHOBPR].[SP_Test]
       @RegistrantId INT = 0, @firstName varchar(50) = NULL, @lastName varchar(50) = NULL
AS
BEGIN
	UPDATE AHOBPR.REGISTRANT
	SET FIRST_NAME = @firstName, LAST_NAME = @lastName
	WHERE REGISTRANT_ID = @RegistrantId
	
	SELECT FIRST_NAME, MIDDLE_NAME, LAST_NAME FROM AHOBPR.REGISTRANT WHERE REGISTRANT_ID = @RegistrantId
END

-- EXEC [AHOBPR].[SP_Test] 33, 'Jane', 'Mary', 'Smith'

GO
/****** Object:  StoredProcedure [AHOBPR].[SP_UpdateFromCDW]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 6/12/2015
-- Description:	Called after loading CDW Staging tables
-- 08/12/2015 - Set Gender to MALE and FEMALE
-- 09/08/2015 - Only set Gender and ICN if Registrant value is NULL
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_UpdateFromCDW]
AS
BEGIN

  DECLARE @Now DATETIME2(0) = GETDATE();
  DECLARE @ProcName VARCHAR(30) = 'AHOBPR.SP_UpdateFromCDW';

  PRINT 'Set Institution ID in Staged Patient';
  
  WITH Src
  AS(
  SELECT REGISTRANT_ID
	    ,PreferredInstitutionCode
	    ,Inst.ID
    FROM [AHOBPR].[STAGED_PATIENT] Stg
    JOIN AHOBPR.VIEW_INSTITUTION Inst ON Inst.STATIONNUMBER = Stg.PreferredInstitutionCode
    )
    MERGE INTO [AHOBPR].[STAGED_PATIENT] AS Tgt
    USING Src
	   ON Tgt.REGISTRANT_ID = Src.REGISTRANT_ID
    WHEN MATCHED
    THEN UPDATE
		    SET Tgt.STD_INSTITUTION_ID = Src.ID;
  
  PRINT 'Update Registrant from staged patient...';

  WITH Src
  AS (
    SELECT reg.REGISTRANT_ID
          ,ISNULL(reg.GENDER,CASE pat.GENDER WHEN 'F' THEN 'FEMALE' 
 		                                       WHEN 'M' THEN 'MALE' END) as GENDER 
          ,pat.DECEASED
          ,pat.DateOfDeath
          ,pat.RaceText
          ,pat.MaritalStatus
          ,pat.EligibilityStatus
          ,pat.Eligibility
          ,ISNULL(reg.ICN,pat.PatientICN) AS PatientICN
          ,pat.EnrollmentStatus
          ,pat.PreferredInstitutionCode
          ,pat.EnrollmentDate
          ,pat.STD_INSTITUTION_ID
      FROM [AHOBPR].[STAGED_PATIENT] pat
      JOIN [AHOBPR].[REGISTRANT] reg ON reg.REGISTRANT_ID = pat.REGISTRANT_ID
      )
      MERGE INTO [AHOBPR].[REGISTRANT] AS Tgt
      USING Src
	     ON Tgt.REGISTRANT_ID = Src.REGISTRANT_ID
      WHEN MATCHED
      THEN UPDATE
		      SET Tgt.STD_INSTITUTION_ID = Src.STD_INSTITUTION_ID
 		         ,Tgt.GENDER = Src.GENDER    
 		         ,Tgt.MARITAL_STATUS = Src.[MaritalStatus] 
 		         ,Tgt.RACE = Src.[RaceText]  
 		         ,Tgt.DECEASED_FLAG = CONVERT(BIT,(CASE Src.[DECEASED] WHEN 'Y' THEN 1 ELSE 0 END))
 		         ,Tgt.DEATH_DATE = Src.[DateOfDeath]    
 		         ,Tgt.ELIGIBILITY_STATUS = Src.[EligibilityStatus]     		        
 		         ,Tgt.ELIGIBILITY = Src.[Eligibility]    
 		         ,Tgt.ENROLLMENT_STATUS = Src.[EnrollmentStatus]    
 		         ,Tgt.ENROLLED_DATE = Src.[EnrollmentDate]       
 		         ,Tgt.ETL_UPDATED = @Now;
  		    
  PRINT 'Delete health factors for encounters being updated';
  DELETE 
  FROM AHOBPR.REGISTRANT_HEALTH_FACTOR
  WHERE EXISTS(SELECT REGISTRANT_VISIT_ID 
                 FROM AHOBPR.REGISTRANT_VISIT
                 JOIN AHOBPR.STAGED_VISIT ON STAGED_VISIT.REGISTRANT_ID = REGISTRANT_VISIT.REGISTRANT_ID
                WHERE REGISTRANT_VISIT.REGISTRANT_VISIT_ID = REGISTRANT_HEALTH_FACTOR.REGISTRANT_VISIT_ID
                  AND STAGED_VISIT.EVALUATION_FLAG = 'Y');
                  
  PRINT 'Delete encouters being updated';

  DELETE 
  FROM AHOBPR.REGISTRANT_VISIT
  WHERE EVALUATION_FLAG = 'Y'
    AND EXISTS(SELECT REGISTRANT_ID FROM AHOBPR.STAGED_VISIT
                WHERE STAGED_VISIT.REGISTRANT_ID = REGISTRANT_VISIT.REGISTRANT_ID
                AND STAGED_VISIT.EVALUATION_FLAG = 'Y');

  PRINT 'Delete recent visits being updated';              

  DELETE 
  FROM AHOBPR.REGISTRANT_VISIT
  WHERE EVALUATION_FLAG = 'N'
    AND EXISTS(SELECT REGISTRANT_ID FROM AHOBPR.STAGED_VISIT
                WHERE STAGED_VISIT.REGISTRANT_ID = REGISTRANT_VISIT.REGISTRANT_ID
                AND STAGED_VISIT.EVALUATION_FLAG = 'N');               		      
  
  PRINT 'Set Institution ID in Staged VISIT';
  
  WITH Src
  AS(
  SELECT Stg.VisitSID
        ,Stg.INSTITUTION_CODE
        ,Inst.ID
    FROM [AHOBPR].[STAGED_VISIT] Stg
    JOIN AHOBPR.VIEW_INSTITUTION Inst ON Inst.STATIONNUMBER = Stg.INSTITUTION_CODE
    )
    MERGE INTO [AHOBPR].[STAGED_VISIT] AS Tgt
    USING Src
	   ON Tgt.VisitSID = Src.VisitSID
    WHEN MATCHED
    THEN UPDATE
		    SET Tgt.STD_INSTITUTION_ID = Src.ID;		    
		    
  PRINT 'Insert encounters and visits...';              

  INSERT INTO [AHOBPR].[REGISTRANT_VISIT]
             ([REGISTRANT_ID]
             ,[VISIT_DATE_TIME]
             ,[STD_INSTITUTION_ID]
             ,[VISTA_EncounterID]
             ,[VISTA_Sta3n]
             ,[VISTA_EligibilityStatus]
             ,[EVALUATION_FLAG]
             ,[APPOINTMENT_TYPE]
             ,[STOP_CODE]
             ,[CREATEDBY]
             ,[UPDATEDBY]
             ,[CREATED]
             ,[UPDATED])
      SELECT [REGISTRANT_ID]
            ,[VISIT_DATE_TIME]
            ,[STD_INSTITUTION_ID]
            ,[VISTA_EncounterID]
            ,[VISTA_Sta3n]
            ,[VISTA_Eligibility]
            ,[EVALUATION_FLAG]
            ,[APPOINTMENT_TYPE]
            ,[STOP_CODE]
            ,@ProcName
            ,@ProcName
            ,@Now
            ,@Now
    FROM [AHOBPR].[STAGED_VISIT];		    
 
  PRINT 'Set Standard Health Factors ID from STD_HEALTH_FACTOR...';  
    
  WITH Src
   AS(
      SELECT [CDW_VISIT_SID]
            ,[REGISTRANT_ID]
            ,std.[STD_HEALTH_FACTOR_ID]
            ,[HEALTH_FACTOR_TEXT]      
        FROM [AHOBPR].[STAGED_HEALTH_FACTOR] staged
        JOIN AHOBPR.STD_HEALTH_FACTOR std ON std.NAME = staged.HEALTH_FACTOR_TEXT
    )
    MERGE INTO AHOBPR.[STAGED_HEALTH_FACTOR] AS Tgt
    USING Src  ON Tgt.[CDW_VISIT_SID] = Src.[CDW_VISIT_SID]
    WHEN MATCHED
             AND Tgt.[REGISTRANT_ID] = Src.[REGISTRANT_ID]
             AND Tgt.[HEALTH_FACTOR_TEXT] = Src.[HEALTH_FACTOR_TEXT]
    THEN UPDATE
		    SET Tgt.[STD_HEALTH_FACTOR_ID] = Src.[STD_HEALTH_FACTOR_ID];
 
   PRINT 'Insert Health Factors...';  
   
  INSERT INTO [AHOBPR].[REGISTRANT_HEALTH_FACTOR]
             ([REGISTRANT_VISIT_ID]
             ,[STD_HEALTH_FACTOR_ID]
             ,[ACTIVE_FLAG]
             ,[HEALTH_FACTOR_TEXT]
             ,[COMMENTS]
             ,[CREATEDBY]
             ,[UPDATEDBY]
             ,[CREATED]
             ,[UPDATED])          
      SELECT visit.REGISTRANT_VISIT_ID
            ,hf.[STD_HEALTH_FACTOR_ID]
            ,1
            ,hf.[HEALTH_FACTOR_TEXT]
            ,hf.[COMMENTS]
            ,@ProcName    
            ,@ProcName
            ,@Now
            ,@Now     
    FROM [AHOBPR].[STAGED_HEALTH_FACTOR] hf -- 295
    JOIN AHOBPR.STAGED_VISIT stage ON stage.VisitSID = hf.CDW_VISIT_SID
    JOIN AHOBPR.REGISTRANT_VISIT visit ON visit.VISTA_EncounterID = stage.VISTA_EncounterID 

END;
-- EXECUTE [AHOBPR].[SP_UpdateFromCDW]; 


GO
/****** Object:  StoredProcedure [AHOBPR].[SP_UpdateRegistrantResponse]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
-- =============================================
-- Author:		Bruce Clegg
-- Create date: 4/24/2015
-- Description:	Called after loading Response
-- =============================================
CREATE PROCEDURE [AHOBPR].[SP_UpdateRegistrantResponse]
       @registrantId INT = NULL 
AS
BEGIN

  UPDATE AHOBPR.REGISTRANT
     SET [REQUEST_SEEN_RESPONSE] = ( 
                                    SELECT SUBSTRING(ISNULL(d.TEXT,''),1,50) as ResponseText
                                      FROM AHOBPR.FORM_RESPONSE r
                                      JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
                                      JOIN AHOBPR.STD_FORM_QUESTION b  ON a.STD_FORM_QUESTION_ID = b.STD_FORM_QUESTION_ID
                                      JOIN AHOBPR.FORM_RESPONSE_ANSWER c ON a.FORM_RESPONSE_QUESTION_ID = c.FORM_RESPONSE_QUESTION_ID
                                      JOIN AHOBPR.STD_FORM_ANSWER d ON c.STD_FORM_ANSWER_ID = d.STD_FORM_ANSWER_ID
                                     WHERE  r.REGISTRANT_ID = @registrantId
                                       AND b.FORM_QUESTION_UNIQUE_ID = '7.B'
                                       AND r.STD_FORM_ID = b.STD_FORM_ID
                                   ),
       [HEALTH_CONCERNS_RESPONSE] = (
                                      SELECT Distinct d.TEXT
                                        FROM AHOBPR.FORM_RESPONSE r
                                        JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
                                        JOIN AHOBPR.STD_FORM_QUESTION b    ON a.STD_FORM_QUESTION_ID = b.STD_FORM_QUESTION_ID
                                        JOIN AHOBPR.FORM_RESPONSE_ANSWER c ON a.FORM_RESPONSE_QUESTION_ID = c.FORM_RESPONSE_QUESTION_ID
                                        JOIN AHOBPR.STD_FORM_ANSWER d      ON c.STD_FORM_ANSWER_ID = d.STD_FORM_ANSWER_ID
                                       WHERE  r.REGISTRANT_ID = @registrantId
                                         AND b.FORM_QUESTION_UNIQUE_ID IN ('3.A','3.B','3.C','3.D','3.E','3.F','3.G','3.H','3.I','3.J','3.K') 
                                         AND d.TEXT = 'Yes'       
                                   ),
        [CONTACT_PREFERENCE] =     (
                                      SELECT SUBSTRING(d.TEXT,1,100)
                                        FROM AHOBPR.FORM_RESPONSE r
                                        JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
                                        JOIN AHOBPR.STD_FORM_QUESTION b    ON a.STD_FORM_QUESTION_ID = b.STD_FORM_QUESTION_ID
                                        JOIN AHOBPR.FORM_RESPONSE_ANSWER c ON a.FORM_RESPONSE_QUESTION_ID = c.FORM_RESPONSE_QUESTION_ID
                                        JOIN AHOBPR.STD_FORM_ANSWER d      ON c.STD_FORM_ANSWER_ID = d.STD_FORM_ANSWER_ID
                                       WHERE  r.REGISTRANT_ID = @registrantId
                                         AND b.FORM_QUESTION_UNIQUE_ID = '8.A'
                                   )                                                              
  WHERE REGISTRANT_ID = @registrantId;

END;
-- EXECUTE [AHOBPR].[SP_UpdateRegistrantResponse]  105

GO
------------------------------------------------------
-- Functions
------------------------------------------------------

/****** Object:  UserDefinedFunction [AHOBPR].[GetAppPageId]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO

CREATE FUNCTION [AHOBPR].[GetAppPageId](
   @code varchar(1000)
)
RETURNS INT
AS
BEGIN
	declare @result INT = 0;
	SET @result = (SELECT ID FROM STD_APPPAGE WHERE Code = @code);
	return @result;
END

GO
/****** Object:  UserDefinedFunction [AHOBPR].[GetStateCodeByID]    Script Date: 7/21/2016 12:58:49 PM ******/
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE FUNCTION [AHOBPR].[GetStateCodeByID](
   @stateId varchar(1000)
)
RETURNS varchar(2000)
AS
BEGIN
	declare @result varchar(2000) = '';
	IF ISNULL(@stateId, '') = ''
		BEGIN
			SET @result = 'AK,AR,AZ,CA,CO,CT,DE,FL,GA,HI,IA,ID,IL,IN,KS,KY,LA,MA,MD,ME,MI,MN,MO,MS,MT,NC,ND,NE,NH,NJ,NM,NV,NY,OH,OK,OR,PA,RI,SC,SD,TN,TX,UT,VA,VT,WA,WI,WV,WY';
		END
	ELSE
	  BEGIN
			DECLARE @state varchar(100);

			DECLARE curState CURSOR 
			  FOR
				SELECT POSTALNAME
				FROM dbo.STD_STATE
				WHERE ID IN (SELECT * FROM fncSplit(@stateId, ','));

			OPEN curState;
			FETCH NEXT FROM curState INTO @state;
			WHILE @@FETCH_STATUS = 0  -- Not End of file
			  BEGIN
				  if  @result != ''
					  SET @result = @result + ','
  				
				  SET @result = @result + @state;
  				
				  FETCH NEXT FROM curState INTO @state;			
			  END		
			CLOSE curState;   
			DEALLOCATE curState;    
	  END 
	return @result;
END;

GO
-------------------------------------------------

PRINT N'Checking existing data against newly created constraints';


GO
USE [$(DatabaseName)];


GO
ALTER TABLE [AHOBPR].[EMAIL_LOG] WITH CHECK CHECK CONSTRAINT [FK_EMAIL_LOG_REGISTRANT];


GO
-------------------------------------------------
-- Complete
-------------------------------------------------

delete from [dbo].[DatabaseChangeLog]
where [MajorReleaseNumber]  = '3'
    and [MinorReleaseNumber]  = '0'
    and [PointReleaseNumber]  = '19'
    and TargetRegistry        = 'AHOBPR';
    
PRINT 'Rollback complete.';